/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common;

import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryException;
import org.freebxml.omar.common.BindingUtility;
import org.freebxml.omar.common.CredentialInfo;
import org.freebxml.omar.common.QueryManager;
import org.freebxml.omar.common.RegistryResponseHolder;
import org.freebxml.omar.common.RepositoryItem;
import org.freebxml.omar.common.RepositoryItemImpl;
import org.freebxml.omar.common.SOAPMessenger;
import org.freebxml.omar.common.Utility;
import org.oasis.ebxml.registry.bindings.query.AdhocQueryRequest;
import org.oasis.ebxml.registry.bindings.query.AdhocQueryRequestType;
import org.oasis.ebxml.registry.bindings.query.AdhocQueryResponseType;
import org.oasis.ebxml.registry.bindings.query.ResponseOption;
import org.oasis.ebxml.registry.bindings.query.ResponseOptionType;
import org.oasis.ebxml.registry.bindings.query.ReturnType;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;
import org.oasis.ebxml.registry.bindings.rim.UserType;
import org.oasis.ebxml.registry.bindings.rs.RegistryResponseType;

public class QueryManagerSOAPProxy
implements QueryManager {
    private String registryURL;
    private CredentialInfo credentialInfo;
    private SOAPMessenger msgr;

    public QueryManagerSOAPProxy(String registryURL, CredentialInfo credentialInfo) {
        this.msgr = new SOAPMessenger(registryURL, credentialInfo);
    }

    public AdhocQueryResponseType submitAdhocQuery(UserType user, AdhocQueryRequestType req) throws RegistryException {
        try {
            RegistryResponseHolder resp = this.submitAdhocQueryInternal(user, req);
            RegistryResponseType ebResp = resp.getRegistryResponse();
            return (AdhocQueryResponseType)ebResp;
        }
        catch (JAXRException e) {
            throw new RegistryException((Throwable)e);
        }
    }

    private RegistryResponseHolder submitAdhocQueryInternal(UserType user, AdhocQueryRequestType req) throws RegistryException {
        RegistryResponseHolder resp = null;
        try {
            StringWriter sw = new StringWriter();
            Marshaller marshaller = BindingUtility.getInstance().queryFac.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)req, (Writer)sw);
            resp = this.msgr.sendSoapRequest(sw.toString());
            RegistryResponseType ebResp = resp.getRegistryResponse();
            BindingUtility.getInstance().checkRegistryResponse(ebResp);
            return resp;
        }
        catch (JAXBException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (JAXRException e) {
            throw new RegistryException((Throwable)e);
        }
    }

    public RegistryObjectType getRegistryObject(String id) throws RegistryException {
        return this.getRegistryObject(id, "RegistryObject");
    }

    public RegistryObjectType getRegistryObject(String id, String typeName) throws RegistryException {
        RegistryObjectType ro = null;
        try {
            typeName = Utility.getInstance().mapTableName(typeName);
            String queryStr = "SELECT * from " + typeName + " WHERE id='" + id + "'";
            AdhocQueryRequest req = BindingUtility.getInstance().createAdhocQueryRequest(queryStr);
            ResponseOption respOption = BindingUtility.getInstance().queryFac.createResponseOption();
            respOption.setReturnComposedObjects(true);
            respOption.setReturnType(ReturnType.LEAF_CLASS);
            req.setResponseOption((ResponseOptionType)respOption);
            UserType user = null;
            RegistryResponseHolder respHolder = this.submitAdhocQueryInternal(user, (AdhocQueryRequestType)req);
            List results = respHolder.getCollection();
            if (results.size() == 1) {
                ro = (RegistryObjectType)results.get(0);
            }
        }
        catch (JAXRException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new RegistryException((Throwable)e);
        }
        return ro;
    }

    public RepositoryItem getRepositoryItem(String id) throws RegistryException {
        RepositoryItemImpl repositoryItem = null;
        try {
            String queryStr = "SELECT * from ExtrinsicObject WHERE id='" + id + "'";
            AdhocQueryRequest req = BindingUtility.getInstance().createAdhocQueryRequest(queryStr);
            ResponseOption respOption = BindingUtility.getInstance().queryFac.createResponseOption();
            respOption.setReturnComposedObjects(true);
            respOption.setReturnType(ReturnType.LEAF_CLASS_WITH_REPOSITORY_ITEM);
            req.setResponseOption((ResponseOptionType)respOption);
            UserType user = null;
            RegistryResponseHolder respHolder = this.submitAdhocQueryInternal(user, (AdhocQueryRequestType)req);
            HashMap attachmentsMap = respHolder.getAttachmentsMap();
            if (attachmentsMap != null && attachmentsMap.containsKey(id)) {
                repositoryItem = new RepositoryItemImpl(id, (DataHandler)attachmentsMap.get(id));
            }
        }
        catch (JAXRException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new RegistryException((Throwable)e);
        }
        return repositoryItem;
    }

    public UserType getUser(X509Certificate cert) throws RegistryException {
        throw new RegistryException("Unimplemented");
    }
}

