/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices13.servlet.WSAddressingFeaturesTestUsingDDs;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.Handler_Util;
import com.sun.ts.tests.jaxws.wsa.common.ActionNotSupportedException;
import com.sun.ts.tests.jaxws.wsa.common.AddressingPropertyException;
import com.sun.ts.tests.jaxws.wsa.common.WsaBaseSOAPHandler;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;

public class ClientSOAPHandler
extends WsaBaseSOAPHandler {
    @Override
    protected void checkInboundAction(SOAPMessageContext context, String oper, String action) {
        TestUtil.logMsg((String)("ClientSOAPHandler.checkInboundAction: [operation=" + oper + ", input action=" + action + "]"));
        if (Handler_Util.checkForMsg((MessageContext)context, "VerifyAddrHeadersExistForRequiredEchoPort")) {
            this.checkAddressingHeadersExist(context, action);
        } else if (Handler_Util.checkForMsg((MessageContext)context, "VerifyAddrHeadersDoNotExistForDisabledEchoPort")) {
            this.checkAddressingHeadersDoNotExist(context, action);
        } else if (Handler_Util.checkForMsg((MessageContext)context, "VerifyAddrHeadersDoNotExistForDisabledEcho2Port")) {
            this.checkAddressingHeadersDoNotExist(context, action);
        } else if (Handler_Util.checkForMsg((MessageContext)context, "VerifyAddrHeadersMayExistForEnabledEchoPort")) {
            this.checkAddressingHeadersMayExist(context, action);
        } else if (Handler_Util.checkForMsg((MessageContext)context, "VerifyAddrHeadersMayExistForEnabledEcho2Port")) {
            this.checkAddressingHeadersMayExist(context, action);
        } else if (Handler_Util.checkForMsg((MessageContext)context, "testAnonymousResponsesAssertion")) {
            this.VerifyAddressingHeadersForAnonymousResponsesAssertion(context, action);
        } else if (Handler_Util.checkForMsg((MessageContext)context, "testNonAnonymousResponsesAssertion")) {
            this.VerifyAddressingHeadersForNonAnonymousResponsesAssertion(context, action);
        }
    }

    private void verifyAction(String action) {
        if (!action.equals("EchoOutputAction")) {
            throw new ActionNotSupportedException("Expected:EchoOutputAction, Actual:" + action);
        }
    }

    private void checkAddressingHeadersExist(SOAPMessageContext context, String action) {
        TestUtil.logMsg((String)"ClientSOAPHandler.checkAddressingHeadersExist");
        this.verifyAction(action);
        this.checkInboundToExist(context);
        this.checkInboundRelatesToExist(context);
    }

    private void checkAddressingHeadersDoNotExist(SOAPMessageContext context, String action) {
        TestUtil.logMsg((String)"ClientSOAPHandler.checkAddressingHeadersDoNotExist");
        this.checkActionDoesNotExist(action);
        this.checkInboundToDoesNotExist(context);
        this.checkInboundRelatesToDoesNotExist(context);
    }

    private void checkAddressingHeadersMayExist(SOAPMessageContext context, String action) {
        TestUtil.logMsg((String)"ClientSOAPHandler.checkAddressingHeadersMayExist");
        if (action != null) {
            this.verifyAction(action);
            this.checkInboundToExist(context);
            this.checkInboundRelatesToExist(context);
        }
    }

    private void handleMessageInboundCheckAddressingHeadersDoNotExist(SOAPMessageContext context) {
        String headerValue = null;
        String whichHeaders = null;
        try {
            headerValue = this.getTo(context);
            whichHeaders = whichHeaders + "wsa:To, ";
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            headerValue = this.getReplyTo(context);
            whichHeaders = whichHeaders + "wsa:ReplyTo, ";
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            headerValue = this.getMessageId(context);
            whichHeaders = whichHeaders + "wsa:MessageId, ";
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            headerValue = this.getRelationship(context);
            whichHeaders = whichHeaders + "wsa:Relationship, ";
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            headerValue = this.getAction(context);
            whichHeaders = whichHeaders + "wsa:Action";
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (whichHeaders != null) {
            throw new AddressingPropertyException("ERROR: The following addressing headers exist in soap message: [" + whichHeaders + "]");
        }
    }

    @Override
    protected String getAction(SOAPMessageContext context) throws SOAPException {
        String testName = (String)context.get((Object)"test.name");
        TestUtil.logMsg((String)("ClientSOAPHandler.getAction(): testName=" + testName));
        if (testName == null) {
            return super.getAction(context);
        }
        if (testName.equals("VerifyAddrHeadersExistForRequiredEchoPort")) {
            return super.getAction(context);
        }
        if (testName.equals("VerifyAddrHeadersDoNotExistForDisabledEchoPort") || testName.equals("VerifyAddrHeadersDoNotExistForDisabledEcho2Port")) {
            return super.getActionDoesNotExist(context);
        }
        if (testName.equals("VerifyAddrHeadersMayExistForEnabledEchoPort") || testName.equals("VerifyAddrHeadersMayExistForEnabledEcho2Port")) {
            try {
                return super.getAction(context);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (testName.equals("testAnonymousResponsesAssertion")) {
            return super.getAction(context);
        }
        if (testName.equals("testNonAnonymousResponsesAssertion")) {
            return super.getAction(context);
        }
        return null;
    }

    private void VerifyAddressingHeadersForAnonymousResponsesAssertion(SOAPMessageContext context, String action) {
        TestUtil.logMsg((String)"ClientSOAPHandler.VerifyAddressingHeadersForAnonymousResponsesAssertion");
        if (!"EchoOutputAction".equals(action)) {
            throw new ActionNotSupportedException("Expected:EchoOutputAction, Actual:" + action);
        }
        String to = null;
        try {
            to = this.getTo(context);
            TestUtil.logMsg((String)("[To=" + to + "]"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (to != null && !to.equals("http://www.w3.org/2005/08/addressing/anonymous") && !to.equals("http://www.w3.org/2005/08/addressing/none")) {
            throw new AddressingPropertyException("Expected: wsa:To=http://www.w3.org/2005/08/addressing/anonymous or http://www.w3.org/2005/08/addressing/none, Actual: wsa:To=" + to);
        }
        try {
            String relatesTo = this.getRelatesTo(context);
            TestUtil.logMsg((String)("[RelatesTo=" + relatesTo + "]"));
        }
        catch (Exception e) {
            throw new AddressingPropertyException("wsa:RelatesTo was not set (unexpected)");
        }
    }

    private void VerifyAddressingHeadersForNonAnonymousResponsesAssertion(SOAPMessageContext context, String action) {
        TestUtil.logMsg((String)"ClientSOAPHandler.VerifyAddressingHeadersForNonAnonymousResponsesAssertion");
        if (!"EchoOutputAction".equals(action)) {
            throw new ActionNotSupportedException("Expected:EchoOutputAction, Actual:" + action);
        }
        String to = null;
        try {
            to = this.getTo(context);
            TestUtil.logMsg((String)("[To=" + to + "]"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (to != null && to.equals("http://www.w3.org/2005/08/addressing/anonymous")) {
            throw new AddressingPropertyException("Expected: wsa:To=!http://www.w3.org/2005/08/addressing/anonymous, Actual: wsa:To=" + to);
        }
        try {
            String relatesTo = this.getRelatesTo(context);
            TestUtil.logMsg((String)("[RelatesTo=" + relatesTo + "]"));
        }
        catch (Exception e) {
            throw new AddressingPropertyException("wsa:RelatesTo was not set (unexpected)");
        }
    }
}

