/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonValueType;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonAssert {
    private static boolean assertEquals(JsonObject expected, JsonObject actual, String message) {
        if (actual.equals(expected)) {
            return true;
        }
        TestUtil.logMsg((String)("   " + message));
        TestUtil.logMsg((String)("     Expected: " + JSONP_Util.toStringJsonObject(expected)));
        TestUtil.logMsg((String)("     Actual:   " + JSONP_Util.toStringJsonObject(actual)));
        return false;
    }

    private static boolean assertEquals(JsonArray expected, JsonArray actual, String message) {
        if (actual.equals(expected)) {
            return true;
        }
        TestUtil.logMsg((String)("   " + message));
        TestUtil.logMsg((String)("     Expected: " + JSONP_Util.toStringJsonArray(expected)));
        TestUtil.logMsg((String)("     Actual:   " + JSONP_Util.toStringJsonArray(actual)));
        return false;
    }

    private static boolean assertEquals(JsonString expected, JsonString actual, String message) {
        if (actual.equals((Object)expected)) {
            return true;
        }
        TestUtil.logMsg((String)("   " + message));
        TestUtil.logMsg((String)("     Expected: " + expected.getString()));
        TestUtil.logMsg((String)("     Actual:   " + actual.getString()));
        return false;
    }

    private static boolean assertEquals(JsonNumber expected, JsonNumber actual, String message) {
        if (actual.equals((Object)expected)) {
            return true;
        }
        TestUtil.logMsg((String)("   " + message));
        TestUtil.logMsg((String)("     Expected: " + expected.toString()));
        TestUtil.logMsg((String)("     Actual:   " + actual.toString()));
        return false;
    }

    public static boolean assertEquals(JsonValue expected, JsonValue actual, String message) {
        switch (expected.getValueType()) {
            case OBJECT: {
                return JsonAssert.assertEquals((JsonObject)expected, (JsonObject)actual, message);
            }
            case ARRAY: {
                return JsonAssert.assertEquals((JsonArray)expected, (JsonArray)actual, message);
            }
            case STRING: {
                return JsonAssert.assertEquals((JsonString)expected, (JsonString)actual, message);
            }
            case NUMBER: {
                return JsonAssert.assertEquals((JsonNumber)expected, (JsonNumber)actual, message);
            }
            case TRUE: 
            case FALSE: {
                if (expected == actual) {
                    return true;
                }
                TestUtil.logMsg((String)("   " + message));
                TestUtil.logMsg((String)("     Expected: " + expected.toString()));
                TestUtil.logMsg((String)("     Actual:   " + actual.toString()));
                return false;
            }
        }
        if (actual.equals(expected)) {
            return true;
        }
        TestUtil.logMsg((String)("   " + message));
        TestUtil.logMsg((String)("     Expected: " + expected.toString()));
        TestUtil.logMsg((String)("     Actual:   " + actual.toString()));
        return false;
    }

    public static boolean assertEquals(JsonValue expected, JsonValue actual) {
        return JsonAssert.assertEquals(expected, actual, "JSON mismatch");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean assertEquals(Object expected, String actual) {
        if (actual == null) {
            return true;
        }
        try {
            switch (JsonValueType.getType(expected)) {
                case String: {
                    String exp = '\"' + (String)expected + '\"';
                    return exp.equals(actual);
                }
                case Integer: {
                    if (Integer.parseInt(actual) != (Integer)expected) return false;
                    return true;
                }
                case Long: {
                    if (Long.parseLong(actual) != (Long)expected) return false;
                    return true;
                }
                case BigInteger: {
                    return new BigInteger(actual).equals(expected);
                }
                case Double: {
                    if (Double.parseDouble(actual) != (Double)expected) return false;
                    return true;
                }
                case BigDecimal: {
                    return new BigDecimal(actual).equals(expected);
                }
                case Boolean: {
                    if (Boolean.parseBoolean(actual) != (Boolean)expected) return false;
                    return true;
                }
                case JsonValue: {
                    try (JsonReader reader = Json.createReader((Reader)new StringReader(actual));){
                        JsonValue actVal = reader.readValue();
                        boolean bl = JsonAssert.assertEquals((JsonValue)expected, actVal);
                        return bl;
                    }
                }
                case Null: {
                    try (JsonReader reader = Json.createReader((Reader)new StringReader(actual));){
                        JsonValue actVal = reader.readValue();
                        boolean bl = JsonAssert.assertEquals(JsonValue.NULL, actVal);
                        return bl;
                    }
                }
            }
            throw new IllegalArgumentException("Value does not match known JSON value type");
        }
        catch (NumberFormatException ex) {
            return true;
        }
    }

    public static String valueToString(JsonValue value) {
        switch (value.getValueType()) {
            case OBJECT: {
                return JSONP_Util.toStringJsonObject((JsonObject)value);
            }
            case ARRAY: {
                return JSONP_Util.toStringJsonArray((JsonArray)value);
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
            case NUMBER: {
                return ((JsonNumber)value).toString();
            }
            case TRUE: {
                return Boolean.toString(true);
            }
            case FALSE: {
                return Boolean.toString(false);
            }
            case NULL: {
                return "null";
            }
        }
        throw new IllegalArgumentException("Unknown value type");
    }
}

