/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.exceptions;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.exceptions.Coffee;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.LockTimeoutException;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockException;
import jakarta.persistence.Query;
import jakarta.persistence.QueryTimeoutException;
import jakarta.persistence.RollbackException;
import jakarta.persistence.TransactionRequiredException;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            TestUtil.logTrace((String)"Cleanup data");
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void TransactionRequiredExceptionTest() throws EETest.Fault {
        boolean pass = false;
        Coffee newCoffee = new Coffee(Integer.valueOf(1), "hazelnut", 1.0f);
        try {
            TestUtil.logTrace((String)"Invoked persist without an active transaction");
            this.getEntityManager().persist((Object)newCoffee);
        }
        catch (TransactionRequiredException tre) {
            pass = true;
            TestUtil.logTrace((String)("In JavaEE, Exception Caught as Expected: " + (Object)((Object)tre)));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass && this.isStandAloneMode()) {
            TestUtil.logTrace((String)"In JavaSE, Exception Not Thrown as Expected");
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault("TransactionRequiredExceptionTest failed");
        }
    }

    public void TransactionRequiredException2Test() throws EETest.Fault {
        TestUtil.logTrace((String)"Test TransactionRequiredExceptionNullMsg");
        boolean pass = true;
        try {
            throw new TransactionRequiredException();
        }
        catch (TransactionRequiredException eee) {
            TestUtil.logTrace((String)"TransactionRequiredException Caught as Expected");
            if (eee.getMessage() != null) {
                TestUtil.logErr((String)("TransactionRequiredException should have had null message, actual message=" + eee.getMessage()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
            pass = false;
        }
        TestUtil.logMsg((String)"Test TransactionRequiredExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new TransactionRequiredException(expected);
        }
        catch (TransactionRequiredException eee) {
            TestUtil.logTrace((String)"TransactionRequiredException Caught as Expected");
            String msg = eee.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    TestUtil.logErr((String)("Expected=" + msg + ", Actual=" + msg));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"TransactionRequiredException returned null message");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("TransactionRequiredException2Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin exceptionTest2");
        Coffee newCoffee = new Coffee(Integer.valueOf(2), "french roast", 9.0f);
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)newCoffee);
            this.getEntityTransaction().commit();
            TestUtil.logTrace((String)"try flush");
            this.getEntityManager().flush();
        }
        catch (TransactionRequiredException tre) {
            pass = true;
            TestUtil.logTrace((String)("Exception Caught as Expected: " + (Object)((Object)tre)));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception :", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("exceptionTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionTest3() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin exceptionTest3");
        boolean pass = false;
        Coffee newCoffee = new Coffee(Integer.valueOf(3), "french roast", 9.0f);
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Persist Coffee ");
            this.getEntityManager().persist((Object)newCoffee);
            this.getEntityTransaction().commit();
            TestUtil.logTrace((String)"Call refresh without an active transaction");
            this.getEntityManager().refresh((Object)newCoffee);
        }
        catch (TransactionRequiredException tre) {
            pass = true;
            TestUtil.logTrace((String)("Exception Caught as Expected: " + (Object)((Object)tre)));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected Exception Caught rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass && this.isStandAloneMode()) {
            TestUtil.logTrace((String)"In JavaSE, Exception Not Thrown as Expected");
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault("exceptionTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionTest4() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin exceptionTest4");
        Coffee newCoffee = new Coffee(Integer.valueOf(5), "breakfast blend", 3.0f);
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)newCoffee);
            this.getEntityTransaction().commit();
            TestUtil.logTrace((String)"Call remove without an active transaction");
            this.getEntityManager().remove((Object)newCoffee);
        }
        catch (TransactionRequiredException tre) {
            pass = true;
            TestUtil.logTrace((String)("Exception Caught as Expected: " + (Object)((Object)tre)));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected Exception Caught rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass && this.isStandAloneMode()) {
            TestUtil.logTrace((String)"In JavaSE, Exception Not Thrown as Expected");
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault("exceptionTest4 failed");
        }
    }

    public void exceptionTest5() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin exceptionTest5");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().close();
            this.getEntityTransaction().commit();
        }
        catch (IllegalStateException ise) {
            pass = true;
            TestUtil.logTrace((String)("Exception Caught as Expected: " + ise));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected Exception Caught rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass && this.isStandAloneMode()) {
            TestUtil.logTrace((String)"In JavaSE, Exception Not Thrown as Expected");
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault("exceptionTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionTest6() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin exceptionTest6");
        boolean pass = false;
        Coffee newCoffee = new Coffee(Integer.valueOf(7), "cinnamon", 7.0f);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)newCoffee);
            this.clearCache();
            if (!this.getEntityManager().contains((Object)newCoffee)) {
                this.getEntityManager().refresh((Object)newCoffee);
            } else {
                TestUtil.logTrace((String)"Entity is managed, cannot proceed with test");
            }
            this.getEntityTransaction().commit();
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            TestUtil.logTrace((String)("Exception Caught as Expected: " + iae));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("exceptionTest6 failed");
        }
    }

    public void RollbackExceptionTest() throws EETest.Fault {
        TestUtil.logMsg((String)"Test RollbackExceptionNullMsg");
        boolean pass = true;
        try {
            throw new RollbackException();
        }
        catch (RollbackException re) {
            TestUtil.logTrace((String)"RollbackException Caught as Expected");
            if (re.getMessage() != null) {
                pass = false;
                TestUtil.logErr((String)("RollbackException should have had null message, actual message=" + re.getMessage()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
            pass = false;
        }
        TestUtil.logMsg((String)"Test RollbackExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new RollbackException(expected);
        }
        catch (RollbackException re) {
            TestUtil.logTrace((String)"RollbackException Caught as Expected");
            String msg = re.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"RollbackException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test RollbackExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new RollbackException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (RollbackException re) {
            TestUtil.logTrace((String)"RollbackException Caught as Expected");
            String msg = re.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = re.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (!msg.equals(expected2)) {
                            pass = false;
                            TestUtil.logErr((String)("Expected Throwable msg=" + msg + ", Actual=" + msg));
                        }
                    } else {
                        pass = false;
                        TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
                    }
                } else {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"RollbackException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test RollbackExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new RollbackException((Throwable)new IllegalAccessException(expected));
        }
        catch (RollbackException re) {
            TestUtil.logTrace((String)"RollbackException Caught as Expected");
            Throwable t = re.getCause();
            if (t instanceof IllegalAccessException) {
                String msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected Throwable msg=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("RollbackExceptionTest failed");
        }
    }

    public void EntityExistsExceptionTest() throws EETest.Fault {
        TestUtil.logMsg((String)"Test EntityExistsExceptionNullMsg");
        boolean pass = true;
        try {
            throw new EntityExistsException();
        }
        catch (EntityExistsException eee) {
            TestUtil.logTrace((String)"EntityExistsException Caught as Expected");
            if (eee.getMessage() != null) {
                pass = false;
                TestUtil.logErr((String)("EntityExistsException should have had null message, actual message=" + eee.getMessage()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
            pass = false;
        }
        TestUtil.logMsg((String)"Test EntityExistskExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new EntityExistsException(expected);
        }
        catch (EntityExistsException eee) {
            TestUtil.logTrace((String)"EntityExistsException Caught as Expected");
            String msg = eee.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"EntityExistsException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test EntityExistsExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new EntityExistsException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (EntityExistsException eee) {
            TestUtil.logTrace((String)"EntityExistsException Caught as Expected");
            String msg = eee.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = eee.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (!msg.equals(expected2)) {
                            pass = false;
                            TestUtil.logErr((String)("Expected Throwable msg=" + msg + ", Actual=" + msg));
                        }
                    } else {
                        pass = false;
                        TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
                    }
                } else {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"EntityExistsException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test EntityExistsExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new EntityExistsException((Throwable)new IllegalAccessException(expected));
        }
        catch (EntityExistsException eee) {
            TestUtil.logTrace((String)"EntityExistsException Caught as Expected");
            Throwable t = eee.getCause();
            if (t instanceof IllegalAccessException) {
                String msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected Throwable msg=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("EntityExistsExceptionTest failed");
        }
    }

    public void EntityNotFoundExceptionTest() throws EETest.Fault {
        TestUtil.logMsg((String)"Test EntityNotFoundExceptionNullMsg");
        boolean pass = true;
        try {
            throw new EntityNotFoundException();
        }
        catch (EntityNotFoundException enf) {
            TestUtil.logTrace((String)"EntityNotFoundException Caught as Expected");
            if (enf.getMessage() != null) {
                pass = false;
                TestUtil.logErr((String)("EntityNotFoundException should have had null message, actual message=" + enf.getMessage()));
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test EntityNotFoundExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new EntityNotFoundException(expected);
        }
        catch (EntityNotFoundException enf) {
            TestUtil.logTrace((String)"EntityNotFoundException Caught as Expected");
            String msg = enf.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"EntityNotFoundException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("EntityNotFoundExceptionTest failed");
        }
    }

    public void OptimisticLockExceptionTest() throws EETest.Fault {
        String msg;
        TestUtil.logMsg((String)"Test OptimisticLockExceptionNullMsg");
        boolean pass = true;
        try {
            throw new OptimisticLockException();
        }
        catch (OptimisticLockException ole) {
            TestUtil.logTrace((String)"OptimisticLockException Caught as Expected");
            if (ole.getMessage() != null) {
                pass = false;
                TestUtil.logErr((String)("OptimisticLockException should have had null message, actual message=" + ole.getMessage()));
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test OptimisticLockExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new OptimisticLockException(expected);
        }
        catch (OptimisticLockException ole) {
            TestUtil.logTrace((String)"OptimisticLockException Caught as Expected");
            String msg2 = ole.getMessage();
            if (msg2 != null) {
                if (!msg2.equals(expected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg2 + ", Actual=" + msg2));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"OptimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test OptimisticLockExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new OptimisticLockException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (OptimisticLockException ole) {
            TestUtil.logTrace((String)"OptimisticLockException Caught as Expected");
            String msg3 = ole.getMessage();
            if (msg3 != null) {
                if (msg3.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg3 = t.getMessage();
                        if (!msg3.equals(expected2)) {
                            pass = false;
                            TestUtil.logErr((String)("Expected Throwable msg=" + msg3 + ", Actual=" + msg3));
                        }
                    } else {
                        pass = false;
                        TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
                    }
                } else {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg3 + ", Actual=" + msg3));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"OptimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test OptimisticLockExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new OptimisticLockException((Throwable)new IllegalAccessException(expected));
        }
        catch (OptimisticLockException ole) {
            TestUtil.logTrace((String)"OptimisticLockException Caught as Expected");
            Throwable t = ole.getCause();
            if (t instanceof IllegalAccessException) {
                msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected Throwable msg=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test OptimisticLockExceptionObjectMsg");
        Coffee cExpected = new Coffee(Integer.valueOf(1), "hazelnut", 1.0f);
        try {
            throw new OptimisticLockException((Object)cExpected);
        }
        catch (OptimisticLockException ol) {
            TestUtil.logTrace((String)"OptimisticLockException Caught as Expected");
            Coffee c = (Coffee)ol.getEntity();
            if (c != null) {
                if (!c.equals((Object)cExpected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + cExpected + ", Actual=" + c));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"OptimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test OptimisticLockExceptionStringThrowableObject");
        expected = "This is the String message";
        expected2 = "This is the Throwable message";
        cExpected = new Coffee(Integer.valueOf(1), "hazelnut", 1.0f);
        try {
            throw new OptimisticLockException(expected, (Throwable)new IllegalAccessException(expected2), (Object)cExpected);
        }
        catch (OptimisticLockException ole) {
            TestUtil.logTrace((String)"OptimisticLockException Caught as Expected");
            msg = ole.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (msg.equals(expected2)) {
                            Coffee c = (Coffee)ole.getEntity();
                            if (!c.equals((Object)cExpected)) {
                                pass = false;
                                TestUtil.logErr((String)("Expected Entity=" + cExpected + ", Actual=" + c));
                            }
                        } else {
                            pass = false;
                            TestUtil.logErr((String)("Expected Throwable msg=" + msg + ", Actual=" + msg));
                        }
                    } else {
                        pass = false;
                        TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
                    }
                } else {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"OptimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("OptimisticLockExceptionTest failed");
        }
    }

    public void PersistenceExceptionTest() throws EETest.Fault {
        TestUtil.logMsg((String)"Test PersistenceExceptionNullMsg");
        boolean pass = true;
        try {
            throw new PersistenceException();
        }
        catch (PersistenceException eee) {
            TestUtil.logTrace((String)"PersistenceException Caught as Expected");
            if (eee.getMessage() != null) {
                pass = false;
                TestUtil.logErr((String)("PersistenceException should have had null message, actual message=" + eee.getMessage()));
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test EntityExistskExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new PersistenceException(expected);
        }
        catch (PersistenceException eee) {
            TestUtil.logTrace((String)"PersistenceException Caught as Expected");
            String msg = eee.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"PersistenceException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test PersistenceExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new PersistenceException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (PersistenceException eee) {
            TestUtil.logTrace((String)"PersistenceException Caught as Expected");
            String msg = eee.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = eee.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (!msg.equals(expected2)) {
                            pass = false;
                            TestUtil.logErr((String)("Expected Throwable msg=" + msg + ", Actual=" + msg));
                        }
                    } else {
                        pass = false;
                        TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
                    }
                } else {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"PersistenceException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test PersistenceExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new PersistenceException((Throwable)new IllegalAccessException(expected));
        }
        catch (PersistenceException eee) {
            TestUtil.logTrace((String)"PersistenceException Caught as Expected");
            Throwable t = eee.getCause();
            if (t instanceof IllegalAccessException) {
                String msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected Throwable msg=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("PersistenceExceptionTest failed");
        }
    }

    public void LockTimeoutExceptionTest() throws EETest.Fault {
        String msg;
        TestUtil.logMsg((String)"Test LockTimeoutExceptionNullMsg");
        boolean pass = true;
        try {
            throw new LockTimeoutException();
        }
        catch (LockTimeoutException ole) {
            TestUtil.logTrace((String)"LockTimeoutException Caught as Expected");
            if (ole.getMessage() != null) {
                pass = false;
                TestUtil.logErr((String)("LockTimeoutException should have had null message, actual message=" + ole.getMessage()));
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test LockTimeoutExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new LockTimeoutException(expected);
        }
        catch (LockTimeoutException ole) {
            TestUtil.logTrace((String)"LockTimeoutException Caught as Expected");
            String msg2 = ole.getMessage();
            if (msg2 != null) {
                if (!msg2.equals(expected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg2 + ", Actual=" + msg2));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"LockTimeoutException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test LockTimeoutExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new LockTimeoutException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (LockTimeoutException ole) {
            TestUtil.logTrace((String)"LockTimeoutException Caught as Expected");
            String msg3 = ole.getMessage();
            if (msg3 != null) {
                if (msg3.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg3 = t.getMessage();
                        if (!msg3.equals(expected2)) {
                            pass = false;
                            TestUtil.logErr((String)("Expected Throwable msg=" + msg3 + ", Actual=" + msg3));
                        }
                    } else {
                        pass = false;
                        TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
                    }
                } else {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg3 + ", Actual=" + msg3));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"LockTimeoutException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test LockTimeoutExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new LockTimeoutException((Throwable)new IllegalAccessException(expected));
        }
        catch (LockTimeoutException ole) {
            TestUtil.logTrace((String)"LockTimeoutException Caught as Expected");
            Throwable t = ole.getCause();
            if (t instanceof IllegalAccessException) {
                msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected Throwable msg=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test LockTimeoutExceptionObjectMsg");
        Coffee cExpected = new Coffee(Integer.valueOf(1), "hazelnut", 1.0f);
        try {
            throw new LockTimeoutException((Object)cExpected);
        }
        catch (LockTimeoutException ol) {
            TestUtil.logTrace((String)"LockTimeoutException Caught as Expected");
            Coffee c = (Coffee)ol.getObject();
            if (c != null) {
                if (!c.equals((Object)cExpected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + cExpected + ", Actual=" + c));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"LockTimeoutException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test LockTimeoutExceptionStringThrowableObject");
        expected = "This is the String message";
        expected2 = "This is the Throwable message";
        cExpected = new Coffee(Integer.valueOf(1), "hazelnut", 1.0f);
        try {
            throw new LockTimeoutException(expected, (Throwable)new IllegalAccessException(expected2), (Object)cExpected);
        }
        catch (LockTimeoutException ole) {
            TestUtil.logTrace((String)"LockTimeoutException Caught as Expected");
            msg = ole.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (msg.equals(expected2)) {
                            Coffee c = (Coffee)ole.getObject();
                            if (!c.equals((Object)cExpected)) {
                                pass = false;
                                TestUtil.logErr((String)("Expected Entity=" + cExpected + ", Actual=" + c));
                            }
                        } else {
                            pass = false;
                            TestUtil.logErr((String)("Expected Throwable msg=" + msg + ", Actual=" + msg));
                        }
                    } else {
                        pass = false;
                        TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
                    }
                } else {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"LockTimeoutException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("LockTimeoutExceptionTest failed");
        }
    }

    public void PessimisticLockExceptionTest() throws EETest.Fault {
        String msg;
        TestUtil.logMsg((String)"Test PessimisticLockExceptionNullMsg");
        boolean pass = true;
        try {
            throw new PessimisticLockException();
        }
        catch (PessimisticLockException ole) {
            TestUtil.logTrace((String)"PessimisticLockException Caught as Expected");
            if (ole.getMessage() != null) {
                pass = false;
                TestUtil.logErr((String)("PessimisticLockException should have had null message, actual message=" + ole.getMessage()));
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test PessimisticLockExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new PessimisticLockException(expected);
        }
        catch (PessimisticLockException ole) {
            TestUtil.logTrace((String)"PessimisticLockException Caught as Expected");
            String msg2 = ole.getMessage();
            if (msg2 != null) {
                if (!msg2.equals(expected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg2 + ", Actual=" + msg2));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"PessimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test PessimisticLockExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new PessimisticLockException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (PessimisticLockException ole) {
            TestUtil.logTrace((String)"PessimisticLockException Caught as Expected");
            String msg3 = ole.getMessage();
            if (msg3 != null) {
                if (msg3.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg3 = t.getMessage();
                        if (!msg3.equals(expected2)) {
                            pass = false;
                            TestUtil.logErr((String)("Expected Throwable msg=" + msg3 + ", Actual=" + msg3));
                        }
                    } else {
                        pass = false;
                        TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
                    }
                } else {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg3 + ", Actual=" + msg3));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"PessimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test PessimisticLockExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new PessimisticLockException((Throwable)new IllegalAccessException(expected));
        }
        catch (PessimisticLockException ole) {
            TestUtil.logTrace((String)"PessimisticLockException Caught as Expected");
            Throwable t = ole.getCause();
            if (t instanceof IllegalAccessException) {
                msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected Throwable msg=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test PessimisticLockExceptionObjectMsg");
        Coffee cExpected = new Coffee(Integer.valueOf(1), "hazelnut", 1.0f);
        try {
            throw new PessimisticLockException((Object)cExpected);
        }
        catch (PessimisticLockException ol) {
            TestUtil.logTrace((String)"PessimisticLockException Caught as Expected");
            Coffee c = (Coffee)ol.getEntity();
            if (c != null) {
                if (!c.equals((Object)cExpected)) {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + cExpected + ", Actual=" + c));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"PessimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        TestUtil.logMsg((String)"Test PessimisticLockExceptionStringThrowableObject");
        expected = "This is the String message";
        expected2 = "This is the Throwable message";
        cExpected = new Coffee(Integer.valueOf(1), "hazelnut", 1.0f);
        try {
            throw new PessimisticLockException(expected, (Throwable)new IllegalAccessException(expected2), (Object)cExpected);
        }
        catch (PessimisticLockException ole) {
            TestUtil.logTrace((String)"PessimisticLockException Caught as Expected");
            msg = ole.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (msg.equals(expected2)) {
                            Coffee c = (Coffee)ole.getEntity();
                            if (!c.equals((Object)cExpected)) {
                                pass = false;
                                TestUtil.logErr((String)("Expected Entity=" + cExpected + ", Actual=" + c));
                            }
                        } else {
                            pass = false;
                            TestUtil.logErr((String)("Expected Throwable msg=" + msg + ", Actual=" + msg));
                        }
                    } else {
                        pass = false;
                        TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
                    }
                } else {
                    pass = false;
                    TestUtil.logErr((String)("Expected=" + msg + ", Actual=" + msg));
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"PessimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("PessimisticLockExceptionTest failed");
        }
    }

    public void QueryTimeoutExceptionTest() throws EETest.Fault {
        TestUtil.logMsg((String)"Begin QueryTimeoutExceptionNullMsgTest");
        boolean pass = true;
        try {
            throw new QueryTimeoutException();
        }
        catch (QueryTimeoutException ole) {
            TestUtil.logTrace((String)"QueryTimeoutException Caught as Expected");
            if (ole.getMessage() != null) {
                TestUtil.logErr((String)("QueryTimeoutException should have had null message, actual message=" + ole.getMessage()));
                pass = false;
            }
            TestUtil.logMsg((String)"Test QueryTimeoutExceptionStringMsg");
            String expected = "This is the String message";
            try {
                throw new QueryTimeoutException(expected);
            }
            catch (QueryTimeoutException ole2) {
                TestUtil.logTrace((String)"QueryTimeoutException Caught as Expected");
                String msg = ole2.getMessage();
                if (msg != null) {
                    if (!msg.equals(expected)) {
                        TestUtil.logErr((String)("Expected=" + msg + ", Actual=" + msg));
                        pass = false;
                    }
                } else {
                    TestUtil.logErr((String)"QueryTimeoutException returned null message");
                    pass = false;
                }
                TestUtil.logMsg((String)"Test QueryTimeoutExceptionStringThrowable");
                expected = "This is the String message";
                String expected2 = "This is the Throwable message";
                try {
                    throw new QueryTimeoutException(expected, (Throwable)new IllegalAccessException(expected2));
                }
                catch (QueryTimeoutException ole3) {
                    TestUtil.logTrace((String)"QueryTimeoutException Caught as Expected");
                    String msg2 = ole3.getMessage();
                    if (msg2 != null) {
                        if (msg2.equals(expected)) {
                            Throwable t = ole3.getCause();
                            if (t instanceof IllegalAccessException) {
                                msg2 = t.getMessage();
                                if (!msg2.equals(expected2)) {
                                    TestUtil.logErr((String)("Expected Throwable msg=" + msg2 + ", Actual=" + msg2));
                                    pass = false;
                                }
                            } else {
                                TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
                                pass = false;
                            }
                        } else {
                            TestUtil.logErr((String)("Expected=" + msg2 + ", Actual=" + msg2));
                            pass = false;
                        }
                    } else {
                        TestUtil.logErr((String)"QueryTimeoutException returned null message");
                        pass = false;
                    }
                    TestUtil.logMsg((String)"Test QueryTimeoutExceptionThrowable");
                    expected = "This is the Throwable message";
                    try {
                        throw new QueryTimeoutException((Throwable)new IllegalAccessException(expected));
                    }
                    catch (QueryTimeoutException qte) {
                        String msg3;
                        TestUtil.logTrace((String)"QueryTimeoutException Caught as Expected");
                        Throwable t = qte.getCause();
                        if (t instanceof IllegalAccessException) {
                            msg3 = t.getMessage();
                            if (msg3 != null) {
                                if (!msg3.equals(expected)) {
                                    TestUtil.logErr((String)("Expected Throwable msg=" + msg3 + ", Actual=" + msg3));
                                    pass = false;
                                }
                            } else {
                                TestUtil.logErr((String)"t.getMessage() returned null");
                                pass = false;
                            }
                        } else {
                            TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t));
                            pass = false;
                        }
                        TestUtil.logMsg((String)"Begin QueryTimeoutExceptionObjectMsgTest");
                        Query qExpected = this.getEntityManager().createQuery("select c from Coffee c");
                        try {
                            throw new QueryTimeoutException(qExpected);
                        }
                        catch (QueryTimeoutException qte2) {
                            TestUtil.logTrace((String)"QueryTimeoutException Caught as Expected");
                            Query q = qte2.getQuery();
                            if (q != null) {
                                if (q.equals(qExpected)) {
                                    pass = true;
                                } else {
                                    TestUtil.logErr((String)("Expected=" + expected + ", Actual=" + q));
                                    pass = false;
                                }
                            } else {
                                TestUtil.logErr((String)"QueryTimeoutException returned null message");
                                pass = false;
                            }
                            TestUtil.logMsg((String)"Test QueryTimeoutExceptionStringThrowableObject");
                            expected = "This is the String message";
                            expected2 = "This is the Throwable message";
                            qExpected = this.getEntityManager().createQuery("select c from Coffee c");
                            try {
                                throw new QueryTimeoutException(expected, (Throwable)new IllegalAccessException(expected2), qExpected);
                            }
                            catch (QueryTimeoutException qte3) {
                                TestUtil.logTrace((String)"QueryTimeoutException Caught as Expected");
                                msg3 = qte3.getMessage();
                                if (msg3 != null) {
                                    if (msg3.equals(expected)) {
                                        Throwable t2 = qte3.getCause();
                                        if (t2 instanceof IllegalAccessException) {
                                            msg3 = t2.getMessage();
                                            if (msg3 != null) {
                                                if (msg3.equals(expected2)) {
                                                    Query q2 = qte3.getQuery();
                                                    if (q2 != null) {
                                                        if (!q2.equals(qExpected)) {
                                                            TestUtil.logErr((String)("Expected Entity=" + qExpected + ", Actual=" + q2));
                                                            pass = false;
                                                        }
                                                    } else {
                                                        TestUtil.logErr((String)"getQuery returned null");
                                                        pass = false;
                                                    }
                                                } else {
                                                    TestUtil.logErr((String)("Expected Throwable msg=" + msg3 + ", Actual=" + msg3));
                                                    pass = false;
                                                }
                                            } else {
                                                TestUtil.logErr((String)"t.getMessage returned null");
                                                pass = false;
                                            }
                                        } else {
                                            TestUtil.logErr((String)("getCause did not return an instance of IllegalAccessException, instead got " + t2));
                                            pass = false;
                                        }
                                    } else {
                                        TestUtil.logErr((String)("Expected=" + msg3 + ", Actual=" + msg3));
                                        pass = false;
                                    }
                                } else {
                                    TestUtil.logErr((String)"QueryTimeoutException returned null message");
                                    pass = false;
                                }
                            }
                            catch (Exception e) {
                                TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
                                pass = false;
                            }
                            if (!pass) {
                                throw new EETest.Fault("QueryTimeoutExceptionTest failed");
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    public void NonUniqueResultExceptionTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logMsg((String)"Begin NonUniqueResultExceptionNullMsgTest");
        try {
            throw new NonUniqueResultException();
        }
        catch (NonUniqueResultException nure) {
            TestUtil.logTrace((String)"NonUniqueResultException Caught as Expected");
            if (nure.getMessage() != null) {
                TestUtil.logErr((String)("NonUniqueResultException should have had null message, actual message=" + nure.getMessage()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
            pass = false;
        }
        TestUtil.logTrace((String)"Testing NonUniqueResultExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new NonUniqueResultException(expected);
        }
        catch (NonUniqueResultException ole) {
            TestUtil.logTrace((String)"NonUniqueResultException Caught as Expected");
            String msg = ole.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    TestUtil.logErr((String)("Expected=" + msg + ", Actual=" + msg));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"NonUniqueResultException returned null message");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("NonUniqueResultExceptionTest failed");
        }
    }

    public void NoResultExceptionTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logMsg((String)"Testing NoResultExceptionNullMsg");
        try {
            throw new NoResultException();
        }
        catch (NoResultException nre) {
            TestUtil.logTrace((String)"NoResultException Caught as Expected");
            if (nre.getMessage() != null) {
                TestUtil.logErr((String)("NoResultException should have had null message, actual message=" + nre.getMessage()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
            pass = false;
        }
        TestUtil.logMsg((String)"Testing NoResultExceptionStringMsgTest");
        String expected = "This is the String message";
        try {
            throw new NoResultException(expected);
        }
        catch (NoResultException nre) {
            TestUtil.logTrace((String)"NoResultException Caught as Expected");
            String msg = nre.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    TestUtil.logErr((String)("Expected=" + msg + ", Actual=" + msg));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"NoResultException returned null message");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("NoResultExceptionTest failed");
            }
            return;
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        if (this.getEntityManager().isOpen()) {
            this.removeTestData();
        }
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM COFFEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

