/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.sec.stateless.sec;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.sec.stateless.common.SecTest;
import com.sun.ts.tests.ejb30.sec.stateless.common.SecTestRoleRef;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBException;
import java.util.Properties;

public class Client
extends EETest {
    @EJB(beanName="SecTestEJB")
    private static SecTest ejb1ref = null;
    @EJB(beanName="SecTestRoleRefEJB")
    private static SecTestRoleRef ejb2ref = null;
    private static final String emp_secrole_ref = "EMP";
    private static final String admin_secrole_ref = "ADMIN";
    private static final String mgr_secrole_ref = "MGR";
    private static final String testDir = System.getProperty("user.dir");
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private String username = "";
    private String password = "";
    private Properties props = null;
    private TSLoginContext lc = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.username = TestUtil.getProperty((String)UserNameProp);
            this.password = TestUtil.getProperty((String)UserPasswordProp);
            this.lc = new TSLoginContext();
            this.lc.login(this.username, this.password);
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        this.logMsg("Starting No caller authorization test");
        try {
            ejb1ref.EjbNotAuthz();
            this.logErr("Method call did not generate an expected java.rmi.RemoteException");
            throw new EETest.Fault("No caller authorization test failed");
        }
        catch (EJBException e) {
            this.logMsg("Caught jakarta.ejb.EJBException as expected");
            this.logMsg("No authorization test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("No caller authorization test failed:", e);
        }
    }

    public void test2() throws EETest.Fault {
        this.logMsg("Starting Caller authorization test");
        try {
            if (!ejb1ref.EjbIsAuthz()) {
                throw new EETest.Fault("Caller authorization test failed");
            }
            this.logMsg("Caller authorization test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Caller authorization test failed: ", e);
        }
    }

    public void test3() throws EETest.Fault {
        this.logMsg("Starting Security role reference positive test");
        try {
            if (!ejb1ref.EjbSecRoleRef(emp_secrole_ref)) {
                this.logErr("EjbSecRoleRef(EMP) returned false");
                throw new EETest.Fault("Security role reference positive test failed");
            }
            this.logMsg("Security role reference positive test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Security role reference positive test failed: ", e);
        }
    }

    public void test4() throws EETest.Fault {
        this.logMsg("Starting Security role reference negative test");
        try {
            if (ejb1ref.EjbSecRoleRef(mgr_secrole_ref)) {
                this.logErr("EjbSecRoleRef(MGR) returned true");
                throw new EETest.Fault("Security role reference negative test failed");
            }
            this.logMsg("Security role reference negative test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Security role reference negative test failed: ", e);
        }
    }

    public void test5() throws EETest.Fault {
        this.logMsg("Starting Security role reference scope test");
        try {
            if (!ejb1ref.EjbSecRoleRef(emp_secrole_ref)) {
                this.logErr("isCallerInRole(EMP) returned false");
                throw new EETest.Fault("Security role reference scope test failed");
            }
            this.logMsg("(ejb1) isCallerInRole(EMP) returned true as expected");
        }
        catch (Exception e) {
            throw new EETest.Fault("Security role reference scope test failed: ", e);
        }
        try {
            if (ejb2ref.EjbSecRoleRefScope(emp_secrole_ref)) {
                this.logMsg("isCallerInRole(EMP) returned true");
                throw new EETest.Fault("Security role reference scope test failed");
            }
            this.logMsg("(ejb2) isCallerInRole(EMP) returned false as expected");
            this.logMsg("Security role reference scope test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Security role reference scope test failed: ", e);
        }
    }

    public void test6() throws EETest.Fault {
        this.logMsg("Starting Overloaded security role references test");
        try {
            if (!ejb1ref.EjbOverloadedSecRoleRefs(emp_secrole_ref)) {
                this.logErr("EjbOverloadedSecRoleRefs(EMP) returned false");
                throw new EETest.Fault("Overloaded security role references test failed");
            }
            this.logMsg("EjbOverloadedSecRoleRefs(EMP) returned true as expected");
            if (ejb1ref.EjbOverloadedSecRoleRefs(emp_secrole_ref, mgr_secrole_ref)) {
                this.logErr("EjbOverloadedRoleRefs(EMP,MGR) returned true");
                throw new EETest.Fault("Overloaded security role references test failed");
            }
            this.logMsg("EjbOverloadedSecRoleRefs(EMP,MGR) returned false as expected");
        }
        catch (Exception e) {
            throw new EETest.Fault("Overloaded security role references test failed", e);
        }
        this.logMsg("Overloaded security role references test passed");
    }

    public void test7() throws EETest.Fault {
        this.logMsg("Starting unchecked test1");
        try {
            if (!ejb1ref.checktest1()) {
                this.logErr("unchecked test returned false");
                throw new EETest.Fault("unchecked test1 failed");
            }
            this.logMsg("unchecked test1 passed.");
        }
        catch (Exception e) {
            throw new EETest.Fault("unchecked test1 failed", e);
        }
    }

    public void test8() throws EETest.Fault {
        this.logMsg("Starting exclude-list test1");
        try {
            ejb1ref.excludetest1();
        }
        catch (EJBException e) {
            this.logMsg("Caught java.rmi.RemoteException as expected");
            this.logMsg("exclude-list test1 passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("exclude-list test1 failed:", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

