/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.derivedid.ex1a;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.derivedid.ex1a.DID1Dependent;
import com.sun.ts.tests.jpa.core.derivedid.ex1a.DID1DependentId;
import com.sun.ts.tests.jpa.core.derivedid.ex1a.DID1Employee;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void DIDTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            DID1Employee employee1 = new DID1Employee(1L, "Duke");
            DID1Employee employee2 = new DID1Employee(2L, "foo");
            DID1Dependent dep1 = new DID1Dependent("Obama", employee1);
            DID1Dependent dep2 = new DID1Dependent("Michelle", employee1);
            DID1Dependent dep3 = new DID1Dependent("John", employee2);
            this.getEntityManager().persist((Object)dep1);
            this.getEntityManager().persist((Object)dep2);
            this.getEntityManager().persist((Object)dep3);
            this.getEntityManager().persist((Object)employee1);
            this.getEntityManager().persist((Object)employee2);
            TestUtil.logTrace((String)"persisted Employees and Dependents");
            this.getEntityManager().flush();
            for (int i = 1; i < 3; ++i) {
                DID1Employee newEmployee = (DID1Employee)this.getEntityManager().find(DID1Employee.class, (Object)i);
                if (newEmployee == null) continue;
                this.getEntityManager().refresh((Object)newEmployee);
            }
            DID1Dependent newDependent = (DID1Dependent)this.getEntityManager().find(DID1Dependent.class, (Object)new DID1DependentId("Obama", 1L));
            if (newDependent != null) {
                this.getEntityManager().refresh((Object)newDependent);
            }
            List depList = this.getEntityManager().createQuery("Select d from DID1Dependent d where d.name='Obama' and d.emp.name='Duke'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID1Dependent)depList.get(0);
                if (newDependent == dep1) {
                    pass = true;
                    TestUtil.logTrace((String)"Received Expected Dependent");
                } else {
                    TestUtil.logErr((String)"Searched Dependent not found");
                }
            } else {
                TestUtil.logErr((String)"getEntityManager().createQuery returned null entry");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            this.getEntityTransaction().rollback();
        }
        if (!pass) {
            throw new EETest.Fault("DTDTest failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID1DEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID1EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

