/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.annotation.resource;

import com.sun.ts.lib.deliverable.cts.resource.Dog;
import com.sun.ts.tests.ejb30.common.annotation.resource.ResourceIF;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import jakarta.ejb.EJBContext;
import jakarta.ejb.TimerService;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.mail.Session;
import jakarta.transaction.TransactionSynchronizationRegistry;
import jakarta.transaction.UserTransaction;
import java.net.URL;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.omg.CORBA.ORB;

public abstract class ResourceBeanBase
implements ResourceIF {
    protected abstract EJBContext getEJBContext();

    protected abstract UserTransaction getUserTransaction();

    protected abstract String getUserTransactionName();

    protected abstract DataSource getDataSource();

    protected abstract String getDataSourceName();

    protected abstract DataSource getDataSource2();

    protected abstract String getDataSource2Name();

    protected abstract Session getMailSession();

    protected abstract String getMailSessionName();

    protected abstract URL getUrl();

    protected abstract String getUrlName();

    protected abstract QueueConnectionFactory getQueueConnectionFactory();

    protected abstract String getQueueConnectionFactoryName();

    protected abstract TopicConnectionFactory getTopicConnectionFactory();

    protected abstract String getTopicConnectionFactoryName();

    protected abstract ConnectionFactory getConnectionFactoryQ();

    protected abstract String getConnectionFactoryQName();

    protected abstract ConnectionFactory getConnectionFactoryT();

    protected abstract String getConnectionFactoryTName();

    protected abstract Queue getQueue();

    protected abstract String getQueueName();

    protected abstract Topic getTopic();

    protected abstract String getTopicName();

    protected abstract ORB getOrb();

    protected abstract String getOrbName();

    protected TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return null;
    }

    protected String getTransactionSynchronizationRegistryName() {
        return null;
    }

    protected TimerService getTimerService() {
        return null;
    }

    protected String getTimerServiceName() {
        return null;
    }

    protected Object getCustomeResource() {
        return null;
    }

    protected String getCustomeResourceName() {
        return null;
    }

    protected Destination getDestinationQ() {
        return null;
    }

    protected String getDestinationQName() {
        return null;
    }

    protected Destination getDestinationT() {
        return null;
    }

    protected String getDestinationTName() {
        return null;
    }

    @Override
    public void testUrl() throws TestFailedException {
        URL url1 = this.getUrl();
        this.verify(url1, "getUrl()");
        url1 = null;
        URL url2 = (URL)this.getEJBContext().lookup(this.getUrlName());
        this.verify(url2, "EJBContext.lookup " + this.getUrlName());
        url2 = null;
        try {
            URL url3 = (URL)ServiceLocator.lookup("java:comp/env/" + this.getUrlName(), new Context[0]);
            this.verify(url3, "Naming Context lookup");
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testTopicConnectionFactory() throws TestFailedException {
        TopicConnectionFactory topic1 = this.getTopicConnectionFactory();
        this.verify(topic1, "getTopicConnectionFactory()");
        try {
            TopicConnection tConn = topic1.createTopicConnection();
            tConn.close();
            TLogger.log("Got TopicConnection from TopicConnectionFactory: " + tConn);
        }
        catch (JMSException e1) {
            throw new TestFailedException(e1);
        }
        topic1 = null;
        TopicConnectionFactory topic2 = (TopicConnectionFactory)this.getEJBContext().lookup(this.getTopicConnectionFactoryName());
        this.verify(topic2, "EJBContext.lookup" + this.getTopicConnectionFactoryName());
        try {
            TopicConnectionFactory topic3 = (TopicConnectionFactory)ServiceLocator.lookup("java:comp/env/" + this.getTopicConnectionFactoryName(), new Context[0]);
            this.verify(topic3, "Naming Context lookup");
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testQueueConnectionFactory() throws TestFailedException {
        QueueConnectionFactory queue1 = this.getQueueConnectionFactory();
        this.verify(queue1, "getQueueConnectionFactory()");
        try {
            QueueConnection qConn = queue1.createQueueConnection();
            qConn.close();
            TLogger.log("Got QueueConnection from QueueConnectionFactory: " + qConn);
        }
        catch (JMSException e1) {
            throw new TestFailedException(e1);
        }
        queue1 = null;
        QueueConnectionFactory queue2 = (QueueConnectionFactory)this.getEJBContext().lookup(this.getQueueConnectionFactoryName());
        this.verify(queue2, "EJBContext.lookup" + this.getQueueConnectionFactoryName());
        try {
            QueueConnectionFactory queue3 = (QueueConnectionFactory)ServiceLocator.lookup("java:comp/env/" + this.getQueueConnectionFactoryName(), new Context[0]);
            this.verify(queue3, "Naming Context lookup");
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testConnectionFactoryT() throws TestFailedException {
        ConnectionFactory topic1 = this.getConnectionFactoryT();
        this.verify(topic1, "getConnectionFactoryT()");
        topic1 = null;
        ConnectionFactory topic2 = (ConnectionFactory)this.getEJBContext().lookup(this.getConnectionFactoryTName());
        this.verify(topic2, "EJBContext.lookup" + this.getConnectionFactoryTName());
        try {
            ConnectionFactory topic3 = (ConnectionFactory)ServiceLocator.lookup("java:comp/env/" + this.getConnectionFactoryTName(), new Context[0]);
            this.verify(topic3, "Naming Context lookup");
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testConnectionFactoryQ() throws TestFailedException {
        ConnectionFactory queue1 = this.getConnectionFactoryQ();
        this.verify(queue1, "getConnectionFactoryQ()");
        queue1 = null;
        ConnectionFactory queue2 = (ConnectionFactory)this.getEJBContext().lookup(this.getConnectionFactoryQName());
        this.verify(queue2, "EJBContext.lookup" + this.getConnectionFactoryQName());
        try {
            ConnectionFactory queue3 = (ConnectionFactory)ServiceLocator.lookup("java:comp/env/" + this.getConnectionFactoryQName(), new Context[0]);
            this.verify(queue3, "Naming Context lookup");
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testDestinationQ() throws TestFailedException {
        Destination dest1 = this.getDestinationQ();
        this.verify(dest1, "getDestinationQ()");
        dest1 = null;
        Destination dest2 = (Destination)this.getEJBContext().lookup(this.getDestinationQName());
        this.verify(dest2, "EJBContext.lookup" + this.getDestinationQName());
        try {
            Destination dest3 = (Destination)ServiceLocator.lookup("java:comp/env/" + this.getDestinationQName(), new Context[0]);
            this.verify(dest3, "Naming Context lookup");
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testDestinationT() throws TestFailedException {
        Destination dest1 = this.getDestinationT();
        this.verify(dest1, "getDestinationT()");
        dest1 = null;
        Destination dest2 = (Destination)this.getEJBContext().lookup(this.getDestinationTName());
        this.verify(dest2, "EJBContext.lookup" + this.getDestinationTName());
        try {
            Destination dest3 = (Destination)ServiceLocator.lookup("java:comp/env/" + this.getDestinationTName(), new Context[0]);
            this.verify(dest3, "Naming Context lookup");
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testQueue() throws TestFailedException {
        Queue queue1 = this.getQueue();
        this.verify(queue1, "getQueue()");
        queue1 = null;
        Queue queue2 = (Queue)this.getEJBContext().lookup(this.getQueueName());
        this.verify(queue2, "EJBContext.lookup" + this.getQueueName());
        try {
            Queue queue3 = (Queue)ServiceLocator.lookup("java:comp/env/" + this.getQueueName(), new Context[0]);
            this.verify(queue3, "Naming Context lookup");
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testTopic() throws TestFailedException {
        Topic topic1 = this.getTopic();
        this.verify(topic1, "getTopic()");
        topic1 = null;
        Topic topic2 = (Topic)this.getEJBContext().lookup(this.getTopicName());
        this.verify(topic2, "EJBContext.lookup" + this.getTopicName());
        try {
            Topic topic3 = (Topic)ServiceLocator.lookup("java:comp/env/" + this.getTopicName(), new Context[0]);
            this.verify(topic3, "Naming Context lookup");
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testMailSession() throws TestFailedException {
        Session session1 = this.getMailSession();
        this.verify(session1, "getMailSession()");
        session1 = null;
        Session session2 = (Session)this.getEJBContext().lookup(this.getMailSessionName());
        this.verify(session2, "EJBContext.lookup" + this.getMailSessionName());
        try {
            Session session3 = (Session)ServiceLocator.lookup("java:comp/env/" + this.getMailSessionName(), new Context[0]);
            this.verify(session3, "Naming Context lookup");
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testEJBContext() throws TestFailedException {
        if (this.getEJBContext() == null) {
            throw new TestFailedException("getEJBContext{} returned null");
        }
    }

    @Override
    public void testDataSource2() throws TestFailedException {
        DataSource ds1 = this.getDataSource2();
        this.verify(ds1, "getDataSource2()");
        ds1 = null;
        DataSource ds2 = (DataSource)this.getEJBContext().lookup(this.getDataSource2Name());
        this.verify(ds2, "EJBContext.lookup" + this.getDataSource2Name());
        try {
            DataSource ds3 = (DataSource)ServiceLocator.lookup("java:comp/env/" + this.getDataSource2Name(), new Context[0]);
            this.verify(ds3, "Naming Context lookup");
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testDataSource() throws TestFailedException {
        DataSource ds1 = this.getDataSource();
        this.verify(ds1, "getDataSource()");
        ds1 = null;
        DataSource ds2 = (DataSource)this.getEJBContext().lookup(this.getDataSourceName());
        this.verify(ds2, "EJBContext.lookup" + this.getDataSourceName());
        try {
            DataSource ds3 = (DataSource)ServiceLocator.lookup("java:comp/env/" + this.getDataSourceName(), new Context[0]);
            this.verify(ds3, "Naming Context lookup");
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testUserTransaction() throws TestFailedException {
        UserTransaction ut1 = this.getUserTransaction();
        this.verify(ut1, "getUserTransaction()");
        ut1 = null;
        UserTransaction ut2 = this.getEJBContext().getUserTransaction();
        this.verify(ut2, "EJBContext.getUserTransaction()");
        ut2 = null;
        try {
            UserTransaction ut3 = (UserTransaction)ServiceLocator.lookup("java:comp/UserTransaction", new Context[0]);
            this.verify(ut3, "Naming context lookup java:comp/UserTransaction");
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testOrb() throws TestFailedException {
        ORB orb1 = this.getOrb();
        this.verify(orb1, "getOrb()");
        orb1 = null;
        try {
            ORB orb3 = (ORB)ServiceLocator.lookup("java:comp/ORB", new Context[0]);
            this.verify(orb3, "Naming context lookup java:comp/ORB");
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testTransactionSynchronizationRegistryInjected() throws TestFailedException {
        TransactionSynchronizationRegistry t = this.getTransactionSynchronizationRegistry();
        this.verify(t, "getTransactionSynchronizationRegistry()");
        Object key = t.getTransactionKey();
        try {
            t = (TransactionSynchronizationRegistry)ServiceLocator.lookup("java:comp/TransactionSynchronizationRegistry", new Context[0]);
            this.verify(t, "Naming context lookup java:comp/TransactionSynchronizationRegistry");
            key = t.getTransactionKey();
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testTransactionSynchronizationRegistryLookup() throws TestFailedException {
        try {
            TransactionSynchronizationRegistry transactionSynchronizationRegistry = (TransactionSynchronizationRegistry)ServiceLocator.lookup("java:comp/env/" + this.getTransactionSynchronizationRegistryName(), new Context[0]);
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testTimerServiceInjected() throws TestFailedException {
        TimerService t = this.getTimerService();
        this.verify(t, "getTimerService()");
        try {
            t = (TimerService)ServiceLocator.lookup("java:comp/TimerService", new Context[0]);
            this.verify(t, "Naming context lookup java:comp/TimerService");
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testTimerServiceLookup() throws TestFailedException {
        try {
            String lookupName = "java:comp/env/" + this.getTimerServiceName();
            TimerService t = (TimerService)ServiceLocator.lookup(lookupName, new Context[0]);
            this.verify(t, "Naming context lookup " + lookupName);
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void testCustomResourceLookup() throws TestFailedException {
        Dog dog = (Dog)this.getEJBContext().lookup(this.getCustomeResourceName());
        if (!Dog.getInstance().equals((Object)dog)) {
            throw new TestFailedException("Failed to lookup the expected value.  Expected result: " + Dog.getInstance().toString() + ", actual result: " + dog);
        }
        TLogger.log("Got expected result: ", dog.toString());
    }

    @Override
    public void testCustomResourceInjected() throws TestFailedException {
        Object obj = this.getCustomeResource();
        if (!Dog.getInstance().equals(obj)) {
            throw new TestFailedException("The expected value has not been injected.  Expected result: " + Dog.getInstance().toString() + ", actual result: " + obj);
        }
        TLogger.log("Correctly injected ", obj.toString());
    }

    protected void verify(Object obj, String description) throws TestFailedException {
        if (obj == null) {
            if (description == null) {
                description = "Obtaining resource";
            }
            throw new TestFailedException(description + " returned null: " + this);
        }
    }
}

