/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.cmp.reentranttest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp.reentranttest.LoopBack;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp.reentranttest.LoopBackHome;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp.reentranttest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp.reentranttest.TestBeanHome;
import java.util.Properties;

public class Client
extends EETest {
    private static final String testName = "ReEntrantTest";
    private static final String testBean = "java:comp/env/ejb/TestBean";
    private static final String loopBack = "java:comp/env/ejb/LoopBackBean";
    private static final String testProps = "reentranttest.properties";
    private TestBean beanRef = null;
    private TestBeanHome beanHome = null;
    private Properties props = null;
    private TSNamingContext nctx = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testBean, TestBeanHome.class);
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test2() throws EETest.Fault {
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 2, "coffee-2", 2.0f);
            this.logMsg("Calling loopback test via same bean");
            boolean pass = this.beanRef.loopBackSameBean();
            if (!pass) {
                throw new EETest.Fault("test2 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test2 failed", e);
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void test3() throws EETest.Fault {
        LoopBackHome loopHome = null;
        LoopBack loopRef = null;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 3, "coffee-3", 3.0f);
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/LoopBackBean");
            loopHome = (LoopBackHome)this.nctx.lookup(loopBack, LoopBackHome.class);
            this.logMsg("Creating EJB for: java:comp/env/ejb/LoopBackBean");
            loopRef = loopHome.create(this.beanRef);
            this.logMsg("Calling loopback test via different bean");
            boolean pass = this.beanRef.loopBackAnotherBean(loopRef);
            if (!pass) {
                throw new EETest.Fault("test3 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test3 failed", e);
        }
        finally {
            try {
                loopRef.remove();
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

