/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.deploy.entity.cmp20.ejbref.scope;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.ejb.ee.deploy.entity.cmp20.ejbref.scope.ReferencingBean;
import com.sun.ts.tests.ejb.ee.deploy.entity.cmp20.ejbref.scope.ReferencingBeanHome;
import java.util.Properties;

public class Client
extends EETest {
    private static final String prefix = "java:comp/env/ejb/";
    private static final String bean1Lookup = "java:comp/env/ejb/Romeo";
    private static final String bean2Lookup = "java:comp/env/ejb/Tristan";
    private static final String bean3Lookup = "java:comp/env/ejb/Cyrano";
    private static final String bean1RefPartner = "Juliette";
    private static final String bean2RefPartner = "Iseult";
    private static final String bean3RefPartner = "Roxane";
    private ReferencingBeanHome home = null;
    private ReferencingBean bean = null;
    private Properties props = null;
    private TSNamingContext nctx = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logTrace("Client: Getting Naming Context...");
            this.nctx = new TSNamingContext();
            this.logTrace("Client:Got Naming Context!");
        }
        catch (Exception e) {
            this.logErr("Client: Failed to obtain Naming Context:" + e);
            throw new EETest.Fault("Client: Setup failed:" + e, e);
        }
    }

    public void testScopeInternal() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logTrace("Client: Looking up java:comp/env/ejb/Romeo");
            this.home = (ReferencingBeanHome)this.nctx.lookup(bean1Lookup, ReferencingBeanHome.class);
            this.bean = this.home.create(this.props, 1, "expresso", 8.0f);
            this.logTrace("Client: Checking referenced EJB...");
            String bean1Partner = this.bean.whoIsYourPartner(this.props, 10);
            this.bean.remove();
            this.logTrace("Client: Looking up java:comp/env/ejb/Tristan");
            this.home = (ReferencingBeanHome)this.nctx.lookup(bean2Lookup, ReferencingBeanHome.class);
            this.bean = this.home.create(this.props, 2, "capuccino", 8.0f);
            this.logTrace("Client: Checking referenced EJB...");
            String bean2Partner = this.bean.whoIsYourPartner(this.props, 11);
            this.bean.remove();
            boolean bl = pass = bean1Partner.equals(bean1RefPartner) && bean2Partner.equals(bean2RefPartner);
            if (!pass) {
                this.logErr("Client: Expected java:comp/env/ejb/Romeo partner to be Juliette and  java:comp/env/ejb/Tristan partner to be Iseult");
                throw new EETest.Fault("Client: EJB reference scope test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: " + e);
            throw new EETest.Fault("Client: Internal EJB ref scope test failed!" + e, e);
        }
    }

    public void testScopeExternal() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logTrace("Client: Looking up java:comp/env/ejb/Romeo");
            this.home = (ReferencingBeanHome)this.nctx.lookup(bean1Lookup, ReferencingBeanHome.class);
            this.bean = this.home.create(this.props, 1, "expresso", 8.0f);
            this.logTrace("Client: Checking referenced EJB...");
            String bean1Partner = this.bean.whoIsYourPartner(this.props, 12);
            this.bean.remove();
            this.logTrace("Client: Looking up java:comp/env/ejb/Cyrano");
            this.home = (ReferencingBeanHome)this.nctx.lookup(bean3Lookup, ReferencingBeanHome.class);
            this.bean = this.home.create(this.props, 2, "cappucino", 8.0f);
            this.logTrace("Client: Checking referenced EJB...");
            String bean3Partner = this.bean.whoIsYourPartner(this.props, 13);
            this.bean.remove();
            boolean bl = pass = bean1Partner.equals(bean1RefPartner) && bean3Partner.equals(bean3RefPartner);
            if (!pass) {
                this.logErr("Client: Expected java:comp/env/ejb/Romeo partner to be Juliette and  java:comp/env/ejb/Cyrano partner to be Roxane");
                throw new EETest.Fault("Client: EJB reference scope test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("Client: Caught exception: " + e);
            throw new EETest.Fault("Client: External EJB ref scope test failed!" + e, e);
        }
    }

    public void cleanup() {
        this.logTrace("Client: Cleanup.");
    }
}

