/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.derivedid.ex4b;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.derivedid.ex4b.DID4bMedicalHistory;
import com.sun.ts.tests.jpa.core.derivedid.ex4b.DID4bPerson;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void DIDTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            DID4bPerson person = new DID4bPerson("123456789", "DUKE");
            DID4bMedicalHistory mHistory = new DID4bMedicalHistory("123456789", person, "drFoo");
            this.getEntityManager().persist((Object)person);
            this.getEntityManager().persist((Object)mHistory);
            TestUtil.logTrace((String)"persisted Patient and MedicalHistory");
            this.getEntityManager().flush();
            DID4bMedicalHistory newMHistory = (DID4bMedicalHistory)this.getEntityManager().find(DID4bMedicalHistory.class, (Object)"123456789");
            if (newMHistory != null) {
                this.getEntityManager().refresh((Object)newMHistory);
            }
            List depList = this.getEntityManager().createQuery("Select m from DID4bMedicalHistory m where m.patient.ssn='123456789'").getResultList();
            newMHistory = null;
            if (depList.size() > 0) {
                newMHistory = (DID4bMedicalHistory)depList.get(0);
                if (newMHistory != null) {
                    if (newMHistory.getPatient() == person) {
                        pass = true;
                        TestUtil.logTrace((String)"Received Expected Patient");
                    } else {
                        TestUtil.logErr((String)"Searched Patient not found");
                    }
                } else {
                    TestUtil.logErr((String)"getEntityManager().createQuery returned null entry");
                }
            } else {
                TestUtil.logErr((String)"getEntityManager().createQuery returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            this.getEntityTransaction().rollback();
        }
        if (!pass) {
            throw new EETest.Fault("DTDTest failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID4BMEDICALHISTORY").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID4BPERSON").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

