/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonbuilderfactorytests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.jsonbuilderfactorytests.BuilderFactory;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import java.util.Map;
import java.util.Properties;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void jsonBuilderFactoryTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create JsonBuilderFactory with Map<String, ?> with EMPTY config");
            JsonBuilderFactory builderFactory = Json.createBuilderFactory(JSONP_Util.getEmptyConfig());
            this.logMsg("Checking factory configuration properties");
            Map config = builderFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("---------------------------------------------------");
            this.logMsg("TEST CASE [JsonBuilderFactory.createArrayBuilder()]");
            this.logMsg("---------------------------------------------------");
            this.logMsg("Create JsonArrayBuilder using JsonBuilderFactory");
            JsonArray expJsonArray = JSONP_Util.createJsonArrayFromString("[0,2]");
            JsonArray actJsonArray = builderFactory.createArrayBuilder().add(0).add(2).build();
            if (!JSONP_Util.assertEqualsJsonArrays(expJsonArray, actJsonArray)) {
                pass = false;
            }
            this.logMsg("----------------------------------------------------");
            this.logMsg("TEST CASE [JsonBuilderFactory.createObjectBuilder()]");
            this.logMsg("----------------------------------------------------");
            this.logMsg("Create JsonObjectBuilder using JsonBuilderFactory");
            JsonObject expJsonObject = JSONP_Util.createJsonObjectFromString("{\"foo\":\"bar\"}");
            JsonObject actJsonObject = builderFactory.createObjectBuilder().add("foo", "bar").build();
            if (!JSONP_Util.assertEqualsJsonObjects(expJsonObject, actJsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonBuilderFactoryTest1 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonBuilderFactoryTest1 Failed");
        }
    }

    public void jsonBuilderFactoryTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("----------------------------------------------");
            this.logMsg("Test scenario1: no supported provider property");
            this.logMsg("----------------------------------------------");
            this.logMsg("Create JsonBuilderFactory with Map<String, ?> with EMPTY config");
            JsonBuilderFactory builderFactory = Json.createBuilderFactory(JSONP_Util.getEmptyConfig());
            Map config = builderFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("-----------------------------------------------");
            this.logMsg("Test scenario2: non supported provider property");
            this.logMsg("-----------------------------------------------");
            this.logMsg("Create JsonBuilderFactory with Map<String, ?> with FOO config");
            builderFactory = Json.createBuilderFactory(JSONP_Util.getFooConfig());
            config = builderFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonBuilderFactoryTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonBuilderFactoryTest2 Failed");
        }
    }

    public void jsonBuilderFactory11Test() throws EETest.Fault {
        BuilderFactory factoryTest = new BuilderFactory();
        TestResult result = factoryTest.test();
        result.eval();
    }
}

