/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.exceptionTopic;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.Queue;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSubscriber;
import java.util.ArrayList;
import java.util.Properties;

public class ExceptionTopicTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.exceptionTopic.ExceptionTopicTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
    private String jmsUser;
    private String jmsPassword;
    private String mode;
    ArrayList connections = null;

    public static void main(String[] args) {
        ExceptionTopicTests theTests = new ExceptionTopicTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            this.logMsg("Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            TestUtil.logTrace((String)"In setup");
            this.jmsUser = p.getProperty("user");
            this.jmsPassword = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            this.connections = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void xInvalidDestinationExceptionTopicTest() throws EETest.Fault {
        boolean pass = true;
        TopicPublisher tPublisher = null;
        TopicSubscriber tSubscriber = null;
        Topic dummy = null;
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            TestUtil.logTrace((String)"** Close default TopicSubscriber **");
            this.tool.getDefaultTopicSubscriber().close();
            this.tool.getDefaultTopicConnection().start();
            this.logMsg("Test unsubscribe(invalidSubscriptionName)");
            try {
                this.tool.getDefaultTopicSession().unsubscribe("invalidSubscriptionName");
                TestUtil.logTrace((String)"FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    TestUtil.logTrace((String)"Pass: InvalidDestinationException thrown as expected");
                }
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("Test createSubscriber(null)");
            try {
                tSubscriber = this.tool.getDefaultTopicSession().createSubscriber(dummy);
                TestUtil.logTrace((String)"FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    TestUtil.logTrace((String)"Pass: InvalidDestinationException thrown as expected");
                }
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("Test createSubscriber(null,selector,nolocal)");
            try {
                tSubscriber = this.tool.getDefaultTopicSession().createSubscriber(dummy, "TEST", true);
                TestUtil.logTrace((String)"FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    TestUtil.logTrace((String)"Pass: InvalidDestinationException thrown as expected");
                }
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("Test createDurableSubscriber(null,String)");
            try {
                tSubscriber = this.tool.getDefaultTopicSession().createDurableSubscriber(dummy, "durable");
                TestUtil.logTrace((String)"FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    TestUtil.logTrace((String)"Pass: InvalidDestinationException thrown as expected");
                }
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("Test createDurableSubscriber(null,String,selector,nolocal)");
            try {
                tSubscriber = this.tool.getDefaultTopicSession().createDurableSubscriber(dummy, "durable", "TEST", true);
                TestUtil.logTrace((String)"FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    TestUtil.logTrace((String)"Pass: InvalidDestinationException thrown as expected");
                }
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("Test createPublisher(null) - This is valid");
            try {
                tPublisher = this.tool.getDefaultTopicSession().createPublisher(dummy);
                if (tPublisher != null) {
                    this.logMsg("tPublisher=" + tPublisher);
                }
                TestUtil.logTrace((String)"PASS: null allowed for unidentified producer");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logErr("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during xInvalidDestinationExceptionQTest tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("xInvalidDestinationExceptionTopicTest", e);
        }
    }

    public void xMessageNotReadableExceptionTopicTest() throws EETest.Fault {
        try {
            BytesMessage msg = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            msg = this.tool.getDefaultTopicSession().createBytesMessage();
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotReadableExceptionTopicTest");
            try {
                msg.readByte();
                TestUtil.logErr((String)"FAIL --- should not have gotten this far!");
                throw new EETest.Fault("Fail: Did not throw expected error!!!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logMsg((String)"Passed with expected MessageNotReadableException.");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Expected MessageNotReadableException did not occur:", (Throwable)e);
            throw new EETest.Fault("xMessageNotReadableExceptionTopicTest test failed", e);
        }
    }

    public void xMessageNotWriteableExceptionTTestforTextMessage() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            int bValue = 127;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionTTestforTextMessage");
            TestUtil.logTrace((String)"Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            TestUtil.logTrace((String)"Got message - OK");
            try {
                messageReceived.setText("testing...");
            }
            catch (MessageNotWriteableException nr) {
                TestUtil.logMsg((String)"Passed with expected MessageNotWriteableException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"xMessageNotWriteableExceptionTTestforTextMessage failed:", (Throwable)e);
            throw new EETest.Fault("xMessageNotWriteableExceptionTTestforTextMessage", e);
        }
    }

    public void xMessageNotWriteableExceptionTestforBytesMessage() throws EETest.Fault {
        try {
            BytesMessage messageSent = null;
            BytesMessage messageReceived = null;
            byte bValue = 127;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSent.writeByte(bValue);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionTestforBytesMessage");
            TestUtil.logTrace((String)"Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            TestUtil.logTrace((String)"Got message - OK");
            try {
                messageReceived.writeByte(bValue);
            }
            catch (MessageNotWriteableException nr) {
                TestUtil.logMsg((String)"Passed with expected MessageNotWriteableException.");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"xMessageNotWriteableExceptionTestforBytesMessage failed: ", (Throwable)e);
            throw new EETest.Fault("xMessageNotWriteableExceptionTestforBytesMessage", e);
        }
    }

    public void xMessageNotWriteableExceptionTTestforStreamMessage() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionTTestforStreamMessage");
            messageSent.writeString("Testing...");
            TestUtil.logTrace((String)"Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            TestUtil.logTrace((String)"Got message - OK");
            try {
                messageReceived.writeString("Testing...");
            }
            catch (MessageNotWriteableException nr) {
                TestUtil.logTrace((String)"Passed with expected MessageNotWriteableException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"xMessageNotWriteableExceptionTTestforStreamMessage failed: ", (Throwable)e);
            throw new EETest.Fault("xMessageNotWriteableExceptionTTestforStreamMessage", e);
        }
    }

    public void xMessageNotWriteableExceptionTTestforMapMessage() throws EETest.Fault {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            int bValue = 127;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionTTestforMapMessage");
            messageSent.setString("aString", "value");
            TestUtil.logTrace((String)"Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            TestUtil.logTrace((String)"Got message - OK");
            try {
                messageReceived.setString("aString", "value");
            }
            catch (MessageNotWriteableException nr) {
                TestUtil.logMsg((String)"Passed with expected MessageNotWriteableException occurred.");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"xMessageNotWriteableExceptionTTestforMapMessage failed: ", (Throwable)e);
            throw new EETest.Fault("xMessageNotWriteableExceptionTTestforMapMessage", e);
        }
    }

    public void xNullPointerExceptionTopicTest() throws EETest.Fault {
        try {
            BytesMessage msg = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            msg = this.tool.getDefaultTopicSession().createBytesMessage();
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "xNullPointerExceptionTopicTest");
            msg.writeBytes(null);
        }
        catch (NullPointerException nullp) {
            TestUtil.logMsg((String)"Passed with expected NullPointerException.");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Expected NullPointerException did not occur!", (Throwable)e);
            throw new EETest.Fault("xNullPointerExceptionTopicTest");
        }
    }

    public void xMessageEOFExceptionTTestforBytesMessage() throws EETest.Fault {
        try {
            BytesMessage messageSent = null;
            BytesMessage messageReceived = null;
            byte bValue = 127;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSent.writeByte(bValue);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageEOFExceptionTTestforBytesMessage");
            TestUtil.logTrace((String)"Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            TestUtil.logTrace((String)"Got message - OK");
            messageReceived.readByte();
            try {
                messageReceived.readByte();
                TestUtil.logTrace((String)"Failed:  expected MessageEOFException not thrown");
                throw new EETest.Fault("Fail: Did not throw expected error!!!");
            }
            catch (MessageEOFException end) {
                TestUtil.logTrace((String)"Passed.\n");
                TestUtil.logTrace((String)"MessageEOFException occurred!");
                TestUtil.logTrace((String)(" " + end.getMessage()));
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("xMessageEOFExceptionTTestforBytesMessage", e);
        }
    }

    public void xMessageEOFExceptionTTestforStreamMessage() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            byte bValue = 127;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.writeByte(bValue);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageEOFExceptionTTestforStreamMessage");
            TestUtil.logTrace((String)"Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            TestUtil.logTrace((String)"Got message - OK");
            messageReceived.readByte();
            try {
                messageReceived.readByte();
                TestUtil.logTrace((String)"Failed:  expected MessageEOFException not thrown");
                throw new EETest.Fault("Fail: Did not throw expected error!!!");
            }
            catch (MessageEOFException end) {
                TestUtil.logTrace((String)"Passed.\n");
                TestUtil.logTrace((String)"MessageEOFException occurred!");
                TestUtil.logTrace((String)(" " + end.getMessage()));
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("xMessageEOFExceptionTTestforStreamMessage", e);
        }
    }

    public void xMessageFormatExceptionTTestforBytesMessage() throws EETest.Fault {
        try {
            BytesMessage messageSent = null;
            Object messageReceived = null;
            int bValue = 127;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageFormatExceptionTTestforBytesMessage");
            TestUtil.logTrace((String)"try to write an invalid object");
            try {
                messageSent.writeObject((Object)this.tool.getDefaultTopicSession());
                TestUtil.logTrace((String)"Failed:  expected MessageFormatException not thrown");
                throw new EETest.Fault("Fail: Did not throw expected error!!!");
            }
            catch (MessageFormatException fe) {
                TestUtil.logTrace((String)"Passed.\n");
                TestUtil.logTrace((String)"MessageFormatException occurred!");
                TestUtil.logTrace((String)(" " + fe.getMessage()));
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("xMessageFormatExceptionTTestforBytesMessage", e);
        }
    }

    public void xMessageFormatExceptionTTestforStreamMessage() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            byte[] bValues = new byte[]{127, 0, 3};
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.writeBytes(bValues);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageFormatExceptionTTestforStreamMessage");
            TestUtil.logTrace((String)"Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            TestUtil.logTrace((String)"Got message - OK");
            try {
                messageReceived.readString();
                TestUtil.logTrace((String)"Failed:  expected MessageFormatException not thrown");
                throw new EETest.Fault("Fail: Did not throw expected error!!!");
            }
            catch (MessageFormatException fe) {
                TestUtil.logTrace((String)"Passed.\n");
                TestUtil.logTrace((String)"MessageFormatException occurred!");
                TestUtil.logTrace((String)(" " + fe.getMessage()));
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("xMessageFormatExceptionTTestforStreamMessage", e);
        }
    }

    public void xInvalidSelectorExceptionTopicTest() throws EETest.Fault {
        try {
            TopicSubscriber tSub = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            TestUtil.logTrace((String)"** Close default TopicSubscriber **");
            this.tool.getDefaultTopicSubscriber().close();
            this.tool.getDefaultTopicConnection().start();
            tSub = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic(), "=TEST 'test'", false);
            TestUtil.logTrace((String)"FAIL --- should not have gotten this far!");
            throw new EETest.Fault("xInvalidSelectorException test Failed!");
        }
        catch (InvalidSelectorException es) {
            TestUtil.logTrace((String)"Passed.\n");
            TestUtil.logMsg((String)"InvalidSelectorException occurred!");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Got Exception instead: ", (Throwable)e);
            TestUtil.logTrace((String)"Expected InvalidSelectorException did not occur!");
            throw new EETest.Fault("xInvalidSelectorExceptionTopicTest eee", e);
        }
    }

    public void xIllegalStateExceptionTopicTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logMsg("Calling session.commit(), an illegal operation.");
            try {
                this.tool.getDefaultTopicSession().commit();
            }
            catch (IllegalStateException iStateE) {
                this.logMsg("Received jakarta.jms.IllegalStateException -- GOOD");
                passed = true;
            }
            if (!passed) {
                throw new Exception("Did not receive IllegalStateException");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("xIllegalStateExceptionTopicTest");
        }
    }

    public void xUnsupportedOperationExceptionTTest1() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            boolean pass = true;
            Topic myTopic = null;
            TopicPublisher tPub = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicPublisher().close();
            tPub = this.tool.getDefaultTopicSession().createPublisher(myTopic);
            this.tool.getDefaultTopicConnection().start();
            try {
                messageSent = this.tool.getDefaultTopicSession().createTextMessage();
                messageSent.setText("sending a Text message");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xUnsupportedOperationExceptionTTest1");
                this.logTrace("sending a Text message");
                tPub.publish((Message)messageSent);
                pass = false;
                this.logErr("Error: TopicPublisher.publish(Message) didn't throw expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException ex) {
                this.logMsg("Got expected UnsupportedOperationException from  TopicPublisher.publish(Message)");
            }
            catch (Exception e) {
                this.logErr("Error:  TopicPublisher.publish(Message) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                messageSent = this.tool.getDefaultTopicSession().createTextMessage();
                messageSent.setText("sending a Text message");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xUnsupportedOperationExceptionTTest1");
                this.logTrace("sending a Text message");
                tPub.publish((Message)messageSent, 2, 4, 0L);
                pass = false;
                this.logErr("Error: TopicPublisher.publish(Message, int, int, long) didn't throw expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException ex) {
                this.logMsg("Got expected UnsupportedOperationException from  TopicPublisher.publish(Message, int, int, long)");
            }
            catch (Exception e) {
                this.logErr("Error:  TopicPublisher.publish(Message, int, int, long) throw incorrect Exception: ", e);
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("xUnsupportedOperationExceptionTTest1 Failed!");
            }
        }
        catch (Exception e) {
            this.logErr("xUnsupportedOperationExceptionTTest1 Failed!", e);
            throw new EETest.Fault("xUnsupportedOperationExceptionTTest1 Failed!", e);
        }
        finally {
            try {
                if (this.tool.getDefaultTopicConnection() != null) {
                    this.tool.getDefaultTopicConnection().close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception closing TopicConnection and cleanup", (Throwable)e);
            }
        }
    }

    public void xInvalidDestinationExceptionTTests() throws EETest.Fault {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            boolean pass = true;
            Destination dummy = null;
            Object dummyT = null;
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            try {
                this.tool.getDefaultSession().createConsumer(dummy);
                this.logErr("Error: createConsumer(null) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createConsumer(null)");
            }
            catch (Exception e) {
                this.logErr("Error: createConsumer(null) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'");
                this.logErr("Error: createConsumer(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createConsumer(null, String)");
            }
            catch (Exception e) {
                this.logErr("Error: createConsumer(null, String) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'", true);
                this.logErr("Error: createConsumer(null, String, boolean) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createConsumer(null, String, true)");
            }
            catch (Exception e) {
                this.logErr("Error: createConsumer(null, String, true) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing default Connection", ex);
            }
            if (!pass) {
                throw new EETest.Fault("xInvalidDestinationExceptionTTests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("xInvalidDestinationExceptionTTests");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing Connection", ex);
            }
        }
    }

    public void xMessageNotReadableExceptionTBytesMsgTest() throws EETest.Fault {
        try {
            BytesMessage messageSent = null;
            boolean pass = true;
            boolean booleanValue = false;
            byte byteValue = 127;
            byte[] bytesValue = new byte[]{127, -127, 1, 0};
            byte[] bytesValueRecvd = new byte[]{0, 0, 0, 0};
            char charValue = 'Z';
            double doubleValue = 6.02E23;
            float floatValue = 6.02E23f;
            int intValue = Integer.MAX_VALUE;
            long longValue = Long.MAX_VALUE;
            Integer nInteger = new Integer(Integer.MIN_VALUE);
            short shortValue = Short.MIN_VALUE;
            String utfValue = "what";
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultSession().createBytesMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotReadableExceptionTBytesMsgTest");
            this.logMsg("Writing one of each primitive type to the message");
            messageSent.writeBoolean(booleanValue);
            messageSent.writeByte(byteValue);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(doubleValue);
            messageSent.writeFloat(floatValue);
            messageSent.writeInt(intValue);
            messageSent.writeLong(longValue);
            messageSent.writeObject((Object)nInteger);
            messageSent.writeShort(shortValue);
            messageSent.writeUTF(utfValue);
            messageSent.writeBytes(bytesValue);
            messageSent.writeBytes(bytesValue, 0, 1);
            try {
                messageSent.getBodyLength();
                pass = false;
                TestUtil.logErr((String)"Error: getBodyLength didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"getBodyLength threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"getBodyLength threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readBoolean();
                pass = false;
                TestUtil.logErr((String)"Error: readBoolean didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readBoolean threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readBoolean threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readByte();
                pass = false;
                TestUtil.logErr((String)"Error: readByte didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readByte threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readByte threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readUnsignedByte();
                pass = false;
                TestUtil.logErr((String)"Error: readUnsignedByte didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readUnsignedByte threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readUnsignedByte threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readShort();
                pass = false;
                TestUtil.logErr((String)"Error: readShort didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readShort threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readShort threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readUnsignedShort();
                pass = false;
                TestUtil.logErr((String)"Error: readUnsignedShort didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readUnsignedShort threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readUnsignedShort threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readChar();
                pass = false;
                TestUtil.logErr((String)"Error: readChar didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readChar threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readChar threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readInt();
                pass = false;
                TestUtil.logErr((String)"Error: readInt didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readInt threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readInt threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readLong();
                pass = false;
                TestUtil.logErr((String)"Error: readLong didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readLong threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readLong threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readFloat();
                pass = false;
                TestUtil.logErr((String)"Error: readFloat didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readFloat threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readFloat threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readDouble();
                pass = false;
                TestUtil.logErr((String)"Error: readDouble didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readDouble threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readDouble threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readUTF();
                pass = false;
                TestUtil.logErr((String)"Error: readUTF didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readUTF threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readUTF threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readBytes(bytesValueRecvd);
                pass = false;
                TestUtil.logErr((String)"Error: readBytes(byte[]) didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readBytes(byte[]) threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readBytes(byte[]) threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readBytes(bytesValueRecvd, 1);
                pass = false;
                TestUtil.logErr((String)"Error: readBytes(byte[], int) didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readBytes(byte[], int) threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readBytes(byte[],int) threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("xMessageNotReadableExceptionTBytesMsgTest Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("xMessageNotReadableExceptionTBytesMsgTest:");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing Connection", ex);
            }
        }
    }

    public void xMessageNotReadableExceptionTStreamMsgTest() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            boolean pass = true;
            byte bValue = 127;
            boolean abool = false;
            byte[] bValues = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
            byte[] bValues2 = new byte[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
            byte[] bValuesReturned = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            char charValue = 'Z';
            short sValue = Short.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            double dValue = 6.02E23;
            float fValue = 6.02E23f;
            int iValue = 6;
            String myString = "text";
            String sTesting = "Testing StreamMessages";
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotReadableExceptionTStreamMsgTest");
            this.logTrace("");
            this.logMsg("Writing one of each primitive type to the message");
            messageSent.writeBytes(bValues2, 0, bValues.length);
            messageSent.writeBoolean(abool);
            messageSent.writeByte(bValue);
            messageSent.writeBytes(bValues);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(dValue);
            messageSent.writeFloat(fValue);
            messageSent.writeInt(iValue);
            messageSent.writeLong(lValue);
            messageSent.writeObject((Object)sTesting);
            messageSent.writeShort(sValue);
            messageSent.writeString(myString);
            messageSent.writeObject(null);
            this.logTrace("Sending message");
            this.tool.getDefaultProducer().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            TestUtil.logTrace((String)"call ClearBody()");
            messageReceived.clearBody();
            try {
                messageReceived.readBoolean();
                pass = false;
                TestUtil.logErr((String)"Error: readBoolean didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readBoolean threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readBoolean threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readByte();
                pass = false;
                TestUtil.logErr((String)"Error: readByte didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readByte threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readByte threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readShort();
                pass = false;
                TestUtil.logErr((String)"Error: readShort didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readShort threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readShort threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readChar();
                pass = false;
                TestUtil.logErr((String)"Error: readChar didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readChar threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readChar threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readInt();
                pass = false;
                TestUtil.logErr((String)"Error: readInt didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readInt threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readInt threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readLong();
                pass = false;
                TestUtil.logErr((String)"Error: readLong didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readLong threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readLong threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readFloat();
                pass = false;
                TestUtil.logErr((String)"Error: readFloat didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readFloat threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readFloat threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readDouble();
                pass = false;
                TestUtil.logErr((String)"Error: readDouble didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readDouble threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readDouble threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readString();
                pass = false;
                TestUtil.logErr((String)"Error: readString didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readString threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readString threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readBytes(bValuesReturned);
                pass = false;
                TestUtil.logErr((String)"Error: readBytes(byte[]) didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readBytes(byte[]) threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readBytes(byte[]) threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readObject();
                pass = false;
                TestUtil.logErr((String)"Error: readObject didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readObject threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readObject threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("xMessageNotReadableExceptionTStreamMsgTest Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("xMessageNotReadableExceptionTStreamMsgTest:");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing Connection", ex);
            }
        }
    }

    public void xIllegalStateExceptionTestQueueMethodsT() throws EETest.Fault {
        try {
            boolean pass = true;
            Queue myQueue = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            myQueue = this.tool.createNewQueue("MY_QUEUE");
            try {
                this.tool.getDefaultTopicSession().createBrowser(myQueue);
                pass = false;
                TestUtil.logErr((String)"Error: TopicSession.createBrowser(Queue) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from TopicSession.createBrowser(Queue)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: TopicSession.createBrowser(Queue) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultTopicSession().createBrowser(myQueue, "TEST = 'test'");
                pass = false;
                TestUtil.logErr((String)"Error: TopicSession.createBrowser(Queue, String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from TopicSession.createBrowser(Queue, String)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: TopicSession.createBrowser(Queue, String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultTopicSession().createTemporaryQueue();
                pass = false;
                TestUtil.logErr((String)"Error: TopicSession.createTemporayQueue() didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from TopicSession.createTemporayQueue()");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: TopicSession.createTemporayQueue() throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultTopicSession().createQueue("foo");
                pass = false;
                TestUtil.logErr((String)"Error: TopicSession.createQueue(String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from TopicSession.createQueue(String)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: TopicSession.createQueue(String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("xIllegalStateExceptionTestQueueMethodsT Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("xIllegalStateExceptionTestQueueMethodsT");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Error closing Connection", (Throwable)ex);
            }
        }
    }
}

