/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.defaultmapping.basictypes;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.MappingTester;
import com.sun.ts.tests.jsonb.SimpleMappingTester;
import com.sun.ts.tests.jsonb.defaultmapping.basictypes.model.BooleanContainer;
import com.sun.ts.tests.jsonb.defaultmapping.basictypes.model.ByteContainer;
import com.sun.ts.tests.jsonb.defaultmapping.basictypes.model.CharacterContainer;
import com.sun.ts.tests.jsonb.defaultmapping.basictypes.model.DoubleContainer;
import com.sun.ts.tests.jsonb.defaultmapping.basictypes.model.FloatContainer;
import com.sun.ts.tests.jsonb.defaultmapping.basictypes.model.IntegerContainer;
import com.sun.ts.tests.jsonb.defaultmapping.basictypes.model.LongContainer;
import com.sun.ts.tests.jsonb.defaultmapping.basictypes.model.NumberContainer;
import com.sun.ts.tests.jsonb.defaultmapping.basictypes.model.ShortContainer;
import com.sun.ts.tests.jsonb.defaultmapping.basictypes.model.StringContainer;
import java.math.BigDecimal;
import java.util.Properties;

public class BasicJavaTypesMappingTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;

    public static void main(String[] args) {
        BasicJavaTypesMappingTest t = new BasicJavaTypesMappingTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testStringMapping() throws Exception {
        MappingTester<String> stringMappingTester = new MappingTester<String>(StringContainer.class);
        return MappingTester.combine(stringMappingTester.test("Test String", "\"Test String\""), stringMappingTester.test(new String(new byte[]{-17, -69, -65}, "UTF-8"), "\"" + new String(new byte[]{-17, -69, -65}, "UTF-8") + "\""), stringMappingTester.test(new String("Test String".getBytes(), "UTF-8"), "\"" + new String("Test String".getBytes(), "UTF-8") + "\""));
    }

    public Status testCharacterMapping() throws EETest.Fault {
        MappingTester<Character> characterMappingTester = new MappingTester<Character>(CharacterContainer.class);
        return MappingTester.combine(characterMappingTester.test(Character.valueOf('c'), "\"c\""), characterMappingTester.test(Character.valueOf('\u0000'), "\"\\u0000\""), characterMappingTester.test(Character.valueOf('\uffff'), "\"\uffff\""));
    }

    public Status testByteMapping() throws EETest.Fault {
        MappingTester<Byte> byteMappingTester = new MappingTester<Byte>(ByteContainer.class);
        return MappingTester.combine(byteMappingTester.test((byte)0, "0"), byteMappingTester.test((byte)-128, String.valueOf(-128)), byteMappingTester.test((byte)127, String.valueOf(127)));
    }

    public Status testShortMapping() throws EETest.Fault {
        MappingTester<Short> shortMappingTester = new MappingTester<Short>(ShortContainer.class);
        return MappingTester.combine(shortMappingTester.test((short)0, "0"), shortMappingTester.test((short)Short.MIN_VALUE, String.valueOf(Short.MIN_VALUE)), shortMappingTester.test((short)Short.MAX_VALUE, String.valueOf(Short.MAX_VALUE)));
    }

    public Status testIntegerMapping() throws EETest.Fault {
        MappingTester<Integer> integerMappingTester = new MappingTester<Integer>(IntegerContainer.class);
        return MappingTester.combine(integerMappingTester.test(0, "0"), integerMappingTester.test(Integer.MIN_VALUE, String.valueOf(Integer.MIN_VALUE)), integerMappingTester.test(Integer.MAX_VALUE, String.valueOf(Integer.MAX_VALUE)));
    }

    public Status testLongMapping() throws EETest.Fault {
        MappingTester<Long> longMappingTester = new MappingTester<Long>(LongContainer.class);
        return MappingTester.combine(longMappingTester.test(0L, "0"), longMappingTester.test(Long.MIN_VALUE, String.valueOf(Long.MIN_VALUE)), longMappingTester.test(Long.MAX_VALUE, String.valueOf(Long.MAX_VALUE)));
    }

    public Status testFloatMapping() throws EETest.Fault {
        MappingTester<Float> floatMappingTester = new MappingTester<Float>(FloatContainer.class);
        return MappingTester.combine(floatMappingTester.test(Float.valueOf(0.0f), "0.0"), floatMappingTester.test(Float.valueOf(0.5f), "0.5"), floatMappingTester.test(Float.valueOf(Float.MIN_VALUE), String.valueOf(Float.MIN_VALUE)), floatMappingTester.test(Float.valueOf(Float.MAX_VALUE), String.valueOf(Float.MAX_VALUE)));
    }

    public Status testDoubleMapping() throws EETest.Fault {
        MappingTester<Double> doubleMappingTester = new MappingTester<Double>(DoubleContainer.class);
        return MappingTester.combine(doubleMappingTester.test(0.0, "0.0"), doubleMappingTester.test((Double)Double.MIN_VALUE, String.valueOf(Double.MIN_VALUE)), doubleMappingTester.test((Double)Double.MAX_VALUE, String.valueOf(Double.MAX_VALUE)));
    }

    public Status testBooleanMapping() throws EETest.Fault {
        MappingTester<Boolean> booleanMappingTester = new MappingTester<Boolean>(BooleanContainer.class);
        return MappingTester.combine(booleanMappingTester.test(true, "true"), booleanMappingTester.test(false, "false"), booleanMappingTester.test(Boolean.TRUE, Boolean.TRUE.toString()), booleanMappingTester.test(Boolean.FALSE, Boolean.FALSE.toString()));
    }

    public Status testNumberMapping() throws EETest.Fault {
        return new SimpleMappingTester<NumberContainer>(NumberContainer.class).test(new NumberContainer(), "\\{\\s*\"instance\"\\s*:\\s*0[\\.0]?+\\s*}", "{ \"instance\" : 0 }", new NumberContainer(){
            {
                this.setInstance(new BigDecimal("0"));
            }
        });
    }
}

