/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsongeneratortests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.JsonValueType;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Generator {
    private static final Object[] VALUES = new Object[]{SimpleValues.OBJ_VALUE, SimpleValues.createEmptyArrayWithStr(), "In a galaxy far far away", 42, 9223372036854775765L, 3.441073578556931E305, SimpleValues.BIN_VALUE, SimpleValues.BDC_VALUE, true, null};

    Generator() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonGenerator API methods for RFC 7159 grammar changes.");
        TestUtil.logMsg((String)"JsonGenerator API methods for RFC 7159 grammar changes.");
        this.testPrimitiveTypesInRoot(result);
        this.testWrittingObjectByParts(result);
        return result;
    }

    private void testPrimitiveTypesInRoot(TestResult result) {
        for (Object value : VALUES) {
            String typeName = JsonValueType.getType(value).name();
            TestUtil.logMsg((String)(" - write(JsonValue) for " + typeName + " as an argument"));
            this.verifyJsonGeneratorForJsonValue(result, value);
            this.verifyJsonGeneratorForSimpleType(result, value);
        }
    }

    private void testWrittingObjectByParts(TestResult result) {
        TestUtil.logMsg((String)" - generate JSON object");
        StringWriter strWriter = new StringWriter();
        try (JsonGenerator generator = Json.createGenerator((Writer)strWriter);){
            generator.writeStartObject();
            generator.writeKey("address");
            generator.write("In a galaxy far far away");
            generator.writeEnd();
        }
        String out = strWriter.toString();
        JsonObject check = SimpleValues.createSimpleObjectStr();
        if (this.operationFailed((JsonValue)check, out)) {
            String checkStr = check.toString();
            TestUtil.logMsg((String)("     Generated JSON object " + out + " shall be " + checkStr));
            result.fail("generate JSON object", "Generated value " + out + " shall be " + checkStr);
        } else {
            TestUtil.logMsg((String)("     Output: " + out));
        }
    }

    private void verifyJsonGeneratorForJsonValue(TestResult result, Object value) {
        StringWriter strWriter = new StringWriter();
        JsonValue jsonValue = SimpleValues.toJsonValue(value);
        try (JsonGenerator generator = Json.createGenerator((Writer)strWriter);){
            generator.write(jsonValue);
        }
        String out = strWriter.toString();
        if (this.operationFailed(jsonValue, out)) {
            String check = jsonValue.toString();
            TestUtil.logMsg((String)("     Generated JSON value " + out + " shall be " + check));
            result.fail("write(JsonValue)", "Generated value " + out + " shall be " + check);
        } else {
            TestUtil.logMsg((String)("     Output (JsonValue): " + out));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void verifyJsonGeneratorForSimpleType(TestResult result, Object value) {
        strWriter = new StringWriter();
        generator = Json.createGenerator((Writer)strWriter);
        var5_5 = null;
        try {
            switch (1.$SwitchMap$com$sun$ts$tests$jsonp$api$common$JsonValueType[JsonValueType.getType(value).ordinal()]) {
                case 1: {
                    generator.write((String)value);
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 2: {
                    generator.write(((Integer)value).intValue());
                    ** break;
lbl15:
                    // 1 sources

                    break;
                }
                case 3: {
                    generator.write(((Long)value).longValue());
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                case 4: {
                    generator.write((BigInteger)value);
                    ** break;
lbl25:
                    // 1 sources

                    break;
                }
                case 5: {
                    generator.write(((Double)value).doubleValue());
                    ** break;
lbl30:
                    // 1 sources

                    break;
                }
                case 6: {
                    generator.write((BigDecimal)value);
                    ** break;
lbl35:
                    // 1 sources

                    break;
                }
                case 7: {
                    generator.write((Boolean)value != false ? JsonValue.TRUE : JsonValue.FALSE);
                    ** break;
lbl40:
                    // 1 sources

                    break;
                }
                case 8: {
                    generator.write((JsonValue)value);
                    ** break;
lbl45:
                    // 1 sources

                    break;
                }
                case 9: {
                    generator.write(JsonValue.NULL);
                    ** break;
lbl50:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalArgumentException("Value does not match known JSON value type");
                }
            }
        }
        catch (Throwable var6_7) {
            var5_5 = var6_7;
            throw var6_7;
        }
        finally {
            if (generator != null) {
                if (var5_5 != null) {
                    try {
                        generator.close();
                    }
                    catch (Throwable var6_6) {
                        var5_5.addSuppressed(var6_6);
                    }
                } else {
                    generator.close();
                }
            }
        }
        out = strWriter.toString();
        if (this.operationFailed(value, out)) {
            check = SimpleValues.toJsonValue(value).toString();
            TestUtil.logMsg((String)("     Generated simple value " + out + " shall be " + check));
            result.fail("write(JsonValue)", "Generated value " + out + " shall be " + check);
        } else {
            TestUtil.logMsg((String)("     Output (simple): " + out));
        }
    }

    protected boolean operationFailed(Object check, String out) {
        return out == null || !JsonAssert.assertEquals(check, out);
    }

    protected boolean operationFailed(JsonValue check, String out) {
        if (out == null) {
            return true;
        }
        try (JsonReader reader = Json.createReader((Reader)new StringReader(out));){
            JsonValue actVal = reader.readValue();
            boolean bl = !JsonAssert.assertEquals(check, actVal);
            return bl;
        }
    }
}

