/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.types.primarykey.compound;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.types.primarykey.compound.CompoundPK;
import com.sun.ts.tests.jpa.core.types.primarykey.compound.CompoundPK2;
import com.sun.ts.tests.jpa.core.types.primarykey.compound.CompoundPK3;
import com.sun.ts.tests.jpa.core.types.primarykey.compound.TestBean;
import com.sun.ts.tests.jpa.core.types.primarykey.compound.TestBean2;
import com.sun.ts.tests.jpa.core.types.primarykey.compound.TestBean3;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final CompoundPK refPK1 = new CompoundPK(1, "cof0001", 1.0f);
    private static final CompoundPK refPK2 = new CompoundPK(2, "cof0002", 2.0f);
    private static final CompoundPK2 refPK3 = new CompoundPK2(3, "cof0003", 3.0f);
    private static final CompoundPK2 refPK4 = new CompoundPK2(4, "cof0004", 4.0f);
    private static final CompoundPK3 refPK5 = new CompoundPK3(5, "cof0005", 5.0f);
    private static final CompoundPK3 refPK6 = new CompoundPK3(6, "cof0006", 6.0f);

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"Entering setup");
        super.setup(args, p);
        this.removeTestData();
    }

    public void testCompoundPK1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Creating bean1 and bean2 instance...");
            TestBean bean1 = new TestBean(refPK1, "Arabica", 10.0f);
            TestBean bean2 = new TestBean(refPK2, "Java", 12.0f);
            this.getEntityManager().persist((Object)bean1);
            this.getEntityManager().persist((Object)bean2);
            this.getEntityManager().flush();
            TestUtil.logTrace((String)"[Client] Locate beans using primary keys...");
            TestBean bean3 = (TestBean)this.getEntityManager().find(TestBean.class, (Object)refPK1);
            TestBean bean4 = (TestBean)this.getEntityManager().find(TestBean.class, (Object)refPK2);
            TestUtil.logTrace((String)"Check we can call the beans...");
            bean1.ping();
            bean2.ping();
            bean3.ping();
            bean4.ping();
            TestUtil.logTrace((String)"Check beans are identical...");
            if (bean1 == bean3) {
                TestUtil.logTrace((String)"bean1 and bean3 are equal");
                pass = true;
            }
            if (!pass) {
                throw new Exception("testCompoundPK1: bean1 and bean3 should be identical!");
            }
            if (bean2 == bean4) {
                TestUtil.logTrace((String)"bean2 and bean4 are equal");
                pass = true;
            }
            if (!pass) {
                throw new Exception("[testCompoundPK1] bean2 and bean4 should be identical!");
            }
            TestUtil.logTrace((String)"Comparing primary keys...");
            CompoundPK valPK1 = bean3.getCompoundPK();
            CompoundPK valPK2 = bean4.getCompoundPK();
            if (valPK1.equals((Object)refPK1) && refPK1.equals((Object)valPK1)) {
                TestUtil.logTrace((String)"testCompoundPK1: valPK1 equals refPK1");
                pass = true;
            }
            if (!pass) {
                throw new Exception("testCompoundPK1: bean1 and bean3 PK should match!");
            }
            if (valPK2.equals((Object)refPK2) && refPK2.equals((Object)valPK2)) {
                TestUtil.logTrace((String)"testCompoundPK1: valPK2 equals refPK2");
                pass = true;
            }
            if (!pass) {
                throw new EETest.Fault("[testCompoundPK1] bean2 and bean4 PK should match!");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[testCompoundPK1] Caught exception: " + e));
            throw new EETest.Fault("testCompoundPK1 test failed: " + e, e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[testCompoundPK1] Exception caught while rolling back TX", (Throwable)e);
            }
        }
    }

    public void testCompoundPK2() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Creating bean1 and bean2 instance...");
            TestBean2 bean1 = new TestBean2(Integer.valueOf(3), "cof0003", Float.valueOf(3.0f), "Vanilla", 10.0f);
            TestBean2 bean2 = new TestBean2(Integer.valueOf(4), "cof0004", Float.valueOf(4.0f), "Mocha Java", 12.0f);
            this.getEntityManager().persist((Object)bean1);
            this.getEntityManager().persist((Object)bean2);
            this.getEntityManager().flush();
            TestUtil.logTrace((String)"Locate beans using primary keys...");
            TestBean2 bean3 = (TestBean2)this.getEntityManager().find(TestBean2.class, (Object)refPK3);
            TestBean2 bean4 = (TestBean2)this.getEntityManager().find(TestBean2.class, (Object)refPK4);
            TestUtil.logTrace((String)"Check we can call the beans...");
            bean1.ping();
            bean2.ping();
            bean3.ping();
            bean4.ping();
            TestUtil.logTrace((String)"Check beans are identical...");
            if (bean1 == bean3) {
                TestUtil.logTrace((String)"bean1 and bean3 are equal");
                pass = true;
            }
            if (!pass) {
                throw new Exception("[testCompoundPK2] bean1 and bean3 should be identical!");
            }
            if (bean2 == bean4) {
                TestUtil.logTrace((String)"bean2 and bean4 are equal");
                pass = true;
            }
            if (!pass) {
                throw new EETest.Fault("[testCompoundPK2] bean2 and bean4 PK should match!");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[testCompoundPK2] Caught exception: " + e));
            throw new EETest.Fault("testCompoundPK2 test failed: " + e, e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[testCompoundPK2] Exception caught while rolling back TX", (Throwable)e);
            }
        }
    }

    public void testCompoundPK3() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Creating bean1 and bean2 instance...");
            TestBean3 bean1 = new TestBean3(Integer.valueOf(5), "cof0005", Float.valueOf(5.0f), "Cinnamon", 11.0f);
            TestBean3 bean2 = new TestBean3(Integer.valueOf(6), "cof0006", Float.valueOf(6.0f), "Hazelnut", 12.0f);
            this.getEntityManager().persist((Object)bean1);
            this.getEntityManager().persist((Object)bean2);
            this.getEntityManager().flush();
            TestUtil.logTrace((String)"Locate beans using primary keys...");
            TestBean3 bean3 = (TestBean3)this.getEntityManager().find(TestBean3.class, (Object)refPK5);
            TestBean3 bean4 = (TestBean3)this.getEntityManager().find(TestBean3.class, (Object)refPK6);
            TestUtil.logTrace((String)"Check we can call the beans...");
            bean1.ping();
            bean2.ping();
            bean3.ping();
            bean4.ping();
            TestUtil.logTrace((String)"Check beans are identical...");
            if (bean1 == bean3) {
                TestUtil.logTrace((String)"bean1 and bean3 are equal");
                pass = true;
            }
            if (!pass) {
                throw new Exception("[testCompoundPK3] bean1 and bean3 should be identical!");
            }
            if (bean2 == bean4) {
                TestUtil.logTrace((String)"bean2 and bean4 are equal");
                pass = true;
            }
            if (!pass) {
                throw new EETest.Fault("[testCompoundPK3] bean2 and bean4 PK should match!");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[testCompoundPK3] Caught exception: " + e));
            throw new EETest.Fault("testCompoundPK3 test failed: " + e, e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[testCompoundPK3] Exception caught while rolling back TX", (Throwable)e);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PKEY").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

