/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import jakarta.batch.runtime.BatchStatus;
import java.util.Properties;
import java.util.logging.Logger;

public class ExecutionTests
extends ServiceEETest {
    private static final Logger logger = Logger.getLogger(ExecutionTests.class.getName());
    private static JobOperatorBridge jobOp;

    public static void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    public static void setUp() throws EETest.Fault {
        jobOp = new JobOperatorBridge();
    }

    public static void cleanup() throws EETest.Fault {
    }

    private void begin(String str) {
        TestUtil.logMsg((String)("Begin test method: " + str));
    }

    public void testInvokeJobWithOneBatchletStep() throws EETest.Fault {
        String METHOD = "testInvokeJobWithOneBatchletStep";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_1step.xml");
            TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_1step");
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    public void testInvokeJobWithTwoStepSequenceOfBatchlets() throws EETest.Fault {
        String METHOD = "testInvokeJobWithTwoStepSequenceOfBatchlets";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_2steps.xml");
            TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_2steps");
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    public void testInvokeJobWithFourStepSequenceOfBatchlets() throws EETest.Fault {
        String METHOD = "testInvokeJobWithFourStepSequenceOfBatchlets";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_4steps.xml");
            TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_4steps");
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    public void testInvokeJobWithNextElement() throws EETest.Fault {
        String METHOD = "testInvokeJobWithNextElement";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_nextElement.xml");
            TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_nextElement");
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    public void testInvokeJobWithFailElement() throws EETest.Fault {
        String METHOD = "testInvokeJobWithFailElement";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_failElement.xml");
            TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_failElement");
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals("TEST_FAIL", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    public void testInvokeJobWithStopElement() throws EETest.Fault {
        String METHOD = "testInvokeJobWithStopElement";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_stopElement.xml");
            TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_stopElement");
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    public void testInvokeJobWithEndElement() throws EETest.Fault {
        String METHOD = "testInvokeJobWithEndElement";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_endElement.xml");
            TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_endElement");
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals("TEST_ENDED", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    public void testInvokeJobSimpleChunk() throws EETest.Fault {
        String METHOD = "testInvokeJobSimpleChunk";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_chunk_simple.xml");
            TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_simple");
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    public void testInvokeJobChunkWithFullAttributes() throws EETest.Fault {
        String METHOD = "testInvokeJobChunkWithFullAttributes";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_chunk_full_attributes.xml");
            TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_full_attributes");
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    public void testInvokeJobUsingTCCL() throws EETest.Fault {
        String METHOD = "testInvokeJobUsingTCCL";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Run job using job XML file: test_artifact_load_classloader");
            TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("test_artifact_load_classloader");
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    public void testCheckpoint() throws EETest.Fault {
        String METHOD = "testCheckpoint";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_chunk_checkpoint.xml");
            TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_checkpoint");
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    public void testSimpleFlow() throws EETest.Fault {
        String METHOD = "testSimpleFlow";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_flow_batchlet_4steps.xml");
            TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_flow_batchlet_4steps");
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }
}

