/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jta.ee.txpropagationtest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;

public class TxBeanEJB
implements SessionBean {
    private Properties testProps = null;
    private SessionContext sctx = null;
    private transient Connection con1;
    private transient Connection con2;
    private transient Statement stmt;
    private transient PreparedStatement pStmt;
    private String dbUser1;
    private String dbPassword1;
    private String dbTable1;
    private String dbTable2;
    private Integer dbSize1;
    private Integer dbSize2;
    private DataSource ds1;
    private DataSource ds2;
    private TSNamingContext context = null;

    public void ejbCreate(Properties p) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.testProps = p;
        try {
            TestUtil.init((Properties)p);
            this.context = new TSNamingContext();
            this.dbTable1 = TestUtil.getTableName((String)p.getProperty("JTA_Tab1_Delete"));
            this.dbSize1 = (Integer)this.context.lookup("java:comp/env/size");
            this.ds1 = (DataSource)this.context.lookup("java:comp/env/jdbc/DB1");
            TestUtil.logTrace((String)("ds1: " + this.ds1));
            TestUtil.logMsg((String)(this.dbTable1 + " DataSource lookup OK!"));
            this.dbTable2 = TestUtil.getTableName((String)p.getProperty("JTA_Tab2_Delete"));
            this.dbSize2 = (Integer)this.context.lookup("java:comp/env/size");
            this.ds2 = (DataSource)this.context.lookup("java:comp/env/jdbc/DB1");
            TestUtil.logTrace((String)("ds2: " + this.ds2));
            TestUtil.logMsg((String)(this.dbTable2 + " DataSource lookup OK!"));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception getting the DB DataSource", (Throwable)e);
            throw new CreateException(e.getMessage());
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void dbConnect(String tName) {
        TestUtil.logTrace((String)"dbConnect");
        try {
            if (tName.equals(this.dbTable1)) {
                this.conTable1();
                TestUtil.logMsg((String)("Made the JDBC connection to " + this.dbTable1 + " DB"));
            } else {
                this.conTable2();
                TestUtil.logMsg((String)("Made the JDBC connection to " + this.dbTable2 + " DB"));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception on JDBC connection", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void createData(String tName) {
        TestUtil.logTrace((String)"createData");
        try {
            if (tName.equals(this.dbTable1)) {
                this.createTable1();
                TestUtil.logMsg((String)("Created the table " + this.dbTable1 + " "));
            } else {
                this.createTable2();
                TestUtil.logMsg((String)("Created the table " + this.dbTable2 + " "));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception creating table", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public boolean insert(String tName, int key) {
        TestUtil.logTrace((String)"insert");
        int newKey = key;
        String newName = null;
        float newPrice = 0.0f + (float)newKey;
        try {
            if (tName.equals(this.dbTable1)) {
                newName = this.dbTable1 + "-" + newKey;
                String updateString = TestUtil.getProperty((String)"JTA_Tab1_Insert");
                this.pStmt = this.con1.prepareStatement(updateString);
            } else {
                newName = this.dbTable2 + "-" + newKey;
                String updateString = TestUtil.getProperty((String)"JTA_Tab2_Insert");
                this.pStmt = this.con2.prepareStatement(updateString);
            }
            this.pStmt.setInt(1, newKey);
            this.pStmt.setString(2, newName);
            this.pStmt.setFloat(3, newPrice);
            this.pStmt.executeUpdate();
            this.pStmt.close();
            TestUtil.logTrace((String)("Inserted a row into the table " + tName));
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception inserting a row into table " + tName + ";\n" + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public void delete(String tName, int fromKey, int toKey) {
        TestUtil.logTrace((String)"delete");
        try {
            String updateString;
            if (tName.equals(this.dbTable1)) {
                updateString = TestUtil.getProperty((String)"JTA_Delete1");
                this.pStmt = this.con1.prepareStatement(updateString);
            } else {
                updateString = TestUtil.getProperty((String)"JTA_Delete2");
                this.pStmt = this.con2.prepareStatement(updateString);
            }
            for (int i = fromKey; i <= toKey; ++i) {
                this.pStmt.setInt(1, i);
                this.pStmt.executeUpdate();
            }
            this.pStmt.close();
            TestUtil.logTrace((String)("Deleted row(s) " + fromKey + " thru " + toKey + " from the table " + tName));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception deleting row(s) " + fromKey + " thru " + toKey + " from the table " + tName), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void destroyData(String tName) {
        TestUtil.logTrace((String)"destroyData");
        try {
            if (tName.equals(this.dbTable1)) {
                this.dropTable1();
                TestUtil.logMsg((String)("Deleted all rows from table " + this.dbTable1));
            } else {
                this.dropTable2();
                TestUtil.logMsg((String)("Deleted all rows from table " + this.dbTable2));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occured trying to drop table", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void dbUnConnect(String tName) {
        TestUtil.logTrace((String)"dbUnConnect");
        try {
            if (tName.equals(this.dbTable1)) {
                this.con1.close();
                this.con1 = null;
                TestUtil.logTrace((String)("Closed " + this.dbTable1 + " connection"));
            } else {
                this.con2.close();
                this.con2 = null;
                TestUtil.logTrace((String)("Closed " + this.dbTable2 + " connection"));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occured trying to close the DB connection", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public Vector getResults(String tName) {
        TestUtil.logTrace((String)"getResults");
        Vector<Object> queryResults = new Vector<Object>();
        try {
            String name;
            ResultSet rs;
            String query;
            if (tName.equals(this.dbTable1)) {
                query = TestUtil.getProperty((String)"JTA_Tab1_Select");
                this.stmt = this.con1.createStatement();
                rs = this.stmt.executeQuery(query);
                name = "COF_NAME";
            } else {
                query = TestUtil.getProperty((String)"JTA_Tab2_Select");
                this.stmt = this.con2.createStatement();
                rs = this.stmt.executeQuery(query);
                name = "CHOC_NAME";
            }
            while (rs.next()) {
                int i = rs.getInt("KEY_ID");
                String s = rs.getString(name);
                float f = rs.getFloat("PRICE");
                queryResults.addElement(new Integer(i));
                queryResults.addElement(s);
                queryResults.addElement(new Float(f));
            }
            this.stmt.close();
            TestUtil.logMsg((String)("Obtained " + tName + " table ResultSet"));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception obtaining " + tName + " table ResultSet"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        return queryResults;
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        this.testProps = p;
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private void conTable1() {
        TestUtil.logTrace((String)"conTable1");
        try {
            this.con1 = this.ds1.getConnection();
            TestUtil.logTrace((String)("con1: " + this.con1.toString()));
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException connecting to " + this.dbTable1 + " DB"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        catch (Exception ee) {
            TestUtil.logErr((String)("Exception connecting to " + this.dbTable1 + " DB"), (Throwable)ee);
            throw new EJBException(ee.getMessage());
        }
    }

    private void conTable2() {
        TestUtil.logTrace((String)"conTable2");
        try {
            this.con2 = this.ds2.getConnection();
            TestUtil.logTrace((String)("con2: " + this.con2.toString()));
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException connecting to " + this.dbTable2 + " DB"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        catch (Exception ee) {
            TestUtil.logErr((String)("Exception connecting to " + this.dbTable2 + " DB"), (Throwable)ee);
            throw new EJBException(ee.getMessage());
        }
    }

    private void createTable1() {
        TestUtil.logTrace((String)"createTable1");
        try {
            this.dropTable1();
            TestUtil.logTrace((String)("All rows deleted from table " + this.dbTable1));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("SQLException encountered in createTable1: " + e.getMessage()));
        }
        try {
            TestUtil.logMsg((String)("Adding the " + this.dbTable1 + " table rows"));
            String updateString = TestUtil.getProperty((String)"JTA_Tab1_Insert");
            this.pStmt = this.con1.prepareStatement(updateString);
            for (int i = 1; i <= this.dbSize1; ++i) {
                int newKey = i;
                String newName = this.dbTable1 + "-" + i;
                float newPrice = (float)i + 0.0f;
                this.pStmt.setInt(1, newKey);
                this.pStmt.setString(2, newName);
                this.pStmt.setFloat(3, newPrice);
                this.pStmt.executeUpdate();
            }
            this.pStmt.close();
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException creating " + this.dbTable1 + " table"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private void createTable2() {
        TestUtil.logTrace((String)"createTable2");
        try {
            this.dropTable2();
            TestUtil.logTrace((String)("All rows deleted from table " + this.dbTable2));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("SQLException encountered in createTable2: " + e.getMessage()));
        }
        try {
            TestUtil.logMsg((String)("Adding the " + this.dbTable2 + " table rows"));
            String updateString = TestUtil.getProperty((String)"JTA_Tab2_Insert");
            this.pStmt = this.con2.prepareStatement(updateString);
            for (int i = 1; i <= this.dbSize2; ++i) {
                int newKey = i;
                String newName = this.dbTable2 + "-" + i;
                float newPrice = (float)i + 0.0f;
                this.pStmt.setInt(1, newKey);
                this.pStmt.setString(2, newName);
                this.pStmt.setFloat(3, newPrice);
                this.pStmt.executeUpdate();
            }
            this.pStmt.close();
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException creating " + this.dbTable2 + " table"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private void dropTable1() {
        TestUtil.logTrace((String)"dropTable1");
        String removeString = TestUtil.getProperty((String)"JTA_Tab1_Delete");
        try {
            this.stmt = this.con1.createStatement();
            this.stmt.executeUpdate(removeString);
            this.stmt.close();
        }
        catch (SQLException e) {
            throw new EJBException(e.getMessage());
        }
    }

    private void dropTable2() {
        TestUtil.logTrace((String)"dropTable2");
        String removeString = TestUtil.getProperty((String)"JTA_Tab2_Delete");
        try {
            this.stmt = this.con2.createStatement();
            this.stmt.executeUpdate(removeString);
            this.stmt.close();
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException dropping " + this.dbTable2 + " table"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }
}

