/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_rec;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import com.sun.ts.tests.jms.ee.mdb.mdb_rec.MDB_AR_Test;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.PostActivate;
import jakarta.ejb.PrePassivate;
import jakarta.ejb.Remote;
import jakarta.ejb.Remove;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateful;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;

@Stateful
@Remote(value={MDB_AR_Test.class})
public class MDB_AR_TestEJB {
    @Resource
    private SessionContext sessionContext;
    @Resource(name="jms/MDB_QUEUE_REPLY")
    private transient Queue rcvrQueue;
    @Resource(name="jms/MDB_QUEUE")
    private transient Queue queue;
    @Resource(name="jms/MyQueueConnectionFactory")
    private transient QueueConnectionFactory qcFactory;
    @Resource(name="jms/MDB_TOPIC")
    private transient Topic topic;
    @Resource(name="jms/MyTopicConnectionFactory")
    private transient TopicConnectionFactory tcFactory;
    private transient QueueConnection connection = null;
    private transient TopicConnection tConn = null;
    private Properties p = null;
    private String jmsUser;
    private String jmsPassword;
    private long timeout;

    public void setup(Properties props) {
        this.p = props;
        try {
            TestUtil.init((Properties)props);
            this.timeout = Long.parseLong(props.getProperty("jms_timeout"));
            this.jmsUser = props.getProperty("user");
            this.jmsPassword = props.getProperty("password");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.jmsUser == null) {
                throw new Exception("'user' in ts.jte must not be null");
            }
            if (this.jmsPassword == null) {
                throw new Exception("'password' in ts.jte must not be null");
            }
            if (this.qcFactory == null || this.tcFactory == null || this.queue == null || this.rcvrQueue == null || this.topic == null || this.sessionContext == null) {
                throw new Exception("@Resource injection failed");
            }
            this.tConn = this.tcFactory.createTopicConnection(this.jmsUser, this.jmsPassword);
            this.connection = this.qcFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            this.connection.start();
            this.tConn.start();
        }
        catch (Exception e) {
            throw new EJBException("@setup failed: ", e);
        }
    }

    public boolean isThereSomethingInTheQueue() {
        TestUtil.logTrace((String)"MDB_AR_TestEJB.isThereSomethingInTheQueue()");
        QueueBrowser qBrowser = null;
        Enumeration msgs = null;
        boolean ret = false;
        try {
            QueueSession session = this.connection.createQueueSession(true, 0);
            qBrowser = session.createBrowser(this.rcvrQueue);
            msgs = qBrowser.getEnumeration();
            if (msgs.hasMoreElements()) {
                ret = true;
            }
            qBrowser.close();
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error in isThereSomethingInTheQueue", (Throwable)e);
        }
        return ret;
    }

    public void cleanTheQueue() {
        TestUtil.logTrace((String)"MDB_AR_TestEJB.cleanTheQueue()");
        QueueBrowser qBrowser = null;
        Enumeration msgs = null;
        int numMsgs = 0;
        try {
            QueueSession session = this.connection.createQueueSession(true, 0);
            TextMessage msgRec = null;
            qBrowser = session.createBrowser(this.rcvrQueue);
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                msgs.nextElement();
                ++numMsgs;
            }
            qBrowser.close();
            QueueReceiver rcvr = session.createReceiver(this.rcvrQueue);
            TestUtil.logTrace((String)("Cleaning " + numMsgs + " messages from the Q: " + this.rcvrQueue.getQueueName()));
            block3: for (int n = 0; n < numMsgs; ++n) {
                TestUtil.logTrace((String)("dequeuing msg: " + n + " from the Q: " + this.rcvrQueue.getQueueName()));
                for (int i = 0; i < 10; ++i) {
                    msgRec = (TextMessage)rcvr.receive(this.timeout);
                    if (msgRec != null) {
                        TestUtil.logTrace((String)("dequeued message: " + n));
                        continue block3;
                    }
                    TestUtil.logTrace((String)("Attempt no: " + i + " Trying to dequeue message: " + n));
                }
            }
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error in cleanTheQueue", (Throwable)e);
        }
    }

    public boolean checkOnResponse(String prop) {
        TestUtil.logTrace((String)"MDB_AR_TestEJB.checkOnResponse()");
        boolean status = false;
        try {
            QueueSession session = this.connection.createQueueSession(true, 0);
            status = this.recvMessageInternal(session, prop);
            TestUtil.logTrace((String)"Close the session");
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception in checkOnResponse", (Throwable)e);
        }
        return status;
    }

    public void sendTextMessageToQ(String prop) {
        try {
            String msg = "Test with a text message";
            TestUtil.logTrace((String)"MDB_AR_TestEJB.sendTextMessageToQ()");
            QueueSession session = this.connection.createQueueSession(true, 0);
            TestUtil.logTrace((String)("calling send method with: " + msg + " + " + prop));
            QueueSender sender = session.createSender(this.queue);
            TestUtil.logTrace((String)("got a q sender for: " + sender.getQueue().getQueueName()));
            TextMessage message = session.createTextMessage();
            JmsUtil.addPropsToMessage((Message)message, this.p);
            message.setText(msg);
            message.setStringProperty("Verify", prop);
            TestUtil.logTrace((String)("gonna send msg with this property to the mdb: " + message.getStringProperty("Verify")));
            sender.send((Message)message);
            TestUtil.logTrace((String)"Close the session");
            session.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void sendBytesMessageToQ(String prop) {
        byte bValue = 9;
        try {
            TestUtil.logTrace((String)"MDB_AR_TestEJB.sendBytesMessageToQ()");
            QueueSession session = this.connection.createQueueSession(true, 0);
            TestUtil.logTrace((String)("calling send method with: " + prop));
            QueueSender sender = session.createSender(this.queue);
            TestUtil.logTrace((String)("got a q sender for: " + sender.getQueue().getQueueName()));
            BytesMessage message = session.createBytesMessage();
            JmsUtil.addPropsToMessage((Message)message, this.p);
            message.writeByte(bValue);
            message.setStringProperty("Verify", prop);
            TestUtil.logTrace((String)("gonna send msg with this property to the mdb: " + message.getStringProperty("Verify")));
            sender.send((Message)message);
            TestUtil.logTrace((String)"Close the session");
            session.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void sendStreamMessageToQ(String prop) {
        try {
            TestUtil.logTrace((String)"MDB_AR_TestEJB.sendStreamMessageToQ()");
            QueueSession session = this.connection.createQueueSession(true, 0);
            TestUtil.logTrace((String)("calling send method with: " + prop));
            QueueSender sender = session.createSender(this.queue);
            TestUtil.logTrace((String)("got a q sender for: " + sender.getQueue().getQueueName()));
            StreamMessage message = session.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)message, this.p);
            message.writeString("Testing with a Stream message...");
            message.setStringProperty("Verify", prop);
            TestUtil.logTrace((String)("gonna send msg with this property to the mdb: " + message.getStringProperty("Verify")));
            sender.send((Message)message);
            TestUtil.logTrace((String)"Close the session");
            session.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void sendMapMessageToQ(String prop) {
        try {
            TestUtil.logTrace((String)"MDB_AR_TestEJB.sendMapMessageToQ()");
            QueueSession session = this.connection.createQueueSession(true, 0);
            TestUtil.logTrace((String)("calling send method with: " + prop));
            QueueSender sender = session.createSender(this.queue);
            TestUtil.logTrace((String)("got a q sender for: " + sender.getQueue().getQueueName()));
            MapMessage message = session.createMapMessage();
            JmsUtil.addPropsToMessage((Message)message, this.p);
            message.setString("aString", "Testing async receives");
            message.setStringProperty("Verify", prop);
            TestUtil.logTrace((String)("gonna send msg with this property to the mdb: " + message.getStringProperty("Verify")));
            sender.send((Message)message);
            TestUtil.logTrace((String)"Close the session");
            session.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void sendObjectMessageToQ(String prop) {
        try {
            TestUtil.logTrace((String)"MDB_AR_TestEJB.sendObjectMessageToQ()");
            QueueSession session = this.connection.createQueueSession(true, 0);
            TestUtil.logTrace((String)("calling send method with: " + prop));
            QueueSender sender = session.createSender(this.queue);
            TestUtil.logTrace((String)("got a q sender for: " + sender.getQueue().getQueueName()));
            ObjectMessage message = session.createObjectMessage();
            JmsUtil.addPropsToMessage((Message)message, this.p);
            message.setObject((Serializable)((Object)"Object Message !!!!"));
            message.setStringProperty("Verify", prop);
            TestUtil.logTrace((String)("gonna send msg with this property to the mdb: " + message.getStringProperty("Verify")));
            sender.send((Message)message);
            TestUtil.logTrace((String)"Close the session");
            session.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void sendTextMessageToTopic(String prop) {
        try {
            String msg = "Testing  a Text message";
            TestUtil.logTrace((String)"MDB_AR_TestEJB.sendTextMessageToTopic()");
            TopicSession session = this.tConn.createTopicSession(true, 0);
            TestUtil.logTrace((String)("calling send method with: " + prop));
            TopicPublisher publisher = session.createPublisher(this.topic);
            TestUtil.logTrace((String)("got a topic publisher for: " + publisher.getTopic().getTopicName()));
            TextMessage message = session.createTextMessage();
            JmsUtil.addPropsToMessage((Message)message, this.p);
            message.setText(msg);
            message.setStringProperty("Verify", prop);
            TestUtil.logTrace((String)("gonna send msg with this property to the mdb: " + message.getStringProperty("Verify")));
            publisher.publish((Message)message);
            TestUtil.logTrace((String)"Close the session");
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception in sendTextMessageToTopic", (Throwable)e);
        }
    }

    public void sendMapMessageToTopic(String prop) {
        try {
            String msg = "Testing  a Map message";
            TestUtil.logTrace((String)"MDB_AR_TestEJB.sendMapMessageToTopic()");
            TopicSession session = this.tConn.createTopicSession(true, 0);
            TestUtil.logTrace((String)("calling send method with: " + prop));
            TopicPublisher publisher = session.createPublisher(this.topic);
            TestUtil.logTrace((String)("got a topic publisher for: " + publisher.getTopic().getTopicName()));
            MapMessage message = session.createMapMessage();
            JmsUtil.addPropsToMessage((Message)message, this.p);
            message.setString("aString", "Testing async receives");
            message.setStringProperty("Verify", prop);
            TestUtil.logTrace((String)("gonna send msg with this property to the mdb: " + message.getStringProperty("Verify")));
            publisher.publish((Message)message);
            TestUtil.logTrace((String)"Close the session");
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception in sendMapMessageToTopic", (Throwable)e);
        }
    }

    public void sendObjectMessageToTopic(String prop) {
        try {
            String msg = "Testing  a Object message";
            TestUtil.logTrace((String)"MDB_AR_TestEJB.sendObjectMessageToTopic()");
            TopicSession session = this.tConn.createTopicSession(true, 0);
            TestUtil.logTrace((String)("calling send method with: " + prop));
            TopicPublisher publisher = session.createPublisher(this.topic);
            TestUtil.logTrace((String)("got a topic publisher for: " + publisher.getTopic().getTopicName()));
            ObjectMessage message = session.createObjectMessage();
            JmsUtil.addPropsToMessage((Message)message, this.p);
            message.setObject((Serializable)((Object)"Object Message !!!!"));
            message.setStringProperty("Verify", prop);
            TestUtil.logTrace((String)("gonna send msg with this property to the mdb: " + message.getStringProperty("Verify")));
            publisher.publish((Message)message);
            TestUtil.logTrace((String)"Close the session");
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception in sendObjectMessageToTopic", (Throwable)e);
        }
    }

    public void sendBytesMessageToTopic(String prop) {
        byte bValue = 11;
        try {
            String msg = "Testing  a Bytes message";
            TestUtil.logTrace((String)"MDB_AR_TestEJB.sendBytesMessageToTopic()");
            TopicSession session = this.tConn.createTopicSession(true, 0);
            TestUtil.logTrace((String)("calling send method with: " + prop));
            TopicPublisher publisher = session.createPublisher(this.topic);
            TestUtil.logTrace((String)("got a topic publisher for: " + publisher.getTopic().getTopicName()));
            BytesMessage message = session.createBytesMessage();
            JmsUtil.addPropsToMessage((Message)message, this.p);
            message.writeByte(bValue);
            message.setStringProperty("Verify", prop);
            TestUtil.logTrace((String)("gonna send msg with this property to the mdb: " + message.getStringProperty("Verify")));
            publisher.publish((Message)message);
            TestUtil.logTrace((String)"Close the session");
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception in sendBytesMessageToTopic", (Throwable)e);
        }
    }

    public void sendStreamMessageToTopic(String prop) {
        int bValue = 11;
        try {
            String msg = "Testing  a Stream message";
            TestUtil.logTrace((String)"MDB_AR_TestEJB.sendStreamMessageToTopic()");
            TopicSession session = this.tConn.createTopicSession(true, 0);
            TestUtil.logTrace((String)("calling send method with: " + prop));
            TopicPublisher publisher = session.createPublisher(this.topic);
            TestUtil.logTrace((String)("got a topic publisher for: " + publisher.getTopic().getTopicName()));
            StreamMessage message = session.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)message, this.p);
            message.writeString("Testing with a Stream message...");
            message.setStringProperty("Verify", prop);
            TestUtil.logTrace((String)("gonna send msg with this property to the mdb: " + message.getStringProperty("Verify")));
            publisher.publish((Message)message);
            TestUtil.logTrace((String)"Close the session");
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception in sendStreamMessageToTopic", (Throwable)e);
        }
    }

    private boolean recvMessageInternal(QueueSession session, String prop) throws JMSException {
        boolean retcode = false;
        TestUtil.logTrace((String)"MDB_AR_TestEJB.recvMessageInternal()");
        QueueReceiver rcvr = session.createReceiver(this.rcvrQueue);
        Message msgRec = null;
        for (int i = 0; i < 10; ++i) {
            TestUtil.logTrace((String)("@recvMessageInternal trying to receive the message: " + i));
            msgRec = rcvr.receive(this.timeout);
            if (msgRec != null) break;
        }
        if (msgRec != null) {
            TestUtil.logTrace((String)("Success: received Msg from Q!  " + msgRec.getStringProperty("Verify")));
            if (msgRec.getStringProperty("Verify").equals(prop)) {
                TestUtil.logTrace((String)"Pass: we got the expected msg back! ");
                retcode = true;
            } else {
                TestUtil.logTrace((String)"Fail: we didnt get the expected msg back! ");
            }
        } else {
            TestUtil.logTrace((String)"Fail: we didnt get any msg back! ");
        }
        return retcode;
    }

    public void cleanup() {
        TestUtil.logTrace((String)"In EJB cleanup");
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            if (this.tConn != null) {
                this.tConn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception in cleanup", (Throwable)e);
        }
    }

    @PostActivate
    public void activate() {
        TestUtil.logTrace((String)"MDB_AR_TestEJB.activate()");
        try {
            TSNamingContext context = new TSNamingContext();
            TestUtil.logTrace((String)"Got TSNamingContext");
            this.qcFactory = (QueueConnectionFactory)context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            this.rcvrQueue = (Queue)context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.queue = (Queue)context.lookup("java:comp/env/jms/MDB_QUEUE");
            this.tcFactory = (TopicConnectionFactory)context.lookup("java:comp/env/jms/MyTopicConnectionFactory");
            this.topic = (Topic)context.lookup("java:comp/env/jms/MDB_TOPIC");
            this.tConn = this.tcFactory.createTopicConnection(this.jmsUser, this.jmsPassword);
            this.connection = this.qcFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            this.connection.start();
            this.tConn.start();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error looking up Queue, Topic, ConnectionFactory objects, Starting connections", (Throwable)e);
            throw new EJBException("@activate: Error!", e);
        }
    }

    @PrePassivate
    public void passivate() {
        TestUtil.logTrace((String)"MDB_AR_TestEJB.passivate()");
        this.queue = null;
        this.rcvrQueue = null;
        this.qcFactory = null;
        this.topic = null;
        this.tcFactory = null;
        this.cleanup();
    }

    @Remove
    public void remove() {
        TestUtil.logTrace((String)"MDB_AR_TestEJB.remove()");
    }
}

