/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.deploy.entity.bmp.pkey;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOException;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.common.dao.coffee.variants.StringPKCoffeeDAO;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.FinderException;
import jakarta.ejb.NoSuchEntityException;
import jakarta.ejb.RemoveException;
import java.util.Properties;
import javax.naming.NamingException;

public class StringBeanEJB
implements EntityBean {
    private float cofPrice;
    protected TSNamingContext nctx = null;
    protected EntityContext ectx = null;
    private StringPKCoffeeDAO dao = null;

    public void ping() {
        TestUtil.logTrace((String)"[StringBean] ping()");
    }

    public String ejbCreate(Properties props, String cofID, String cofName, float cofPrice) throws CreateException {
        try {
            TestUtil.logTrace((String)"[StringBean] ejbCreate()");
            TestUtil.logMsg((String)"[StringBean] Initialize remote logging");
            TestUtil.init((Properties)props);
            TestUtil.logMsg((String)"[StringBean] DBSupport Init");
            if (null == this.dao) {
                this.dao = DAOFactory.getInstance().getStringPKCoffeeDAO();
            }
            TestUtil.logTrace((String)"[StringBean] Get DB connection...");
            this.dao.startSession();
            TestUtil.logTrace((String)"[StringBean] Create new row...");
            this.dao.create(cofID, cofName, cofPrice);
            this.cofPrice = cofPrice;
        }
        catch (DAOException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("[ejbCreate] DAO Exception: " + e.getCause());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("[ejbCreate] Exception caught: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
        return new String(cofID);
    }

    public void ejbPostCreate(Properties props, String cofID, String cofName, float cofPrice) {
        TestUtil.logTrace((String)"[StringBean] ejbPostCreate()");
    }

    public void setEntityContext(EntityContext c) throws EJBException {
        TestUtil.logTrace((String)"[StringBean] setEntityContext()");
        this.ectx = c;
        try {
            TestUtil.logMsg((String)"[StringBean] Obtaining TS Naming Context...");
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.logErr((String)("[StringBean] Naming Exception : " + e), (Throwable)e);
            throw new EJBException("Cannot obtain Naming Context" + e);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[StringBean] Caught exception: " + e), (Throwable)e);
            throw new EJBException("Caught exception: " + e);
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"[StringBean] unsetEntityContext()");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"[StringBean] ejbRemove()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[StringBean] Initialize DBSupport...");
                this.dao = DAOFactory.getInstance().getStringPKCoffeeDAO();
            }
            TestUtil.logTrace((String)"[StringBean] Get DB connection...");
            this.dao.startSession();
            TestUtil.logTrace((String)"[StringBean] Remove row...");
            this.dao.delete((String)this.ectx.getPrimaryKey());
        }
        catch (DAOException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RemoveException("[StringBean] Caught DAOException" + e.getCause());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RemoveException("[StringBean] Caught exception: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"[StringBean] ejbActivate()");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"[StringBean] ejbPassivate()");
    }

    public void ejbLoad() throws EJBException {
        TestUtil.logTrace((String)"[StringBean] ejbLoad()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[StringBean] Initialize DBSupport()");
                this.dao = DAOFactory.getInstance().getStringPKCoffeeDAO();
            }
            TestUtil.logTrace((String)"[StringBean] Get DB connection...");
            this.dao.startSession();
            TestUtil.logTrace((String)"[StringBean] Load row...");
            this.cofPrice = this.dao.loadPrice((String)this.ectx.getPrimaryKey());
        }
        catch (DAOException e) {
            TestUtil.logErr((String)"[StringBean] No such entity exists: ", (Throwable)e);
            throw new NoSuchEntityException("[ejbLoad] DAOException" + e.getCause());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("[ejbLoad] Unable to init DBSupport" + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbStore() throws EJBException {
        TestUtil.logTrace((String)"[StringBean] ejbStore()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[StringBean] Initializing DBSupport...");
                this.dao = DAOFactory.getInstance().getStringPKCoffeeDAO();
            }
            TestUtil.logTrace((String)"[StringBean] Get DB connection...");
            this.dao.startSession();
            TestUtil.logTrace((String)"[StringBean] Store row...");
            this.dao.storePrice((String)this.ectx.getPrimaryKey(), this.cofPrice);
        }
        catch (DAOException e) {
            TestUtil.logErr((String)"[StringBean] No such entity", (Throwable)e.getCause());
            throw new NoSuchEntityException("[ejbStore] DAOException" + e.getCause());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("[ejbStore] Unable to init DBSupport");
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
            this.dao = null;
        }
    }

    public String ejbFindByPrimaryKey(String key) throws FinderException {
        TestUtil.logTrace((String)"[StringBean] ejbFindByPrimaryKey()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[StringBean] Initializing DBSupport...");
                this.dao = DAOFactory.getInstance().getStringPKCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                String string = key;
                return string;
            }
            try {
                throw new FinderException("[StringBean] Key not found: " + key);
            }
            catch (DAOException e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("DAOException " + e.getCause());
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }
}

