/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonwriterfactorytests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void jsonWriterFactoryTest1() throws EETest.Fault {
        boolean pass = true;
        JsonWriter writer1 = null;
        JsonWriter writer2 = null;
        String expString = "{}";
        JsonObject jsonObject = Json.createReader((Reader)new StringReader(expString)).readObject();
        try {
            this.logMsg("Create JsonWriterFactory with Map<String, ?> with EMPTY config");
            JsonWriterFactory writerFactory = Json.createWriterFactory(JSONP_Util.getEmptyConfig());
            this.logMsg("Checking factory configuration properties");
            Map config = writerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("--------------------------------------------------");
            this.logMsg("TEST CASE [JsonWriterFactory.createWriter(Writer)]");
            this.logMsg("--------------------------------------------------");
            this.logMsg("Create 1st JsonWriter using JsonWriterFactory");
            StringWriter sWriter1 = new StringWriter();
            writer1 = writerFactory.createWriter((Writer)sWriter1);
            if (writer1 == null) {
                this.logErr("WriterFactory failed to create writer1");
                pass = false;
            } else {
                writer1.writeObject(jsonObject);
                writer1.close();
            }
            this.logMsg("sWriter1=" + ((Object)sWriter1).toString());
            String actString = JSONP_Util.removeWhitespace(((Object)sWriter1).toString());
            if (!JSONP_Util.assertEqualsJsonText(expString, actString)) {
                pass = false;
            }
            this.logMsg("Create 2nd JsonWriter using JsonWriterFactory");
            StringWriter sWriter2 = new StringWriter();
            writer2 = writerFactory.createWriter((Writer)sWriter2);
            if (writer2 == null) {
                this.logErr("WriterFactory failed to create writer2");
                pass = false;
            } else {
                writer2.writeObject(jsonObject);
                writer2.close();
            }
            this.logMsg("sWriter2=" + ((Object)sWriter2).toString());
            actString = JSONP_Util.removeWhitespace(((Object)sWriter2).toString());
            if (!JSONP_Util.assertEqualsJsonText(expString, actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonWriterFactoryTest1 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterFactoryTest1 Failed");
        }
    }

    public void jsonWriterFactoryTest2() throws EETest.Fault {
        boolean pass = true;
        JsonWriter writer1 = null;
        JsonWriter writer2 = null;
        String expString = "{}";
        JsonObject jsonObject = Json.createReader((Reader)new StringReader(expString)).readObject();
        try {
            this.logMsg("Create JsonWriterFactory with Map<String, ?> with EMPTY config");
            JsonWriterFactory writerFactory = Json.createWriterFactory(JSONP_Util.getEmptyConfig());
            this.logMsg("Checking factory configuration properties");
            Map config = writerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("-----------------------------------------------------------------");
            this.logMsg("TEST CASE [JsonWriterFactory.createWriter(OutputStream, Charset)]");
            this.logMsg("-----------------------------------------------------------------");
            this.logMsg("Create 1st JsonWriter using JsonWriterFactory with UTF-8 encoding");
            ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
            writer1 = writerFactory.createWriter((OutputStream)baos1, JSONP_Util.UTF_8);
            if (writer1 == null) {
                this.logErr("WriterFactory failed to create writer1");
                pass = false;
            } else {
                writer1.writeObject(jsonObject);
                writer1.close();
            }
            this.logMsg("baos1=" + baos1.toString("UTF-8"));
            String actString = JSONP_Util.removeWhitespace(baos1.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText(expString, actString)) {
                pass = false;
            }
            this.logMsg("Create 2nd JsonWriter using JsonWriterFactory with UTF-8 encoding");
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            writer2 = writerFactory.createWriter((OutputStream)baos2, JSONP_Util.UTF_8);
            if (writer2 == null) {
                this.logErr("WriterFactory failed to create writer2");
                pass = false;
            } else {
                writer2.writeObject(jsonObject);
                writer2.close();
            }
            this.logMsg("baos2=" + baos2.toString("UTF-8"));
            actString = JSONP_Util.removeWhitespace(baos2.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText(expString, actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonWriterFactoryTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterFactoryTest2 Failed");
        }
    }

    public void jsonWriterFactoryTest3() throws EETest.Fault {
        boolean pass = true;
        JsonWriter writer1 = null;
        JsonWriter writer2 = null;
        String expString = "{}";
        JsonObject jsonObject = Json.createReader((Reader)new StringReader(expString)).readObject();
        try {
            this.logMsg("Create JsonWriterFactory with Map<String, ?> with EMPTY config");
            JsonWriterFactory writerFactory = Json.createWriterFactory(JSONP_Util.getEmptyConfig());
            this.logMsg("Checking factory configuration properties");
            Map config = writerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("--------------------------------------------------------");
            this.logMsg("TEST CASE [JsonWriterFactory.createWriter(OutputStream)]");
            this.logMsg("--------------------------------------------------------");
            this.logMsg("Create 1st JsonWriter using JsonWriterFactory");
            ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
            writer1 = writerFactory.createWriter((OutputStream)baos1);
            if (writer1 == null) {
                this.logErr("WriterFactory failed to create writer1");
                pass = false;
            } else {
                writer1.writeObject(jsonObject);
                writer1.close();
            }
            this.logMsg("baos1=" + baos1.toString("UTF-8"));
            String actString = JSONP_Util.removeWhitespace(baos1.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText(expString, actString)) {
                pass = false;
            }
            this.logMsg("Create 2nd JsonWriter using JsonWriterFactory");
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            writer2 = writerFactory.createWriter((OutputStream)baos2);
            if (writer2 == null) {
                this.logErr("WriterFactory failed to create writer2");
                pass = false;
            } else {
                writer2.writeObject(jsonObject);
                writer2.close();
            }
            this.logMsg("baos2=" + baos2.toString("UTF-8"));
            actString = JSONP_Util.removeWhitespace(baos2.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText(expString, actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonWriterFactoryTest3 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterFactoryTest3 Failed");
        }
    }

    public void jsonWriterFactoryTest4() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("----------------------------------------------");
            this.logMsg("Test scenario1: no supported provider property");
            this.logMsg("----------------------------------------------");
            this.logMsg("Create JsonWriterFactory with Map<String, ?> with EMPTY config");
            JsonWriterFactory writerFactory = Json.createWriterFactory(JSONP_Util.getEmptyConfig());
            Map config = writerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("-------------------------------------------");
            this.logMsg("Test scenario2: supported provider property");
            this.logMsg("-------------------------------------------");
            this.logMsg("Create JsonWriterFactory with Map<String, ?> with FOO config");
            writerFactory = Json.createWriterFactory(JSONP_Util.getFooConfig());
            config = writerFactory.getConfigInUse();
            String[] props = new String[]{"jakarta.json.stream.JsonGenerator.prettyPrinting"};
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("-------------------------------------------------------------");
            this.logMsg("Test scenario3: supported and non supported provider property");
            this.logMsg("-------------------------------------------------------------");
            this.logMsg("Create JsonGeneratorFactory with Map<String, ?> with all config");
            writerFactory = Json.createWriterFactory(JSONP_Util.getAllConfig());
            config = writerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 1, props)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonWriterFactoryTest4 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterFactoryTest4 Failed");
        }
    }
}

