/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.exceptiontests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import com.sun.ts.tests.jsonp.common.MyJsonLocation;
import jakarta.json.JsonException;
import jakarta.json.stream.JsonGenerationException;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParsingException;
import java.util.Properties;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void jsonExceptionConstructorTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            String message = "This JSON is incorrect.";
            this.logMsg("Test JsonException(String)");
            JsonException exception = new JsonException(message);
            try {
                throw exception;
            }
            catch (JsonException e) {
                if (!e.getMessage().equals(message)) {
                    this.logErr("Incorrect message: expected " + message + ", received " + e.getMessage());
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonExceptionConstructorTest1 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonExceptionConstructorTest1 Failed:");
        }
    }

    public void jsonExceptionConstructorTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            String message = "This JSON is incorrect due to foo.";
            Exception foo = new Exception("This is a foo exception");
            this.logMsg("Test JsonException(String, Throwable)");
            JsonException exception = new JsonException(message, (Throwable)foo);
            try {
                throw exception;
            }
            catch (JsonException e) {
                if (!e.getCause().equals(foo)) {
                    this.logErr("Incorrect cause: expected " + foo + ", received " + e.getCause());
                    pass = false;
                }
                if (!e.getMessage().equals(message)) {
                    this.logErr("Incorrect message: expected " + message + ", received " + e.getMessage());
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonExceptionConstructorTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonExceptionConstructorTest2 Failed:");
        }
    }

    public void jsonParsingExceptionConstructorTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            String message = "This JSON is incorrect.";
            MyJsonLocation expLoc = new MyJsonLocation(10L, 20L, 30L);
            this.logMsg("MyJsonLocation");
            JSONP_Util.dumpLocation(expLoc);
            this.logMsg("Test JsonParsingException(String, JsonLocation)");
            JsonParsingException exception = new JsonParsingException(message, (JsonLocation)expLoc);
            try {
                throw exception;
            }
            catch (JsonParsingException e) {
                if (!e.getMessage().equals(message)) {
                    this.logErr("Incorrect message: expected " + message + ", received " + e.getMessage());
                    pass = false;
                }
                JsonLocation actLoc = exception.getLocation();
                this.logMsg("JsonParsingException.getLocation()");
                JSONP_Util.dumpLocation(actLoc);
                if (!JSONP_Util.assertEquals(expLoc, actLoc)) {
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParsingExceptionConstructorTest1 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonParsingExceptionConstructorTest1 Failed:");
        }
    }

    public void jsonParsingExceptionConstructorTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            String message = "This JSON is incorrect due to foo.";
            Exception foo = new Exception("This is a foo exception");
            MyJsonLocation expLoc = new MyJsonLocation(10L, 20L, 30L);
            this.logMsg("MyJsonLocation");
            JSONP_Util.dumpLocation(expLoc);
            this.logMsg("Test JsonParsingException(String, Throwable)");
            JsonParsingException exception = new JsonParsingException(message, (Throwable)foo, (JsonLocation)expLoc);
            try {
                throw exception;
            }
            catch (JsonParsingException e) {
                if (!e.getCause().equals(foo)) {
                    this.logErr("Incorrect cause: expected " + foo + ", received " + e.getCause());
                    pass = false;
                }
                if (!e.getMessage().equals(message)) {
                    this.logErr("Incorrect message: expected " + message + ", received " + e.getMessage());
                    pass = false;
                }
                JsonLocation actLoc = exception.getLocation();
                this.logMsg("JsonParsingException.getLocation()");
                JSONP_Util.dumpLocation(actLoc);
                if (!JSONP_Util.assertEquals(expLoc, actLoc)) {
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParsingExceptionConstructorTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonParsingExceptionConstructorTest2 Failed:");
        }
    }

    public void jsonGenerationExceptionConstructorTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            String message = "This JSON is incorrect.";
            this.logMsg("Test JsonGenerationException(String)");
            JsonGenerationException exception = new JsonGenerationException(message);
            try {
                throw exception;
            }
            catch (JsonGenerationException e) {
                if (!e.getMessage().equals(message)) {
                    this.logErr("Incorrect message: expected " + message + ", received " + e.getMessage());
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGenerationExceptionConstructorTest1 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGenerationExceptionConstructorTest1 Failed:");
        }
    }

    public void jsonGenerationExceptionConstructorTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            String message = "This JSON is incorrect due to foo.";
            Exception foo = new Exception("This is a foo exception");
            this.logMsg("Test JsonGenerationException(String, Throwable)");
            JsonGenerationException exception = new JsonGenerationException(message, (Throwable)foo);
            try {
                throw exception;
            }
            catch (JsonGenerationException e) {
                if (!e.getCause().equals(foo)) {
                    this.logErr("Incorrect cause: expected " + foo + ", received " + e.getCause());
                    pass = false;
                }
                if (!e.getMessage().equals(message)) {
                    this.logErr("Incorrect message: expected " + message + ", received " + e.getMessage());
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGenerationExceptionConstructorTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGenerationExceptionConstructorTest2 Failed:");
        }
    }
}

