/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.pluggability.jsonbprovidertests;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.common.base.ServiceEETest;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.spi.JsonbProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;

public class Client
extends ServiceEETest {
    static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final String MY_JSONBROVIDER_CLASS = "com.sun.ts.tests.jsonb.provider.MyJsonbProvider";
    private static final String MY_JSONBBUILDER_CLASS = "com.sun.ts.tests.jsonb.provider.MyJsonbBuilder";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
    }

    public void cleanup() {
    }

    public void jsonbProviderTest1() throws Exception {
        try {
            JsonbProvider provider = JsonbProvider.provider();
            String providerClass = provider.getClass().getName();
            logger.log(System.Logger.Level.INFO, "provider class=" + providerClass);
        }
        catch (Exception e) {
            throw new Exception("jsonbProviderTest1 Failed: ", e);
        }
    }

    public void jsonbProviderTest2() throws Exception {
        boolean pass = true;
        try {
            JsonbProvider provider = JsonbProvider.provider((String)MY_JSONBROVIDER_CLASS);
            String providerClass = provider.getClass().getName();
            logger.log(System.Logger.Level.INFO, "provider class=" + providerClass);
            if (providerClass.equals(MY_JSONBROVIDER_CLASS)) {
                logger.log(System.Logger.Level.INFO, "Current provider is my provider - expected.");
            } else {
                logger.log(System.Logger.Level.ERROR, "Current provider is not my provider - unexpected.");
                pass = false;
                ServiceLoader<JsonbProvider> loader = ServiceLoader.load(JsonbProvider.class);
                Iterator<JsonbProvider> it = loader.iterator();
                ArrayList<JsonbProvider> providers = new ArrayList<JsonbProvider>();
                while (it.hasNext()) {
                    providers.add(it.next());
                }
                logger.log(System.Logger.Level.INFO, "Providers: " + String.valueOf(providers));
            }
        }
        catch (Exception e) {
            throw new Exception("jsonbProviderTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonbProviderTest2 Failed");
        }
    }

    public void jsonbProviderTest3() throws Exception {
        try {
            JsonbBuilder builder = JsonbProvider.provider((String)MY_JSONBROVIDER_CLASS).create();
            String providerClass = builder.getClass().getName();
            logger.log(System.Logger.Level.INFO, "jsonb builder class=" + providerClass);
            if (!providerClass.equals(MY_JSONBBUILDER_CLASS)) {
                logger.log(System.Logger.Level.ERROR, "Current jsonb builder is not my builder - unexpected.");
                throw new Exception("jsonbProviderTest3 Failed");
            }
            logger.log(System.Logger.Level.INFO, "Current jsonb builder is my builder - expected.");
        }
        catch (Exception e) {
            throw new Exception("jsonbProviderTest3 Failed: ", e);
        }
    }
}

