/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.tx.session.stateless.cm.generics;

import com.sun.ts.tests.ejb30.common.generics.GenericGreetingIF;
import com.sun.ts.tests.ejb30.common.generics.LocalIntGreetingIF;
import com.sun.ts.tests.ejb30.common.generics.LocalParameterizedIF;
import com.sun.ts.tests.ejb30.common.generics.RemoteIntGreetingIF;
import com.sun.ts.tests.ejb30.common.generics.RemoteParameterizedIF;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.servlet.common.servlets.HttpTCKServlet;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBException;
import jakarta.ejb.EJBTransactionRequiredException;
import jakarta.ejb.TransactionRequiredLocalException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class TestServlet
extends HttpTCKServlet {
    @EJB(name="remoteIntGreetingBean")
    private RemoteIntGreetingIF remoteIntGreetingBean;
    @EJB(name="localIntGreetingBean")
    private LocalIntGreetingIF localIntGreetingBean;
    @EJB(name="localDateGreetingBean", beanName="DateGreetingBean")
    private GenericGreetingIF<Date> localDateGreetingBean;
    @EJB
    private LocalParameterizedIF localParameterizedBean;
    @EJB
    private RemoteParameterizedIF remoteParameterizedBean;

    public void genericsTxMandatoryRemote(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass1 = false;
        boolean pass2 = false;
        StringBuilder reason = new StringBuilder();
        try {
            Helper.getLogger().info("TestServlet about to invoke remoteIntGreetingBean.greeting(0)");
            this.remoteIntGreetingBean.greet(0);
            reason.append("Failed to get expected EJBTransactionRequiredException when invoking ");
            reason.append(this.remoteIntGreetingBean).append(" greeting() method");
        }
        catch (EJBTransactionRequiredException e) {
            Helper.getLogger().info("TestServlet got expected " + String.valueOf((Object)e));
            pass1 = true;
            reason.append(" Got expected EJBTransactionRequiredException when invoking ");
            reason.append(this.remoteIntGreetingBean).append(" greeting() method");
        }
        try {
            Helper.getLogger().info("TestServlet about to invoke remoteIntGreetingBean.reverse(1)");
            this.remoteIntGreetingBean.negate(1);
            reason.append("Failed to get expected EJBTransactionRequiredException when invoking ");
            reason.append(this.remoteIntGreetingBean).append(" negate() method");
        }
        catch (EJBTransactionRequiredException e) {
            Helper.getLogger().info("TestServlet got expected " + String.valueOf((Object)e));
            pass2 = true;
            reason.append(" Got expected EJBTransactionRequiredException when invoking ");
            reason.append(this.remoteIntGreetingBean).append(" reverse() method");
        }
        pw.println(pass1 && pass2 ? "Test PASSED" : "Test FAILED");
        pw.println(reason.toString());
    }

    public void rolesAllowedRemoteIntGreet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass = false;
        StringBuilder reason = new StringBuilder();
        try {
            Helper.getLogger().info("TestServlet about to invoke remoteIntGreetingBean.rolesAllowed(0)");
            int result = this.remoteIntGreetingBean.rolesAllowed(0);
            reason.append("Failed to get expected EJBException when invoking ");
            reason.append(this.remoteIntGreetingBean).append(" rolesAllowed() method.  Actually Got " + result);
        }
        catch (EJBException e) {
            Helper.getLogger().info("TestServlet got expected " + String.valueOf((Object)e));
            pass = true;
            reason.append(" Got expected EJBException when invoking ");
            reason.append(this.remoteIntGreetingBean).append(" rolesAllowed() method");
        }
        pw.println(pass ? "Test PASSED" : "Test FAILED");
        pw.println(reason.toString());
    }

    public void rolesAllowedLocalIntGreet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass = false;
        StringBuilder reason = new StringBuilder();
        try {
            Helper.getLogger().info("TestServlet about to invoke localIntGreetingBean.rolesAllowed(0)");
            int result = this.localIntGreetingBean.rolesAllowed(0);
            reason.append("Failed to get expected EJBException when invoking ");
            reason.append(this.localIntGreetingBean).append(" rolesAllowed() method.  Actually Got " + result);
        }
        catch (EJBException e) {
            Helper.getLogger().info("TestServlet got expected " + String.valueOf((Object)e));
            pass = true;
            reason.append(" Got expected EJBException when invoking ");
            reason.append(this.localIntGreetingBean).append(" rolesAllowed() method");
        }
        pw.println(pass ? "Test PASSED" : "Test FAILED");
        pw.println(reason.toString());
    }

    public void rolesAllowedNoArgRemoteIntGreet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass = false;
        StringBuilder reason = new StringBuilder();
        try {
            Helper.getLogger().info("TestServlet about to invoke remoteIntGreetingBean.rolesAllowedNoArg()");
            int result = (Integer)this.remoteIntGreetingBean.rolesAllowedNoArg();
            reason.append("Failed to get expected EJBException when invoking ");
            reason.append(this.remoteIntGreetingBean).append(" rolesAllowedNoArg() method.  Actually Got " + result);
        }
        catch (EJBException e) {
            Helper.getLogger().info("TestServlet got expected " + String.valueOf((Object)e));
            pass = true;
            reason.append(" Got expected EJBException when invoking ");
            reason.append(this.remoteIntGreetingBean).append(" rolesAllowedNoArg() method");
        }
        pw.println(pass ? "Test PASSED" : "Test FAILED");
        pw.println(reason.toString());
    }

    public void rolesAllowedNoArgLocalIntGreet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass = false;
        StringBuilder reason = new StringBuilder();
        try {
            Helper.getLogger().info("TestServlet about to invoke localIntGreetingBean.rolesAllowedNoArg()");
            int result = (Integer)this.localIntGreetingBean.rolesAllowedNoArg();
            reason.append("Failed to get expected EJBException when invoking ");
            reason.append(this.localIntGreetingBean).append(" rolesAllowedNoArg() method.  Actually Got " + result);
        }
        catch (EJBException e) {
            Helper.getLogger().info("TestServlet got expected " + String.valueOf((Object)e));
            pass = true;
            reason.append(" Got expected EJBException when invoking ");
            reason.append(this.localIntGreetingBean).append(" rolesAllowedNoArg() method");
        }
        pw.println(pass ? "Test PASSED" : "Test FAILED");
        pw.println(reason.toString());
    }

    public void genericsTxMandatoryLocal(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass1 = false;
        boolean pass2 = false;
        StringBuilder reason = new StringBuilder();
        try {
            Helper.getLogger().info("TestServlet about to invoke localIntGreetingBean.greeting(0)");
            this.localIntGreetingBean.greet(0);
            reason.append("Failed to get expected EJBTransactionRequiredException when invoking .");
            reason.append(this.localIntGreetingBean).append(" greeting() method");
        }
        catch (EJBTransactionRequiredException e) {
            Helper.getLogger().info("TestServlet got expected " + String.valueOf((Object)e));
            pass1 = true;
            reason.append(" Got expected EJBTransactionRequiredException when invoking .");
            reason.append(this.localIntGreetingBean).append(" greeting() method");
        }
        catch (TransactionRequiredLocalException e) {
            Helper.getLogger().info("TestServlet got unexpected " + String.valueOf((Object)e));
            reason.append(" Got unexpected exception: ");
            reason.append(e.toString());
        }
        try {
            Helper.getLogger().info("TestServlet about to invoke localIntGreetingBean.reverse(1)");
            this.localIntGreetingBean.negate(1);
            reason.append("Failed to get expected EJBTransactionRequiredException when invoking .");
            reason.append(this.localIntGreetingBean).append(" negate() method");
        }
        catch (EJBTransactionRequiredException e) {
            Helper.getLogger().info("TestServlet got expected " + String.valueOf((Object)e));
            pass2 = true;
            reason.append(" Got expected EJBTransactionRequiredException when invoking .");
            reason.append(this.localIntGreetingBean).append(" reverse() method");
        }
        catch (TransactionRequiredLocalException e) {
            Helper.getLogger().info("TestServlet got unexpected " + String.valueOf((Object)e));
            reason.append(" Got unexpected exception: ");
            reason.append(e.toString());
        }
        pw.println(pass1 && pass2 ? "Test PASSED" : "Test FAILED");
        pw.println(reason.toString());
    }

    public void genericLocalBusinessInterfaceTxMandatory(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass1 = false;
        StringBuilder reason = new StringBuilder();
        try {
            Date date = new Date();
            Helper.getLogger().info("TestServlet about to invoke localDateGreetingBean.greeting(date): " + date.toString());
            Date greeting = this.localDateGreetingBean.greet(date);
            reason.append("Failed to get expected EJBTransactionRequiredException when invoking .");
            reason.append(this.localDateGreetingBean).append(" greeting() method");
            reason.append(" It incorrectly returned ").append(greeting.toString());
        }
        catch (EJBTransactionRequiredException e) {
            Helper.getLogger().info("TestServlet got expected " + String.valueOf((Object)e));
            pass1 = true;
            reason.append(" Got expected EJBTransactionRequiredException when invoking .");
            reason.append(this.localDateGreetingBean).append(" greeting() method");
        }
        catch (TransactionRequiredLocalException e) {
            Helper.getLogger().info("TestServlet got unexpected " + String.valueOf((Object)e));
            reason.append(" Got unexpected exception: ");
            reason.append(e.toString());
        }
        pw.println(pass1 ? "Test PASSED" : "Test FAILED");
        pw.println(reason.toString());
    }

    public void rolesAllowedLocalDateGreeting(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass1 = false;
        StringBuilder reason = new StringBuilder();
        try {
            Date date = new Date();
            Helper.getLogger().info("TestServlet about to invoke localDateGreetingBean.rolesAllowed(date): " + date.toString());
            Date rolesAllowedResult = this.localDateGreetingBean.rolesAllowed(date);
            reason.append("Failed to get expected jakarta.ejb.EJBException when invoking .");
            reason.append(this.localDateGreetingBean).append(" rolesAllowed() method");
            reason.append(" It incorrectly returned ").append(rolesAllowedResult.toString());
        }
        catch (EJBException e) {
            Helper.getLogger().info("TestServlet got expected " + String.valueOf((Object)e));
            pass1 = true;
            reason.append(" Got expected EJBException when invoking .");
            reason.append(this.localDateGreetingBean).append(" rolesAllowedResult() method");
        }
        pw.println(pass1 ? "Test PASSED" : "Test FAILED");
        pw.println(reason.toString());
    }

    public void rolesAllowedNoArgLocalDateGreeting(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass1 = false;
        StringBuilder reason = new StringBuilder();
        try {
            Helper.getLogger().info("TestServlet about to invoke localDateGreetingBean.rolesAllowedNoArg().");
            Date rolesAllowedNoArgResult = this.localDateGreetingBean.rolesAllowedNoArg();
            reason.append("Failed to get expected jakarta.ejb.EJBException when invoking .");
            reason.append(this.localDateGreetingBean).append(" rolesAllowedNoArg() method");
            reason.append(" It incorrectly returned ").append(rolesAllowedNoArgResult.toString());
        }
        catch (EJBException e) {
            Helper.getLogger().info("TestServlet got expected " + String.valueOf((Object)e));
            pass1 = true;
            reason.append(" Got expected EJBException when invoking .");
            reason.append(this.localDateGreetingBean).append(" rolesAllowedNoArgResult() method");
        }
        pw.println(pass1 ? "Test PASSED" : "Test FAILED");
        pw.println(reason.toString());
    }

    public void parameterizedParamLocalTxMandatory(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass1 = false;
        StringBuilder reason = new StringBuilder();
        try {
            List<String> ls = Arrays.asList("parameterizedParamLocalTxMandatory");
            Helper.getLogger().info("TestServlet about to invoke localParameterizedBean.parameterizedParam(List<String>): " + String.valueOf(ls));
            this.localParameterizedBean.parameterizedParam(ls);
            reason.append("Failed to get expected EJBTransactionRequiredException when invoking .");
            reason.append(this.localParameterizedBean).append(" parameterizedParam(List<String>) method");
            reason.append(" It incorrectly returned void.");
        }
        catch (EJBTransactionRequiredException e) {
            Helper.getLogger().info("TestServlet got expected " + String.valueOf((Object)e));
            pass1 = true;
            reason.append(" Got expected EJBTransactionRequiredException when invoking .");
            reason.append(this.localParameterizedBean).append(" parameterizedParam(List<String>) method");
        }
        catch (TransactionRequiredLocalException e) {
            Helper.getLogger().info("TestServlet got unexpected " + String.valueOf((Object)e));
            reason.append(" Got unexpected exception: ");
            reason.append(e.toString());
        }
        pw.println(pass1 ? "Test PASSED" : "Test FAILED");
        pw.println(reason.toString());
    }

    public void parameterizedReturnLocalTxMandatory(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass1 = false;
        StringBuilder reason = new StringBuilder();
        try {
            int i = 2;
            Helper.getLogger().info("TestServlet about to invoke localParameterizedBean.parameterizedReturn(int): " + i);
            List<String> result = this.localParameterizedBean.parameterizedReturn(i);
            reason.append("Failed to get expected EJBTransactionRequiredException when invoking .");
            reason.append(this.localParameterizedBean).append(" parameterizedReturn(i) method");
            reason.append(" It incorrectly returned: " + String.valueOf(result));
        }
        catch (EJBTransactionRequiredException e) {
            Helper.getLogger().info("TestServlet got expected " + String.valueOf((Object)e));
            pass1 = true;
            reason.append(" Got expected EJBTransactionRequiredException when invoking .");
            reason.append(this.localParameterizedBean).append(" parameterizedReturn(int) method");
        }
        catch (TransactionRequiredLocalException e) {
            Helper.getLogger().info("TestServlet got unexpected " + String.valueOf((Object)e));
            reason.append(" Got unexpected exception: ");
            reason.append(e.toString());
        }
        pw.println(pass1 ? "Test PASSED" : "Test FAILED");
        pw.println(reason.toString());
    }

    public void parameterizedParamRemoteTxMandatory(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass1 = false;
        StringBuilder reason = new StringBuilder();
        try {
            List<String> ls = Arrays.asList("parameterizedParamRemoteTxMandatory");
            Helper.getLogger().info("TestServlet about to invoke localParameterizedRemoteBean.parameterizedParam(List<String>): " + String.valueOf(ls));
            this.remoteParameterizedBean.parameterizedParam(ls);
            reason.append("Failed to get expected EJBTransactionRequiredException when invoking .");
            reason.append(this.remoteParameterizedBean).append(" parameterizedParam(List<String>) method");
            reason.append(" It incorrectly returned void.");
        }
        catch (EJBTransactionRequiredException e) {
            Helper.getLogger().info("TestServlet got expected " + String.valueOf((Object)e));
            pass1 = true;
            reason.append(" Got expected EJBTransactionRequiredException when invoking .");
            reason.append(this.remoteParameterizedBean).append(" parameterizedParam(List<String>) method");
        }
        pw.println(pass1 ? "Test PASSED" : "Test FAILED");
        pw.println(reason.toString());
    }

    public void parameterizedReturnRemoteTxMandatory(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass1 = false;
        StringBuilder reason = new StringBuilder();
        try {
            int i = 2;
            Helper.getLogger().info("TestServlet about to invoke localParameterizedRemoteBean.parameterizedReturn(int): " + i);
            List<String> result = this.remoteParameterizedBean.parameterizedReturn(i);
            reason.append("Failed to get expected EJBTransactionRequiredException when invoking .");
            reason.append(this.remoteParameterizedBean).append(" parameterizedReturn(i) method");
            reason.append(" It incorrectly returned: " + String.valueOf(result));
        }
        catch (EJBTransactionRequiredException e) {
            Helper.getLogger().info("TestServlet got expected " + String.valueOf((Object)e));
            pass1 = true;
            reason.append(" Got expected EJBTransactionRequiredException when invoking .");
            reason.append(this.remoteParameterizedBean).append(" parameterizedReturn(int) method");
        }
        pw.println(pass1 ? "Test PASSED" : "Test FAILED");
        pw.println(reason.toString());
    }
}

