/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.interceptor.business.mdb;

import com.sun.ts.tests.ejb30.timer.common.MessageSenderBean;
import jakarta.annotation.Resource;
import jakarta.ejb.ConcurrencyManagement;
import jakarta.ejb.ConcurrencyManagementType;
import jakarta.ejb.Singleton;
import jakarta.interceptor.ExcludeDefaultInterceptors;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;

@Singleton
@ExcludeDefaultInterceptors
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class TestBean {
    @Resource(name="sendQueue")
    private Queue sendQueue;
    @Resource(name="queueConnectionFactory")
    private QueueConnectionFactory queueConnectionFactory;
    private String replyFromMDB;

    public void messageFromSingletonBeanToMDB(String testName) {
        MessageSenderBean.sendMessage(this.queueConnectionFactory, this.sendQueue, testName, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReplyFromMDB() throws InterruptedException {
        TestBean testBean = this;
        synchronized (testBean) {
            while (this.replyFromMDB == null) {
                this.wait();
            }
        }
        return this.replyFromMDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReplyFromMDB(String reply) {
        TestBean testBean = this;
        synchronized (testBean) {
            this.replyFromMDB = reply;
            this.notify();
        }
    }
}

