/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.tx.cm.common;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.CoffeeEJBLite;
import jakarta.persistence.EntityManager;
import jakarta.transaction.UserTransaction;
import java.util.logging.Level;

public class CoffeeUtil {
    private CoffeeUtil() {
    }

    public static void deleteCoffeeInNewUserTransaction(int id, EntityManager em, UserTransaction ut) {
        try {
            ut.begin();
            CoffeeUtil.findDelete(id, false, em);
            ut.commit();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void findDelete(int id, boolean existingDataExpected, EntityManager em) {
        CoffeeEJBLite coffeeFound = (CoffeeEJBLite)em.find(CoffeeEJBLite.class, (Object)id);
        if (coffeeFound != null) {
            Helper.getLogger().logp(Level.FINE, "RWTestBeanBase0", "findDelete", "Current coffee bean already exists in db, need to delete it first: " + String.valueOf(coffeeFound));
            em.remove((Object)coffeeFound);
            em.flush();
        } else {
            if (existingDataExpected) {
                throw new IllegalStateException("Tried to find coffee but got null, id=" + id);
            }
            Helper.getLogger().logp(Level.FINE, "RWTestBeanBase0", "findDelete", "Current coffee bean not in db, no need to delete it. id=" + id);
        }
    }

    public static CoffeeEJBLite findDeletePersist(int id, String brandName, EntityManager em) {
        CoffeeUtil.findDelete(id, false, em);
        CoffeeEJBLite c = new CoffeeEJBLite(id, brandName, id);
        em.persist((Object)c);
        return c;
    }

    public static String verifyCoffee(int id, String brandName, EntityManager em, boolean expectingFound) {
        CoffeeEJBLite coffeeFound = (CoffeeEJBLite)em.find(CoffeeEJBLite.class, (Object)id);
        if (expectingFound) {
            return Helper.assertEquals("verify coffee", brandName, coffeeFound.getBrandName());
        }
        return Helper.assertEquals("verify coffee", null, coffeeFound);
    }
}

