/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.helloejbjar;

import com.sun.ts.tests.ejb30.common.helloejbjar.HelloLocalIF;
import com.sun.ts.tests.ejb30.common.helloejbjar.HelloRemoteIF;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class HelloBeanBase
implements HelloRemoteIF,
HelloLocalIF {
    public static final Logger logger = Logger.getLogger(HelloBeanBase.class.getName());
    private List<String> records = new ArrayList<String>();
    @Resource(lookup="java:app/AppName")
    private String appName;
    @Resource(lookup="java:module/ModuleName")
    private String moduleName;

    @Override
    public void hello() {
    }

    @Override
    public Object getMessage() {
        return this.toString();
    }

    @Override
    public int add(int a, int b) {
        return a + b;
    }

    @Override
    public void addRecord(String rec) {
        if (this.records.contains(rec)) {
            logger.warning("Record already exists in HelloBeanBase: " + rec);
        } else {
            this.records.add(rec);
        }
    }

    @Override
    public List<String> getAndClearRecords() {
        ArrayList<String> r = new ArrayList<String>(this.records);
        this.records.clear();
        return r;
    }

    @PostConstruct
    private void postConstruct() {
        System.out.println(String.format("appName: %s, moduleName: %s", this.appName, this.moduleName));
        String nameExpected = "ejb3_common_helloejbjar_standalone_component_ejb";
        if (!nameExpected.equals(this.appName)) {
            throw new RuntimeException(String.format("Expecting appName %s, but actual %s", nameExpected, this.appName));
        }
        if (!nameExpected.equals(this.moduleName)) {
            throw new RuntimeException(String.format("Expecting moduleName %s, but actual %s", nameExpected, this.moduleName));
        }
    }
}

