/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.assembly.metainfandlibdir;

import com.sun.ts.tests.ejb30.assembly.common.AssemblyCommonIF;
import com.sun.ts.tests.ejb30.assembly.common.AssemblyLocalIF;
import com.sun.ts.tests.ejb30.common.helloejbjar.HelloRemoteIF;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

public class EJBInjectionFilterBase
implements Filter {
    private boolean postConstructCalled;
    @EJB(name="assemblyBeanInFilter", beanInterface=AssemblyLocalIF.class)
    private AssemblyCommonIF assemblyBean;
    @EJB(name="helloBeanInFilter")
    private HelloRemoteIF helloBean;
    private FilterConfig filterConfig = null;

    @PostConstruct
    final void postConstruct() {
        this.postConstructCalled = true;
        if (this.helloBean == null || !(this.helloBean instanceof HelloRemoteIF)) {
            throw new IllegalStateException("helloBean field has not been correctly injected when post-construct method is called." + String.valueOf(this.helloBean));
        }
        if (this.assemblyBean == null || !(this.assemblyBean instanceof AssemblyLocalIF)) {
            throw new IllegalStateException("assemblyBean field has not been correctly injected when post-construct method is called." + String.valueOf(this.assemblyBean));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        PrintWriter pw = response.getWriter();
        String testname = request.getParameter("testname");
        StringBuilder sb = new StringBuilder();
        if ("ejbInjectionInFilterTest".equals(testname)) {
            boolean pass1 = false;
            boolean pass2 = false;
            if (this.assemblyBean != null && this.assemblyBean instanceof AssemblyLocalIF) {
                pass1 = true;
                sb.append("assemblyBean field has been correctly injected:");
                sb.append(this.assemblyBean);
            } else {
                sb.append("assemblyBean field has not been correctly injected:");
                sb.append(this.assemblyBean);
            }
            if (this.helloBean != null && this.helloBean instanceof HelloRemoteIF) {
                pass2 = true;
                sb.append("helloBean field has been correctly injected:");
                sb.append(this.helloBean);
            } else {
                sb.append("helloBean field has not been correctly injected:");
                sb.append(this.helloBean);
            }
            if (this.postConstructCalled) {
                sb.append(" postConstruct method in servlet filter has been called.");
            } else {
                sb.append(" postConstruct method in servlet filter has not been called.");
            }
            sb.append(" ").append(pass1 && pass2 && this.postConstructCalled ? "Test PASSED" : "Test FAILED");
            pw.println(sb.toString());
        }
        try {
            chain.doFilter(request, response);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }
}

