/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.lite.timer.basic.concurrency;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.lite.EJBLiteClientBase;
import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import com.sun.ts.tests.ejb32.lite.timer.basic.concurrency.TimerIF;
import jakarta.ejb.EJB;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class Client
extends EJBLiteClientBase {
    private static final int THREAD_COUNT = 100;
    private static final int INCREMENT = 999;
    private static final int EXPECTED_SUM = 99900;
    private static final int CREATE_TIMER_AFTER_MILLIS = 1000;
    private static final long DEFAULT_MAX_WAIT_MILLIS = 300000L;
    private static final long POLL_INTERVAL_MILLIS = 60000L;
    @EJB(beanName="WriteSingletonTimerBean")
    private TimerIF writeSingletonTimerBean;
    @EJB(beanName="ReadSingletonTimerBean")
    private TimerIF readSingletonTimerBean;

    public void lookupTimerService() throws InterruptedException, ExecutionException {
        Future<String> f = this.readSingletonTimerBean.lookupTimerService();
        this.appendReason(new Object[]{f.get()});
    }

    public void readLockTimeout() {
        this.lockTimeout(this.readSingletonTimerBean);
        this.assertNotEquals(null, 99900, this.getAndResetResult(this.readSingletonTimerBean, 99900, new long[0]));
    }

    public void readLockBusyAdd() {
        this.readSingletonTimerBean.cancelAllTimers();
        this.readSingletonTimerBean.resetResult();
        this.readSingletonTimerBean.setIncrement(999);
        for (int i = 0; i < 100; ++i) {
            this.readSingletonTimerBean.readLockBusyAdd();
        }
        this.assertNotEquals(null, 99900, this.getAndResetResult(this.readSingletonTimerBean, 99900, new long[0]));
    }

    public void writeLockTimeout() {
        this.lockTimeout(this.writeSingletonTimerBean);
        this.assertEquals(null, 99900, this.getAndResetResult(this.writeSingletonTimerBean, 99900, new long[0]));
    }

    private void lockTimeout(TimerIF b) {
        b.cancelAllTimers();
        b.resetResult();
        b.setIncrement(999);
        Date d = TimerUtil.getCurrentDatePlus((int)14, (int)1000);
        for (int i = 0; i < 100; ++i) {
            String name = this.getTestName() + i;
            b.createTimer(name, d);
        }
    }

    protected Integer getAndResetResult(TimerIF b, int expected, long ... maxWaitMillis) {
        long waitFor = maxWaitMillis.length == 0 ? 300000L : maxWaitMillis[0];
        long stopTime = System.currentTimeMillis() + waitFor;
        boolean avail = b.isResultComplete(expected);
        while (!avail && System.currentTimeMillis() < stopTime) {
            TestUtil.sleep((int)60000);
            avail = b.isResultComplete(expected);
        }
        return b.getAndResetResult();
    }
}

