/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.interview;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.TreeQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.WorkDirectory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;

public class TestsInterview
extends Interview
implements Parameters.MutableTestsParameters {
    private YesNoQuestion qNeedTests = new YesNoQuestion(this, "needTests", "No"){

        @Override
        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return TestsInterview.this.qTreeOrFile;
            }
            return TestsInterview.this.qEnd;
        }
    };
    private static final String FILE = "file";
    private static final String TREE = "tree";
    protected TreeOrFileChoiceQuestion qTreeOrFile = this.createTreeOrFileChoiceQuestion(this, "treeOrFile");
    protected FileQuestion qTestFile = new FileQuestion(this, "testFile"){

        @Override
        public boolean isValueValid() {
            return this.value != null && this.value.getPath().length() > 0;
        }

        @Override
        protected Question getNext() {
            if (this.value == null || this.value.getPath().length() == 0) {
                return null;
            }
            String[] tests = TestsInterview.this.getTests(this.value);
            if (tests == null) {
                return TestsInterview.this.cachedTestsError;
            }
            TestsInterview.this.validateTests(tests);
            if (TestsInterview.this.cachedTestsError != null) {
                return TestsInterview.this.cachedTestsError;
            }
            return TestsInterview.this.qEnd;
        }
    };
    private Question qCantFindFileError = new ErrorQuestion(this, "cantFindFile"){

        @Override
        protected Object[] getTextArgs() {
            return TestsInterview.this.cachedTestsErrorArgs;
        }
    };
    private Question qCantReadFileError = new ErrorQuestion(this, "cantReadFile"){

        @Override
        protected Object[] getTextArgs() {
            return TestsInterview.this.cachedTestsErrorArgs;
        }
    };
    private TreeQuestion.Model model = new TreeQuestion.Model(){

        @Override
        public Object getRoot() {
            if (TestsInterview.this.parent == null || TestsInterview.this.parent.getWorkDirectory() == null) {
                return null;
            }
            WorkDirectory wd = TestsInterview.this.parent.getWorkDirectory();
            if (wd.getTestResultTable() == null) {
                return null;
            }
            return wd.getTestResultTable().getRoot();
        }

        @Override
        public int getChildCount(Object node) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (node instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)node).getChildCount();
            }
            if (node instanceof TestResult) {
                return 0;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Object getChild(Object node, int index) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (node instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)node).getChild(index);
            }
            if (node instanceof TestResult) {
                return null;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String getName(Object node) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (node instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)node).getName();
            }
            if (node instanceof TestResult) {
                TestResult tr = (TestResult)node;
                String fullName = tr.getTestName();
                int lastSlash = fullName.lastIndexOf("/");
                return lastSlash == -1 ? fullName : fullName.substring(lastSlash + 1);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String getPath(Object node) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (node instanceof TestResult) {
                return ((TestResult)node).getTestName();
            }
            if (node instanceof TestResultTable.TreeNode) {
                TestResultTable.TreeNode tn = (TestResultTable.TreeNode)node;
                if (tn.isRoot()) {
                    return tn.getName();
                }
                return this.getPath(tn.getParent() + "/" + tn.getName());
            }
            throw new IllegalArgumentException();
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (node instanceof TestResult) {
                return true;
            }
            if (node instanceof TestResultTable.TreeNode) {
                return false;
            }
            throw new IllegalArgumentException();
        }
    };
    protected TreeQuestion qTestTree = new TreeQuestion(this, "tests", this.model){

        @Override
        protected Question getNext() {
            TestsInterview.this.validateTests(this.value);
            if (TestsInterview.this.cachedTestsError != null) {
                return TestsInterview.this.cachedTestsError;
            }
            return TestsInterview.this.qEnd;
        }
    };
    private Question qNoTestsError = new ErrorQuestion(this, "noTests");
    private ErrorQuestion qBadTestsError = new ErrorQuestion(this, "badTests"){

        @Override
        protected Object[] getTextArgs() {
            return TestsInterview.this.cachedTestsErrorArgs;
        }
    };
    private String[] cachedTestsValue;
    protected Question cachedTestsError;
    private Object[] cachedTestsErrorArgs;
    protected Question qEnd = new FinalQuestion(this);
    private InterviewParameters parent;

    public TestsInterview(InterviewParameters parent) throws Interview.Fault {
        super(parent, "tests");
        this.parent = parent;
        this.setResourceBundle("i18n");
        this.setHelpSet("/com/sun/javatest/moreInfo/moreInfo.hs");
        this.setFirstQuestion(this.qNeedTests);
    }

    public void dispose() {
        this.cachedTestsValue = null;
        this.cachedTestsError = null;
        this.cachedTestsErrorArgs = null;
    }

    @Override
    public String[] getTests() {
        if (this.qNeedTests.getValue() == "Yes") {
            if (this.qTreeOrFile.getValue() == TREE) {
                return this.qTestTree.getValue();
            }
            if (this.qTreeOrFile.getValue() == FILE) {
                return this.getTests(this.qTestFile.getValue());
            }
            return null;
        }
        return null;
    }

    @Override
    public void setTests(String[] tests) {
        if (tests == null) {
            this.setTestsMode(1);
        } else {
            this.setTestsMode(2);
            this.setSpecifiedTests(tests);
        }
    }

    @Override
    public int getTestsMode() {
        return this.qNeedTests.getValue() == "Yes" ? 2 : 1;
    }

    @Override
    public void setTestsMode(int mode) {
        switch (mode) {
            case 1: {
                this.qNeedTests.setValue("No");
                break;
            }
            case 2: {
                this.qNeedTests.setValue("Yes");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public String[] getSpecifiedTests() {
        Object v = this.qTreeOrFile.getValue() == TREE ? this.qTestTree.getValue() : (this.qTreeOrFile.getValue() == FILE ? this.getTests(this.qTestFile.getValue()) : null);
        if (v == null) {
            return null;
        }
        TreeSet<String> ts = new TreeSet<String>(Arrays.asList(v));
        return ts.toArray(new String[ts.size()]);
    }

    @Override
    public void setSpecifiedTests(String[] tests) {
        this.qTreeOrFile.setValue(TREE);
        this.qTestTree.setValue(tests);
    }

    protected TreeOrFileChoiceQuestion createTreeOrFileChoiceQuestion(Interview interview, String tag) {
        return new TreeOrFileChoiceQuestion(interview, tag);
    }

    protected String[] getTests(File file) {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                int sp = line.indexOf(32);
                paths.add(sp == -1 ? line : line.substring(0, sp));
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            this.cachedTestsError = this.qCantFindFileError;
            this.cachedTestsErrorArgs = new Object[]{file};
            return null;
        }
        catch (IOException e) {
            this.cachedTestsError = this.qCantFindFileError;
            this.cachedTestsErrorArgs = new Object[]{file, e.toString()};
            return null;
        }
        return paths.toArray(new String[paths.size()]);
    }

    private void validateTests(String[] tests) {
        if (TestsInterview.equal(tests, this.cachedTestsValue)) {
            return;
        }
        this.cachedTestsValue = tests;
        this.cachedTestsError = null;
        WorkDirectory wd = this.parent.getWorkDirectory();
        if (wd == null) {
            return;
        }
        TestResultTable trt = wd.getTestResultTable();
        if (tests == null || tests.length == 0) {
            return;
        }
        ArrayList<String> v = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tests.length; ++i) {
            String test = tests[i];
            if (v.contains(test) || trt.validatePath(test)) continue;
            if (sb.length() > 32) {
                sb.append("...");
                break;
            }
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(test);
            v.add(test);
        }
        if (sb.length() > 0) {
            this.cachedTestsError = this.qBadTestsError;
            this.cachedTestsErrorArgs = new Object[]{new Integer(v.size()), sb.toString()};
        }
    }

    private static boolean equal(String[] s1, String[] s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        if (s1.length != s2.length) {
            return false;
        }
        for (int i = 0; i < s1.length; ++i) {
            if (s1[i] == s2[i]) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Object[] access$002(TestsInterview x0, Object[] x1) {
        x0.cachedTestsErrorArgs = x1;
        return x1;
    }

    static /* synthetic */ String[] access$102(TestsInterview x0, String[] x1) {
        x0.cachedTestsValue = x1;
        return x1;
    }

    public class TreeOrFileChoiceQuestion
    extends ChoiceQuestion {
        public TreeOrFileChoiceQuestion(Interview interview, String tag) {
            super(interview, tag);
            this.setChoices(this.getTestSelectionChoices(), true);
        }

        protected String[] getTestSelectionChoices() {
            return new String[]{TestsInterview.TREE, TestsInterview.FILE};
        }

        @Override
        public void setValue(String newValue) {
            if (newValue != this.value) {
                TestsInterview.this.cachedTestsError = null;
                TestsInterview.access$002(TestsInterview.this, null);
                TestsInterview.access$102(TestsInterview.this, null);
            }
            super.setValue(newValue);
        }

        @Override
        protected Question getNext() {
            if (this.value == TestsInterview.TREE) {
                return TestsInterview.this.qTestTree;
            }
            return TestsInterview.this.qTestFile;
        }
    }
}

