/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.resource.requestmatching;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.resource.requestmatching.AnotherResourceLocator;
import ee.jakarta.tck.ws.rs.spec.resource.requestmatching.AnotherSubResource;
import ee.jakarta.tck.ws.rs.spec.resource.requestmatching.EmptyResource;
import ee.jakarta.tck.ws.rs.spec.resource.requestmatching.ExceptionMatcher;
import ee.jakarta.tck.ws.rs.spec.resource.requestmatching.LocatorResource;
import ee.jakarta.tck.ws.rs.spec.resource.requestmatching.MainResource;
import ee.jakarta.tck.ws.rs.spec.resource.requestmatching.MainResourceLocator;
import ee.jakarta.tck.ws.rs.spec.resource.requestmatching.MainSubResource;
import ee.jakarta.tck.ws.rs.spec.resource.requestmatching.TSAppConfig;
import ee.jakarta.tck.ws.rs.spec.resource.requestmatching.YetAnotherSubresource;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_resource_requestmatching_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/resource/requestmatching/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_resource_requestmatching_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, MainResource.class, EmptyResource.class, AnotherResourceLocator.class, AnotherSubResource.class, ExceptionMatcher.class, LocatorResource.class, MainResourceLocator.class, MainSubResource.class, YetAnotherSubresource.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    public void emptyUriTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "").replace("/ ", " "));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.MOVED_PERMANENTLY));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.FOUND));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.SEE_OTHER));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.TEMPORARY_REDIRECT));
        this.invoke();
        switch (this.getResponseStatusCode()) {
            case OK: {
                String search = EmptyResource.class.getSimpleName();
                this.assertResponseBodyContain(search);
                break;
            }
            case MOVED_PERMANENTLY: 
            case FOUND: 
            case SEE_OTHER: 
            case TEMPORARY_REDIRECT: {
                String search = this.getContextRoot() + "/";
                this.assertResponseHeadersContain(search);
            }
        }
    }

    @Test
    public void slashUriTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EmptyResource.class.getSimpleName());
        this.invoke();
    }

    @Test
    public void slashWrongUriTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "wrong"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, JAXRSClientIT.getStatusCode(Response.Status.NOT_FOUND));
        this.invoke();
    }

    @Test
    public void wrongAppNameTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "").replace("web", "wrong"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NOT_FOUND));
        this.invoke();
    }

    @Test
    public void slashAppNameTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, JAXRSCommonClient.Request.GET.name() + " /resource HTTP/1.1");
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NOT_FOUND));
        this.invoke();
    }

    @Test
    public void descendantResourcePathValueTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/subresource"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, MainSubResource.class.getSimpleName());
        this.invoke();
    }

    @Test
    public void descendantSubResourcePathValueTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "resource/subresource/sub"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, AnotherSubResource.class.getSimpleName());
        this.invoke();
    }

    @Test
    public void resourceLocatorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/locator/locator"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, LocatorResource.class.getSimpleName());
        this.invoke();
    }

    @Test
    public void foundAnotherResourceLocatorByPathTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/locator/sub"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, AnotherResourceLocator.class.getSimpleName());
        this.invoke();
    }

    @Test
    public void locatorNameTooLongTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/locator/sub/locator"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, JAXRSClientIT.getStatusCode(Response.Status.NOT_FOUND));
        this.invoke();
    }

    @Test
    public void locatorNameTooLongAgainTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/locator/locator/locator"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, JAXRSClientIT.getStatusCode(Response.Status.NOT_FOUND));
        this.invoke();
    }

    @Test
    public void methodNotFoundTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/locator/test"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, JAXRSClientIT.getStatusCode(Response.Status.NOT_FOUND));
        this.invoke();
    }

    @Test
    public void requestNotSupportedOnResourceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.PUT, "resource/something"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, JAXRSClientIT.getStatusCode(Response.Status.METHOD_NOT_ALLOWED));
        this.invoke();
    }

    @Test
    public void requestNotSupportedOnSubResourceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.PUT, "resource/subresource/something"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, JAXRSClientIT.getStatusCode(Response.Status.METHOD_NOT_ALLOWED));
        this.invoke();
    }

    @Test
    public void requestNotSupportedOnResourceLocatorTest() throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.PUT, "resource/subresource/consumeslocator");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, JAXRSClientIT.getStatusCode(Response.Status.METHOD_NOT_ALLOWED));
        this.invoke();
    }

    @Test
    public void requestNotSupportedOnSubResourceLocatorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.PUT, "resource/consumeslocator"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, JAXRSClientIT.getStatusCode(Response.Status.METHOD_NOT_ALLOWED));
        this.invoke();
    }

    @Test
    public void optionsOnSubResourceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.OPTIONS, "resource/subresource/something"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NO_CONTENT));
        this.invoke();
        boolean foundGet = false;
        for (String header : this.getResponseHeaders()) {
            if (!header.startsWith("Allow")) continue;
            foundGet |= header.contains(JAXRSCommonClient.Request.GET.name());
        }
        Assertions.assertTrue((boolean)foundGet, (String)"Header Allow: GET was not found");
        JAXRSClientIT.logMsg("Header Allow: GET found as expected");
    }

    @Test
    public void headOnSubResourceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.HEAD, "resource/subresource/something"));
        this.invoke();
        String body = this.getResponseBody();
        Assertions.assertTrue((body == null ? 1 : 0) != 0, (String)("Unexpected response body" + body));
    }

    @Test
    public void consumesOnResourceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "resource/consumes"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_ATOM_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, JAXRSClientIT.getStatusCode(Response.Status.UNSUPPORTED_MEDIA_TYPE));
        this.invoke();
    }

    @Test
    public void consumesCorrectContentTypeOnResourceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "resource/consumes"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, MainResource.class.getSimpleName());
        this.invoke();
    }

    @Test
    public void consumesOnResourceLocatorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "resource/consumeslocator"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_ATOM_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, JAXRSClientIT.getStatusCode(Response.Status.UNSUPPORTED_MEDIA_TYPE));
        this.invoke();
    }

    @Test
    public void consumesCorrectContentTypeOnResourceLocatorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "resource/consumeslocator"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, MainResourceLocator.class.getSimpleName());
        this.invoke();
    }

    @Test
    public void consumesOnSubResourceLocatorTest() throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "resource/subresource/consumeslocator");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_ATOM_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, JAXRSClientIT.getStatusCode(Response.Status.UNSUPPORTED_MEDIA_TYPE));
        this.invoke();
    }

    @Test
    public void consumesCorrectContentTypeOnSubResourceLocatorTest() throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "resource/subresource/consumeslocator");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, AnotherResourceLocator.class.getSimpleName());
        this.invoke();
    }

    @Test
    public void producesOnResourceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "resource/produces"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.APPLICATION_ATOM_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, JAXRSClientIT.getStatusCode(Response.Status.NOT_ACCEPTABLE));
        this.invoke();
    }

    @Test
    public void producesCorrectContentTypeOnResourceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "resource/produces"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, MainResource.class.getSimpleName());
        this.invoke();
    }

    @Test
    public void producesOnResourceLocatorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "resource/produceslocator"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.APPLICATION_ATOM_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, JAXRSClientIT.getStatusCode(Response.Status.NOT_ACCEPTABLE));
        this.invoke();
    }

    @Test
    public void producesCorrectContentTypeOnResourceLocatorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "resource/produceslocator"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, MainResourceLocator.class.getSimpleName());
        this.invoke();
    }

    @Test
    public void producesOnSubResourceLocatorTest() throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "resource/subresource/produceslocator");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.APPLICATION_ATOM_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, JAXRSClientIT.getStatusCode(Response.Status.NOT_ACCEPTABLE));
        this.invoke();
    }

    @Test
    public void producesCorrectContentTypeOnSubResourceLocatorTest() throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "resource/subresource/produceslocator");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, AnotherResourceLocator.class.getSimpleName());
        this.invoke();
    }

    @Test
    public void l2SubResourceLocatorTest() throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.DELETE, "resource/l2locator/l2locator");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, AnotherResourceLocator.class.getSimpleName());
        this.invoke();
    }

    @Test
    public void consumesOverridesDescendantSubResourcePathValueTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "resource/subresource/sub"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        String clazz = AnotherSubResource.class.getSimpleName();
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, clazz);
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, clazz + clazz);
        this.invoke();
    }

    @Test
    public void producesOverridesDescendantSubResourcePathValueTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/subresource/sub"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        String clazz = AnotherSubResource.class.getSimpleName();
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, clazz + clazz);
        this.invoke();
    }

    @Test
    public void producesOverridesDescendantSubResourcePathValuePostTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "resource/subresource/sub"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        String clazz = AnotherSubResource.class.getSimpleName();
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, clazz);
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, clazz + clazz);
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.invoke();
    }

    @Test
    public void concreteOverStarWhenAcceptStarTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "yas"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: testi/*");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "test/text");
        this.invoke();
    }

    @Test
    public void qualityDeterminesTextATest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "yas"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: testii/texta;q=0.5, testii/textb;q=0.4");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "textA");
        this.invoke();
    }

    @Test
    public void qualityDeterminesTextBTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "yas"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: testii/texta;q=0.4, testii/textb;q=0.5");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "textB");
        this.invoke();
    }

    @Test
    public void producesOverridesDescendantSubResourcePathValueWeightTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "yas"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/*");
        this.invoke();
    }

    @Test
    public void qualityOfSourceOnDifferentMediaTypesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "yas"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: testiii/textiii, application/xml");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "application/xml");
        this.invoke();
    }

    @Test
    public void concreteOverStarTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "yas"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: testi/text");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "test/text");
        this.invoke();
    }
}

