/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.provider.standardhaspriority;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.provider.standardhaspriority.AbstractProvider;
import ee.jakarta.tck.ws.rs.spec.provider.standardhaspriority.ProviderWalker;
import ee.jakarta.tck.ws.rs.spec.provider.standardhaspriority.Resource;
import ee.jakarta.tck.ws.rs.spec.provider.standardhaspriority.TSAppConfig;
import ee.jakarta.tck.ws.rs.spec.provider.standardhaspriority.TckBooleanProvider;
import ee.jakarta.tck.ws.rs.spec.provider.standardhaspriority.TckCharacterProvider;
import ee.jakarta.tck.ws.rs.spec.provider.standardhaspriority.TckJaxbProvider;
import ee.jakarta.tck.ws.rs.spec.provider.standardhaspriority.TckMapProvider;
import ee.jakarta.tck.ws.rs.spec.provider.standardhaspriority.TckNumberProvider;
import ee.jakarta.tck.ws.rs.spec.provider.standardhaspriority.TckUniversalProvider;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_provider_standardhaspriority_web/resource");
    }

    private void setPropertyAndInvoke(String resourceMethod, MediaType md) throws JAXRSCommonClient.Fault {
        String ct = JAXRSClientIT.buildContentType(md);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, resourceMethod));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, ct);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(md));
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "Tck" + resourceMethod + "Reader");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "Tck" + resourceMethod + "Writer");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, resourceMethod);
        this.invoke();
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/provider/standardhaspriority/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_provider_standardhaspriority_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, AbstractProvider.class, ProviderWalker.class, TckBooleanProvider.class, TckCharacterProvider.class, TckJaxbProvider.class, TckMapProvider.class, TckNumberProvider.class, TckUniversalProvider.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    @Tag(value="xml_binding")
    public void readWriteJaxbProviderTest() throws JAXRSCommonClient.Fault {
        JAXBElement element = new JAXBElement(new QName("jaxb"), String.class, (Object)"jaxb");
        this.setRequestContentEntity(element);
        this.setPropertyAndInvoke("jaxb", MediaType.APPLICATION_XML_TYPE);
    }

    @Test
    public void readWriteMapProviderTest() throws JAXRSCommonClient.Fault {
        MultivaluedHashMap map = new MultivaluedHashMap();
        map.add((Object)"map", (Object)"map");
        this.setRequestContentEntity(map);
        this.setPropertyAndInvoke("map", MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    @Test
    public void readWriteBooleanProviderTest() throws JAXRSCommonClient.Fault {
        MediaType mt = MediaType.TEXT_PLAIN_TYPE;
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "boolean"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(mt));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(mt));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "false");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "false");
        this.invoke();
    }

    @Test
    public void readWriteCharacterProviderTest() throws JAXRSCommonClient.Fault {
        MediaType mt = MediaType.TEXT_PLAIN_TYPE;
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "character"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(mt));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(mt));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "a");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "a");
        this.invoke();
    }

    @Test
    public void readWriteIntegerProviderTest() throws JAXRSCommonClient.Fault {
        MediaType mt = MediaType.TEXT_PLAIN_TYPE;
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "number"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(mt));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(mt));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "0");
        this.invoke();
    }
}

