/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.responsestatustype;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Response;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -4533695636737308500L;
    static final int[] status_codes = new int[]{200, 201, 202, 204, 205, 206, 301, 302, 303, 304, 305, 307, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 500, 501, 502, 503, 504, 505};
    static final Response.Status.Family[] status_family = new Response.Status.Family[]{Response.Status.Family.SUCCESSFUL, Response.Status.Family.SUCCESSFUL, Response.Status.Family.SUCCESSFUL, Response.Status.Family.SUCCESSFUL, Response.Status.Family.SUCCESSFUL, Response.Status.Family.SUCCESSFUL, Response.Status.Family.REDIRECTION, Response.Status.Family.REDIRECTION, Response.Status.Family.REDIRECTION, Response.Status.Family.REDIRECTION, Response.Status.Family.REDIRECTION, Response.Status.Family.REDIRECTION, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.SERVER_ERROR, Response.Status.Family.SERVER_ERROR, Response.Status.Family.SERVER_ERROR, Response.Status.Family.SERVER_ERROR, Response.Status.Family.SERVER_ERROR, Response.Status.Family.SERVER_ERROR};
    final String[] status = new String[]{"OK", "Created", "Accepted", "No Content", "Reset Content", "Partial Content", "Moved Permanently", "Found", "See Other", "Not Modified", "Use Proxy", "Temporary Redirect", "Bad Request", "Unauthorized", "Payment Required", "Forbidden", "Not Found", "Method Not Allowed", "Not Acceptable", "Proxy Authentication Required", "Request Timeout", "Conflict", "Gone", "Length Required", "Precondition Failed", "Request Entity Too Large", "Request-URI Too Long", "Unsupported Media Type", "Requested Range Not Satisfiable", "Expectation Failed", "Internal Server Error", "Not Implemented", "Bad Gateway", "Service Unavailable", "Gateway Timeout", "HTTP Version Not Supported"};

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void getFamilyTest() throws JAXRSCommonClient.Fault {
        for (int i = 0; i != status_codes.length; ++i) {
            Response response = Response.status((int)status_codes[i]).build();
            Response.StatusType type = response.getStatusInfo();
            Response.Status.Family family = type.getFamily();
            Assertions.assertTrue((family == status_family[i] ? 1 : 0) != 0, (String)("unexpected family " + family + " differs from " + status_family[i]));
            JAXRSClientIT.logMsg("Found expected family", family, "for status", status_codes[i]);
        }
    }

    @Test
    public void getReasonPhraseTest() throws JAXRSCommonClient.Fault {
        for (int i = 0; i != status_codes.length; ++i) {
            Response response = Response.status((int)status_codes[i]).build();
            Response.StatusType type = response.getStatusInfo();
            String phrase = type.getReasonPhrase();
            Assertions.assertTrue((boolean)phrase.equals(this.status[i]), (String)("unexpected phrase " + phrase + " differs from " + this.status[i]));
            JAXRSClientIT.logMsg("Found expected phrase", phrase, "for status", status_codes[i]);
        }
    }

    @Test
    public void getStatusCodeTest() throws JAXRSCommonClient.Fault {
        for (int i = 0; i != status_codes.length; ++i) {
            Response response = Response.status((int)status_codes[i]).build();
            Response.StatusType type = response.getStatusInfo();
            int code = type.getStatusCode();
            Assertions.assertTrue((code == status_codes[i] ? 1 : 0) != 0, (String)("unexpected status code " + code + " differs from " + status_codes[i]));
            JAXRSClientIT.logMsg("Found expected status code", code, "for status", status_codes[i]);
        }
    }

    @Test
    public void familyOfTest() throws JAXRSCommonClient.Fault {
        for (int i = 0; i != status_codes.length; ++i) {
            Response.Status.Family family = Response.Status.Family.familyOf((int)status_codes[i]);
            Assertions.assertTrue((family == status_family[i] ? 1 : 0) != 0, (String)(family + " differs from expected: " + status_family[i]));
        }
        JAXRSClientIT.logMsg("#familyOf() returned expected Family for given statuses");
    }
}

