/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.session.stateless.basic;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.common.base.EETest;
import com.sun.ts.tests.ejb30.common.calc.CalculatorException;
import com.sun.ts.tests.ejb30.common.calc.RemoteCalculator;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import jakarta.annotation.PostConstruct;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;

public class Client
extends EETest {
    private static int postConstructCallsCount;
    private static final String beanRefName = "java:comp/env/ejb/RemoteCalculatorBean";
    private static final String bean2RefName = "java:comp/env/ejb/RemoteCalculatorBean2";
    private static final String bean3RefName = "java:comp/env/ejb/RemoteCalculatorBean3";
    private static final String bean4RefName = "java:comp/env/ejb/RemoteCalculatorBean4";
    private static final String bean5RefName = "java:comp/env/ejb/RemoteCalculatorBean5";
    private Properties props;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @PostConstruct
    static final void postConstruct() {
        ++postConstructCallsCount;
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
    }

    public void postConstructInvokedEvenNoResourceInjection() throws Exception {
        if (postConstructCallsCount <= 0) {
            throw new Exception("Expecting the Client.PostConstruct to be invoked  at least once, but actual " + postConstructCallsCount);
        }
        TLogger.log("Got expected result.  Client.PostConstruct method is invoked " + postConstructCallsCount + " times");
    }

    public void testRemoteAdd() throws Exception {
        RemoteCalculator bean = null;
        int op1 = 2;
        int op2 = 3;
        int expected = op1 + op2;
        int result = 0;
        boolean result2 = false;
        try {
            bean = (RemoteCalculator)ServiceLocator.lookup(beanRefName, new Context[0]);
            result = bean.remoteAdd(op1, op2);
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
        if (result != expected) {
            throw new Exception("Expected " + expected + ", actual " + result);
        }
        TLogger.log("Got expected result: " + expected);
    }

    public void postConstructCalledEvenNoResourceInjectionInBean() throws Exception {
        RemoteCalculator bean2 = null;
        int op1 = 0;
        int op2 = 0;
        int expectedPostConstructCallsCount = 1;
        int expected = op1 + op2 + expectedPostConstructCallsCount;
        try {
            bean2 = (RemoteCalculator)ServiceLocator.lookup(bean2RefName, new Context[0]);
        }
        catch (NamingException e) {
            throw new Exception(e);
        }
        int result2 = bean2.remoteAdd(op1, op2);
        if (result2 != expected) {
            throw new Exception("Expected " + expected + ", actual " + result2 + ".  Likely reason is that post-construct in the target bean may not have been called when the business method is invoked.");
        }
        TLogger.log("Got expected result: " + expected + ", which means post-construct method is called even when the bean contains no injection.");
    }

    public void postConstructInSuperCalledEvenNoAnnotationInBean() throws Exception {
        RemoteCalculator bean3 = null;
        int op1 = -10;
        int op2 = -20;
        int expectedPostConstructCallsCount = 1;
        int expected = op1 + op2 + expectedPostConstructCallsCount;
        try {
            bean3 = (RemoteCalculator)ServiceLocator.lookup(bean3RefName, new Context[0]);
        }
        catch (NamingException e) {
            throw new Exception(e);
        }
        int result3 = bean3.remoteAdd(op1, op2);
        if (result3 != expected) {
            throw new Exception("Expected " + expected + ", actual " + result3 + ".  Likely reason is that post-construct in the target bean superclass may not have been called when the business method is invoked.");
        }
        TLogger.log("Got expected result: " + expected + ", which means post-construct method in superclass is called even when the bean contains no annotation.");
    }

    public void injectedIntoSuperCalledEvenNoAnnotationInBean() throws Exception {
        RemoteCalculator bean4 = null;
        int op1 = 1;
        int op2 = 2;
        int unexpected = op1 + op2;
        try {
            bean4 = (RemoteCalculator)ServiceLocator.lookup(bean4RefName, new Context[0]);
        }
        catch (NamingException e) {
            throw new Exception(e);
        }
        int result4 = bean4.remoteAdd(op1, op2);
        if (result4 <= unexpected) {
            throw new Exception("Unexpected result " + result4 + ".  Likely reason is that injection in the target bean superclass may not have been performed when the business method is invoked.");
        }
        TLogger.log("Did not get unexpected result.  Actual result " + result4 + ", which means injection in superclass is called even when the bean contains no annotation.");
    }

    public void noComponentDefiningAnnotations() throws Exception {
        RemoteCalculator bean5 = null;
        int op1 = 1;
        int op2 = 2;
        try {
            bean5 = (RemoteCalculator)ServiceLocator.lookup(bean5RefName, new Context[0]);
        }
        catch (NamingException e) {
            throw new Exception(e);
        }
        int result5 = bean5.remoteAdd(op1, op2);
        TLogger.log("remoteAdd returned " + result5);
    }

    public void testRemoteThrowIt() throws Exception {
        RemoteCalculator bean = null;
        boolean passed = false;
        try {
            bean = (RemoteCalculator)ServiceLocator.lookup(beanRefName, new Context[0]);
            bean.remoteThrowIt();
        }
        catch (CalculatorException e) {
            passed = true;
        }
        catch (Exception e) {
            throw new Exception("Unexpected exception:", e);
        }
        if (!passed) {
            throw new Exception("Expected CalculatorException, actual no exception");
        }
    }

    public void cleanup() throws Exception {
    }
}

