/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.ha.cache.store.backing.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.ha.cache.api.DataStoreException;
import org.glassfish.shoal.ha.cache.command.Command;
import org.glassfish.shoal.ha.cache.store.DataStoreEntry;
import org.glassfish.shoal.ha.cache.store.backing.commands.LoadResponseCommand;
import org.glassfish.shoal.ha.cache.util.CommandResponse;
import org.glassfish.shoal.ha.cache.util.ResponseMediator;

public class LoadRequestCommand<K, V>
extends Command<K, V> {
    private static final long serialVersionUID = 3672209854011660431L;
    private static final Logger _logger = Logger.getLogger("org.glassfish.shoal.ha.cache.command.load_request");
    private transient CommandResponse resp;
    private transient Future future;
    private long minVersion = -1L;
    private long tokenId;
    private String originatingInstance;
    private String target;

    public LoadRequestCommand() {
        super((byte)35);
    }

    public LoadRequestCommand(K key, long minVersion, String t) {
        this();
        super.setKey(key);
        this.minVersion = minVersion;
        this.target = t;
    }

    @Override
    protected boolean beforeTransmit() {
        this.setTargetName(this.target);
        this.originatingInstance = this.dsc.getInstanceName();
        ResponseMediator respMed = this.dsc.getResponseMediator();
        this.resp = respMed.createCommandResponse();
        this.future = this.resp.getFuture();
        return this.target != null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.minVersion);
        out.writeLong(this.resp.getTokenId());
        out.writeUTF(this.originatingInstance);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.dsc.getInstanceName() + this.getName() + " sending load_request command for " + String.valueOf(this.getKey()) + "to " + this.target);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.minVersion = in.readLong();
        this.tokenId = in.readLong();
        this.originatingInstance = in.readUTF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) {
        block11: {
            try {
                DataStoreEntry e;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, this.dsc.getInstanceName() + this.getName() + " received load_request command for " + String.valueOf(this.getKey()) + "from " + initiator);
                }
                if ((e = this.dsc.getReplicaStore().getEntry(this.getKey())) != null) {
                    DataStoreEntry dataStoreEntry = e;
                    synchronized (dataStoreEntry) {
                        if (!this.originatingInstance.equals(this.dsc.getInstanceName())) {
                            LoadResponseCommand rsp = this.dsc.getDataStoreEntryUpdater().createLoadResponseCommand(e, this.getKey(), this.minVersion);
                            rsp.setTokenId(this.tokenId);
                            rsp.setOriginatingInstance(this.originatingInstance);
                            this.getCommandManager().execute(rsp);
                        } else {
                            this.resp.setResult(this.dsc.getDataStoreEntryUpdater().getV(e));
                        }
                        break block11;
                    }
                }
                if (!this.originatingInstance.equals(this.dsc.getInstanceName())) {
                    LoadResponseCommand rsp = this.dsc.getDataStoreEntryUpdater().createLoadResponseCommand(null, this.getKey(), this.minVersion);
                    rsp.setTokenId(this.tokenId);
                    rsp.setOriginatingInstance(this.originatingInstance);
                    this.getCommandManager().execute(rsp);
                } else {
                    this.resp.setResult(null);
                }
            }
            catch (DataStoreException dsEx) {
                this.resp.setException(dsEx);
            }
        }
    }

    public String getRespondingInstanceName() {
        return this.resp.getRespondingInstanceName();
    }

    public V getResult(long waitFor, TimeUnit unit) throws DataStoreException {
        try {
            Object result = this.future.get(waitFor, unit);
            if (result instanceof Exception) {
                throw new DataStoreException((Exception)result);
            }
            LoadResponseCommand respCmd = (LoadResponseCommand)result;
            result = respCmd.getVersion() >= this.minVersion ? this.dsc.getDataStoreEntryUpdater().extractVFrom(respCmd) : null;
            return result;
        }
        catch (DataStoreException dsEx) {
            throw dsEx;
        }
        catch (InterruptedException inEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand Interrupted while waiting for result", inEx);
            throw new DataStoreException(inEx);
        }
        catch (TimeoutException timeoutEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand timed out while waiting for result " + String.valueOf(timeoutEx));
            return null;
        }
        catch (ExecutionException exeEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand got an exception while waiting for result", exeEx);
            throw new DataStoreException(exeEx);
        }
    }

    @Override
    public String toString() {
        return this.getName() + "(" + String.valueOf(this.getKey()) + ")";
    }
}

