/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.mgmt.transport.grizzly.grizzly2;

import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.shoal.gms.mgmt.transport.buffers.Buffer;
import org.glassfish.shoal.gms.mgmt.transport.buffers.ExpandableBufferWriter;
import org.glassfish.shoal.gms.mgmt.transport.buffers.ExpandableBufferWriterFactory;
import org.glassfish.shoal.gms.mgmt.transport.grizzly.grizzly2.GMSBufferWrapper;

public final class Grizzly2ExpandableBufferWriter
extends ExpandableBufferWriter {
    private final MemoryManager memoryManager;
    private final GMSBufferWrapper wrapper = new GMSBufferWrapper();
    private org.glassfish.grizzly.Buffer grizzlyBuffer;

    public static ExpandableBufferWriterFactory createFactory(final MemoryManager memoryManager) {
        return new ExpandableBufferWriterFactory(){

            @Override
            public ExpandableBufferWriter create() {
                return new Grizzly2ExpandableBufferWriter(memoryManager);
            }
        };
    }

    private Grizzly2ExpandableBufferWriter(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
        this.grizzlyBuffer = memoryManager.allocate(4096);
        this.wrapper.wrap(this.grizzlyBuffer);
    }

    @Override
    public Buffer getBuffer() {
        return this.wrapper;
    }

    @Override
    public Buffer toBuffer() {
        this.grizzlyBuffer.trim();
        Buffer duplicate = this.wrapper.duplicate();
        this.grizzlyBuffer.position(this.grizzlyBuffer.limit());
        return duplicate;
    }

    @Override
    public int position() {
        return this.grizzlyBuffer.position();
    }

    @Override
    public void position(int pos) {
        this.grizzlyBuffer.position(pos);
    }

    @Override
    protected void ensureCapacity(int delta) {
        if (delta <= 0 || this.grizzlyBuffer.remaining() >= delta) {
            return;
        }
        this.grizzlyBuffer = this.memoryManager.reallocate(this.grizzlyBuffer, Math.max(this.grizzlyBuffer.capacity() * 2, this.grizzlyBuffer.capacity() + delta));
        this.wrapper.wrap(this.grizzlyBuffer);
    }
}

