/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.ConfigHelper;
import io.helidon.config.ConfigKeyImpl;
import io.helidon.config.ConfigSourceRuntime;
import io.helidon.config.ConfigSourceRuntimeImpl;
import io.helidon.config.ConfigSources;
import io.helidon.config.ObjectNodeImpl;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.MergingStrategy;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class ConfigSourcesRuntime {
    private final List<RuntimeWithData> loadedData = new LinkedList<RuntimeWithData>();
    private final List<ConfigSourceRuntimeImpl> allSources;
    private final MergingStrategy mergingStrategy;
    private volatile Consumer<Optional<ConfigNode.ObjectNode>> changeListener;

    ConfigSourcesRuntime(List<ConfigSourceRuntimeImpl> allSources, MergingStrategy mergingStrategy) {
        this.allSources = allSources;
        this.mergingStrategy = mergingStrategy;
    }

    static ConfigSourcesRuntime empty() {
        return new ConfigSourcesRuntime(List.of(new ConfigSourceRuntimeImpl(null, ConfigSources.empty())), MergingStrategy.fallback());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigSourcesRuntime that = (ConfigSourcesRuntime)o;
        return this.allSources.equals(that.allSources);
    }

    public int hashCode() {
        return Objects.hash(this.allSources);
    }

    public String toString() {
        return this.allSources.toString();
    }

    Optional<ConfigNode> lazyValue(String key) {
        for (RuntimeWithData runtimeWithData : this.loadedData) {
            Optional<ConfigNode> node;
            ConfigSourceRuntimeImpl source = runtimeWithData.runtime;
            if (!source.isLazy() || !(node = source.node(key)).isPresent()) continue;
            Optional<ConfigNode.ObjectNode> data = runtimeWithData.data;
            ConfigNode.ObjectNode newNode = this.toRootNode(key, node.get());
            runtimeWithData.data = data = Optional.of(data.map(objectNode -> this.mergingStrategy.merge(List.of(newNode, objectNode))).orElse(newNode));
            return node;
        }
        return Optional.empty();
    }

    void changeListener(Consumer<Optional<ConfigNode.ObjectNode>> changeListener) {
        this.changeListener = changeListener;
    }

    void startChanges() {
        this.loadedData.stream().filter(loaded -> loaded.runtime().changesSupported()).forEach(loaded -> loaded.runtime().onChange((key, configNode) -> {
            this.processChange((RuntimeWithData)loaded, (String)key, (ConfigNode)configNode);
            this.changeListener.accept(this.latest());
        }));
    }

    private void processChange(RuntimeWithData runtimeWithData, String changedKey, ConfigNode changeNode) {
        ConfigKeyImpl key = ConfigKeyImpl.of(changedKey);
        ConfigNode.ObjectNode changeObjectNode = this.toObjectNode(changeNode);
        if (key.isRoot()) {
            runtimeWithData.data = Optional.of(changeObjectNode);
            return;
        }
        ConfigNode.ObjectNode newRootNode = this.toRootNode(changedKey, changeNode);
        if (runtimeWithData.data.isEmpty()) {
            runtimeWithData.data = Optional.of(newRootNode);
        }
        runtimeWithData.data = Optional.of(this.mergingStrategy.merge(List.of(newRootNode, runtimeWithData.data.get())));
    }

    private ConfigNode.ObjectNode toRootNode(String key, ConfigNode configNode) {
        ConfigKeyImpl configKey = ConfigKeyImpl.of(key);
        if (configKey.isRoot()) {
            return this.toObjectNode(configNode);
        }
        LinkedList<String> path = new LinkedList<String>();
        while (!configKey.isRoot()) {
            path.add(configKey.name());
            configKey = configKey.parent();
        }
        ConfigNode.ObjectNode.Builder currentBuilder = ConfigNode.ObjectNode.builder();
        ConfigNode previousNode = configNode;
        for (String pathElement : path) {
            currentBuilder.addNode(pathElement, previousNode);
            previousNode = currentBuilder.build();
            currentBuilder = ConfigNode.ObjectNode.builder();
        }
        return (ConfigNode.ObjectNode)previousNode;
    }

    private ConfigNode.ObjectNode toObjectNode(ConfigNode changeNode) {
        switch (changeNode.nodeType()) {
            case OBJECT: {
                return (ConfigNode.ObjectNode)changeNode;
            }
            case LIST: {
                return ConfigNode.ObjectNode.builder().addList("", (ConfigNode.ListNode)changeNode).build();
            }
            case VALUE: {
                return ConfigNode.ObjectNode.builder().value(((ConfigNode.ValueNode)changeNode).get()).build();
            }
        }
        throw new IllegalArgumentException("Unsupported node type: " + String.valueOf(changeNode.nodeType()));
    }

    synchronized Optional<ConfigNode.ObjectNode> latest() {
        List objectNodes = this.loadedData.stream().map(RuntimeWithData::data).flatMap(Optional::stream).collect(Collectors.toList());
        return Optional.of(this.mergingStrategy.merge(objectNodes));
    }

    synchronized Optional<ConfigNode.ObjectNode> load() {
        for (ConfigSourceRuntimeImpl configSourceRuntimeImpl : this.allSources) {
            if (configSourceRuntimeImpl.isLazy()) {
                this.loadedData.add(new RuntimeWithData(configSourceRuntimeImpl, Optional.empty()));
                continue;
            }
            this.loadedData.add(new RuntimeWithData(configSourceRuntimeImpl, configSourceRuntimeImpl.load().map(ObjectNodeImpl::wrap).map(objectNode -> objectNode.initDescription(configSourceRuntimeImpl.description()))));
        }
        Set<String> allKeys = this.loadedData.stream().map(RuntimeWithData::data).flatMap(Optional::stream).flatMap(this::streamKeys).collect(Collectors.toSet());
        if (allKeys.isEmpty()) {
            return Optional.empty();
        }
        for (RuntimeWithData data : this.loadedData) {
            if (!data.runtime().isLazy()) continue;
            data.data(this.loadLazy(data.runtime(), allKeys));
        }
        List list = this.loadedData.stream().map(RuntimeWithData::data).flatMap(Optional::stream).collect(Collectors.toList());
        return Optional.of(this.mergingStrategy.merge(list));
    }

    private Optional<ConfigNode.ObjectNode> loadLazy(ConfigSourceRuntime runtime, Set<String> allKeys) {
        HashMap<String, ConfigNode> nodes = new HashMap<String, ConfigNode>();
        for (String key : allKeys) {
            runtime.node(key).ifPresent(it -> nodes.put(key, (ConfigNode)it));
        }
        if (nodes.isEmpty()) {
            return Optional.empty();
        }
        ConfigNode.ObjectNode.Builder builder = ConfigNode.ObjectNode.builder();
        nodes.forEach((arg_0, arg_1) -> ((ConfigNode.ObjectNode.Builder)builder).addNode(arg_0, arg_1));
        return Optional.of(builder.build());
    }

    private Stream<String> streamKeys(ConfigNode.ObjectNode objectNode) {
        return ConfigHelper.createFullKeyToNodeMap(objectNode).keySet().stream().map(ConfigKeyImpl::toString);
    }

    private static final class RuntimeWithData {
        private final ConfigSourceRuntimeImpl runtime;
        private Optional<ConfigNode.ObjectNode> data;

        private RuntimeWithData(ConfigSourceRuntimeImpl runtime, Optional<ConfigNode.ObjectNode> data) {
            this.runtime = runtime;
            this.data = data;
        }

        private void data(Optional<ConfigNode.ObjectNode> data) {
            this.data = data;
        }

        private ConfigSourceRuntimeImpl runtime() {
            return this.runtime;
        }

        private Optional<ConfigNode.ObjectNode> data() {
            return this.data;
        }

        public String toString() {
            return this.runtime.toString();
        }
    }
}

