/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.stringsubs.Substitutable;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.FileLister;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.Writer;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;

public abstract class FileSubstitutionHandler
implements Substitutable {
    private static final System.Logger LOG = System.getLogger(FileSubstitutionHandler.class.getName());
    protected static final LocalStringsImpl _strings = new LocalStringsImpl(FileLister.class);
    protected Reader _reader;
    protected Writer _writer;
    protected File _inputFile;

    public FileSubstitutionHandler(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(_strings.get("invalidFileLocation", new Object[]{file.getAbsolutePath()}));
        }
        this._inputFile = file;
    }

    @Override
    public String getName() {
        return this._inputFile.getAbsolutePath();
    }

    @Override
    public void finish() {
        block7: {
            block6: {
                if (this._reader != null) {
                    try {
                        this._reader.close();
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(System.Logger.Level.DEBUG)) break block6;
                        LOG.log(System.Logger.Level.DEBUG, _strings.get("errorInClosingStream", new Object[]{this._inputFile.getAbsolutePath()}), (Throwable)e);
                    }
                }
            }
            if (this._writer != null) {
                try {
                    this._writer.close();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(System.Logger.Level.DEBUG)) break block7;
                    LOG.log(System.Logger.Level.DEBUG, _strings.get("errorInClosingStream"), (Throwable)e);
                }
            }
        }
    }
}

