/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.manager.spi;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.AnnotationProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.faces.component.FacesComponent;
import jakarta.faces.component.behavior.FacesBehavior;
import jakarta.faces.convert.FacesConverter;
import jakarta.faces.event.NamedEvent;
import jakarta.faces.render.FacesBehaviorRenderer;
import jakarta.faces.render.FacesRenderer;
import jakarta.faces.validator.FacesValidator;
import jakarta.servlet.ServletContext;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AnnotationScanner
extends AnnotationProvider {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String WILDCARD = "*";
    protected static final Set<String> FACES_ANNOTATIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Ljakarta/faces/component/FacesComponent;", "Ljakarta/faces/convert/FacesConverter;", "Ljakarta/faces/validator/FacesValidator;", "Ljakarta/faces/render/FacesRenderer;", "Ljakarta/faces/event/NamedEvent;", "Ljakarta/faces/component/behavior/FacesBehavior;", "Ljakarta/faces/render/FacesBehaviorRenderer;", "jakarta.faces.component.FacesComponent", "jakarta.faces.convert.FacesConverter", "jakarta.faces.validator.FacesValidator", "jakarta.faces.render.FacesRenderer", "jakarta.faces.event.NamedEvent", "jakarta.faces.component.behavior.FacesBehavior", "jakarta.faces.render.FacesBehaviorRenderer")));
    protected static final Set<Class<? extends Annotation>> FACES_ANNOTATION_TYPE = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(FacesComponent.class, FacesConverter.class, FacesValidator.class, FacesRenderer.class, NamedEvent.class, FacesBehavior.class, FacesBehaviorRenderer.class)));
    private boolean isAnnotationScanPackagesSet;
    private String[] webInfClassesPackages;
    private Map<String, String[]> classpathPackages;

    public AnnotationScanner(ServletContext sc) {
        super(sc);
        WebConfiguration webConfig = WebConfiguration.getInstance(sc);
        this.initializeAnnotationScanPackages(sc, webConfig);
    }

    private void initializeAnnotationScanPackages(ServletContext sc, WebConfiguration webConfig) {
        if (!webConfig.isSet(WebConfiguration.WebContextInitParameter.AnnotationScanPackages)) {
            return;
        }
        this.isAnnotationScanPackagesSet = true;
        this.classpathPackages = new HashMap<String, String[]>(4);
        this.webInfClassesPackages = new String[0];
        String[] options = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.AnnotationScanPackages, "\\s+");
        ArrayList<String> packages = new ArrayList<String>(4);
        for (String option : options) {
            if (option.length() == 0) continue;
            if (option.startsWith("jar:")) {
                String[] parts = Util.split(sc, option, ":");
                if (parts.length != 3) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "faces.annotation.scanner.configuration.invalid", new String[]{WebConfiguration.WebContextInitParameter.AnnotationScanPackages.getQualifiedName(), option});
                    continue;
                }
                if (WILDCARD.equals(parts[1]) && !this.classpathPackages.containsKey(WILDCARD)) {
                    this.classpathPackages.clear();
                    this.classpathPackages.put(WILDCARD, this.normalizeJarPackages(Util.split(sc, parts[2], ",")));
                    continue;
                }
                if (WILDCARD.equals(parts[1]) && this.classpathPackages.containsKey(WILDCARD)) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "faces.annotation.scanner.configuration.duplicate.wildcard", new String[]{WebConfiguration.WebContextInitParameter.AnnotationScanPackages.getQualifiedName(), option});
                    continue;
                }
                if (this.classpathPackages.containsKey(WILDCARD)) continue;
                this.classpathPackages.put(parts[1], this.normalizeJarPackages(Util.split(sc, parts[2], ",")));
                continue;
            }
            if (WILDCARD.equals(option) && !packages.contains(WILDCARD)) {
                packages.clear();
                packages.add(WILDCARD);
                continue;
            }
            if (packages.contains(WILDCARD)) continue;
            packages.add(option);
        }
        this.webInfClassesPackages = packages.toArray(new String[packages.size()]);
    }

    private String[] normalizeJarPackages(String[] packages) {
        if (packages.length == 0) {
            return packages;
        }
        ArrayList<String> normalizedPackages = new ArrayList<String>(packages.length);
        for (String pkg : packages) {
            if (WILDCARD.equals(pkg)) {
                normalizedPackages.clear();
                normalizedPackages.add(WILDCARD);
                break;
            }
            normalizedPackages.add(pkg);
        }
        return normalizedPackages.toArray(new String[normalizedPackages.size()]);
    }

    protected boolean processJar(String entry) {
        return this.classpathPackages == null || this.classpathPackages.containsKey(entry) || this.classpathPackages.containsKey(WILDCARD);
    }

    protected boolean processClass(String candidate) {
        return this.processClass(candidate, this.webInfClassesPackages);
    }

    protected boolean processClass(String candidate, String[] packages) {
        if (packages == null) {
            return true;
        }
        for (String packageName : packages) {
            if (!candidate.startsWith(packageName) && !WILDCARD.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    protected Map<Class<? extends Annotation>, Set<Class<?>>> processClassList(Set<String> classList) {
        Map<Class<Annotation>, Set<Class<?>>> annotatedClasses = null;
        if (classList.size() > 0) {
            annotatedClasses = new HashMap(6, 1.0f);
            for (String className : classList) {
                try {
                    Annotation[] annotations;
                    Class clazz = Util.loadClass(className, this);
                    for (Annotation annotation : annotations = clazz.getAnnotations()) {
                        Class<? extends Annotation> annoType = annotation.annotationType();
                        if (!FACES_ANNOTATION_TYPE.contains(annoType)) continue;
                        Set<Class<?>> classes = annotatedClasses.get(annoType);
                        if (classes == null) {
                            classes = new HashSet();
                            annotatedClasses.put(annoType, classes);
                        }
                        classes.add(clazz);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, "Unable to load annotated class: {0}", className);
                    LOGGER.log(Level.SEVERE, "", cnfe);
                }
                catch (NoClassDefFoundError ncdfe) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, "Unable to load annotated class: {0}, reason: {1}", new Object[]{className, ncdfe.toString()});
                }
            }
        }
        return annotatedClasses != null ? annotatedClasses : Collections.emptyMap();
    }

    protected boolean isAnnotationScanPackagesSet() {
        return this.isAnnotationScanPackagesSet;
    }

    protected Map<String, String[]> getClasspathPackages() {
        return this.classpathPackages;
    }

    protected String[] getWebInfClassesPackages() {
        return this.webInfClassesPackages;
    }
}

