/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

final class UrlHelper {
    private static final Logger LOGGER = Logger.getLogger(UrlHelper.class.getName());
    private static final String HEAD_METHOD = "HEAD";
    static final int STATUS_NOT_FOUND = 404;

    private UrlHelper() {
    }

    static boolean isModified(URL url, Instant stamp) {
        return UrlHelper.dataStamp(url).map(newStamp -> newStamp.isAfter(stamp) || newStamp.equals(Instant.MIN)).orElse(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Optional<Instant> dataStamp(URL url) {
        block8: {
            try {
                URLConnection urlConnection = url.openConnection();
                if (!(urlConnection instanceof HttpURLConnection)) break block8;
                HttpURLConnection connection = (HttpURLConnection)urlConnection;
                try {
                    connection.setRequestMethod(HEAD_METHOD);
                    if (404 == connection.getResponseCode()) {
                        Optional<Instant> optional = Optional.empty();
                        return optional;
                    }
                    if (connection.getLastModified() != 0L) {
                        Optional<Instant> optional = Optional.of(Instant.ofEpochMilli(connection.getLastModified()));
                        return optional;
                    }
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, ex, () -> "Configuration at url '" + url + "' HEAD is not accessible.");
                return Optional.empty();
            }
        }
        Instant timestamp = Instant.MIN;
        LOGGER.finer("Missing HEAD '" + url + "' response header 'Last-Modified'. Used time '" + timestamp + "' as a content timestamp.");
        return Optional.of(timestamp);
    }
}

