/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util.jmx;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.relation.MBeanServerNotificationFilter;
import org.glassfish.admin.amx.util.ListUtil;
import org.glassfish.admin.amx.util.jmx.NotificationListenerInfo;
import org.glassfish.admin.amx.util.jmx.NotificationListenerTracking;

public final class NotificationEmitterSupport
extends NotificationBroadcasterSupport {
    private final boolean mAsyncDelivery;
    private static volatile SenderThread sSenderThread = null;
    private final Map<String, Integer> mListenerTypeCounts;
    private final NotificationListenerTracking mListeners;
    private static final String WILDCARD_TYPE = "***";
    private static final String[] ALL_TYPES = new String[]{"***"};
    private static final String[] ATTRIBUTE_CHANGE_TYPES = new String[]{"jmx.attribute.change"};
    private static final String[] MBEAN_SERVER_NOTIFICATION_TYPES = new String[]{"JMX.mbean.registered", "JMX.mbean.unregistered"};
    private final Integer COUNT_1 = 1;
    private static final Object senderThreadLock = new Object();

    public NotificationEmitterSupport(boolean asyncDelivery) {
        this.mAsyncDelivery = asyncDelivery;
        this.mListenerTypeCounts = Collections.synchronizedMap(new HashMap());
        this.mListeners = new NotificationListenerTracking(true);
    }

    public void cleanup() {
    }

    public void sendAll() {
        if (sSenderThread != null) {
            sSenderThread.waitSentAll(this);
        }
    }

    public int getListenerCount() {
        return this.mListeners.getListenerCount();
    }

    public int getNotificationTypeListenerCount(String type) {
        Integer allCount;
        Integer count = this.mListenerTypeCounts.get(type);
        int resultCount = 0;
        if (count == null && (allCount = this.mListenerTypeCounts.get(WILDCARD_TYPE)) != null) {
            resultCount = allCount;
        }
        return resultCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementListenerCountForType(String type) {
        Map<String, Integer> map = this.mListenerTypeCounts;
        synchronized (map) {
            Integer count = this.mListenerTypeCounts.get(type);
            Integer newCount = count == null ? this.COUNT_1 : Integer.valueOf(count + 1);
            this.mListenerTypeCounts.put(type, newCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementListenerCountForType(String type) {
        Map<String, Integer> map = this.mListenerTypeCounts;
        synchronized (map) {
            Integer count = this.mListenerTypeCounts.get(type);
            if (count == null) {
                throw new IllegalArgumentException(type);
            }
            int oldValue = count;
            if (oldValue == 1) {
                this.mListenerTypeCounts.remove(type);
            } else {
                this.mListenerTypeCounts.put(type, oldValue - 1);
            }
        }
    }

    private String[] getTypes(NotificationFilter filter) {
        String[] types;
        if (filter instanceof NotificationFilterSupport) {
            NotificationFilterSupport fs = (NotificationFilterSupport)filter;
            types = ListUtil.toStringArray(fs.getEnabledTypes());
        } else {
            types = filter instanceof AttributeChangeNotificationFilter ? ATTRIBUTE_CHANGE_TYPES : (filter instanceof MBeanServerNotificationFilter ? MBEAN_SERVER_NOTIFICATION_TYPES : ALL_TYPES);
        }
        return types;
    }

    private void addFilterTypeCounts(NotificationFilter filter) {
        String[] types;
        for (String type : types = this.getTypes(filter)) {
            this.incrementListenerCountForType(type);
        }
    }

    private void removeFilterTypeCounts(NotificationFilter filter) {
        String[] types;
        for (String type : types = this.getTypes(filter)) {
            this.decrementListenerCountForType(type);
        }
    }

    private void removeFilterTypeCounts(List<NotificationListenerInfo> infos) {
        for (NotificationListenerInfo info : infos) {
            this.removeFilterTypeCounts(info.getFilter());
        }
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        super.addNotificationListener(listener, filter, handback);
        this.mListeners.addNotificationListener(listener, filter, handback);
        this.addFilterTypeCounts(filter);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        super.removeNotificationListener(listener);
        List<NotificationListenerInfo> infos = this.mListeners.removeNotificationListener(listener);
        this.removeFilterTypeCounts(infos);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        super.removeNotificationListener(listener, filter, handback);
        this.mListeners.removeNotificationListener(listener);
        if (filter != null) {
            this.removeFilterTypeCounts(filter);
        }
    }

    protected void internalSendNotification(Notification notif) {
        super.sendNotification(notif);
    }

    @Override
    public synchronized void sendNotification(Notification notif) {
        if (this.getListenerCount() != 0) {
            SenderThread senderThread = NotificationEmitterSupport.getSenderThread(this.mAsyncDelivery);
            if (senderThread != null) {
                senderThread.enqueue(notif, this);
            } else {
                this.internalSendNotification(notif);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SenderThread getSenderThread(boolean asyncDelivery) {
        if (sSenderThread != null) {
            return sSenderThread;
        }
        Object object = senderThreadLock;
        synchronized (object) {
            if (sSenderThread == null) {
                SenderThread senderThread = sSenderThread = asyncDelivery ? new SenderThread() : null;
                if (sSenderThread != null) {
                    sSenderThread.start();
                }
            }
        }
        return sSenderThread;
    }

    private static final class SenderThread
    extends Thread {
        private volatile boolean mQuit;
        private final LinkedBlockingQueue<QueueItem> mPendingNotifications;

        public SenderThread() {
            this.setDaemon(true);
            this.mQuit = false;
            this.mPendingNotifications = new LinkedBlockingQueue();
        }

        public void quit() {
            this.mQuit = true;
            this.interrupt();
        }

        private void enqueue(Notification notif, NotificationEmitterSupport sender) {
            this.mPendingNotifications.add(new QueueItem(notif, sender));
        }

        public void waitSentAll(NotificationEmitterSupport sender) {
            CountDownLatchNofication notif = new CountDownLatchNofication(this);
            this.enqueue(notif, sender);
            try {
                notif.mLatch.await();
            }
            catch (InterruptedException e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Interrupted: ", e);
            }
        }

        @Override
        public void run() {
            while (!this.mQuit) {
                try {
                    QueueItem item = this.mPendingNotifications.take();
                    Notification notif = item.mNotif;
                    if (notif instanceof CountDownLatchNofication) {
                        ((CountDownLatchNofication)notif).mLatch.countDown();
                        continue;
                    }
                    item.mSender.internalSendNotification(notif);
                }
                catch (InterruptedException e) {
                    this.mQuit = true;
                }
            }
        }

        private static final class QueueItem {
            private final Notification mNotif;
            private final NotificationEmitterSupport mSender;

            public QueueItem(Notification notif, NotificationEmitterSupport sender) {
                this.mNotif = notif;
                this.mSender = sender;
            }
        }

        static final class CountDownLatchNofication
        extends Notification {
            private static final long serialVersionUID = -559038737L;
            final transient CountDownLatch mLatch = new CountDownLatch(1);

            CountDownLatchNofication(Object source) {
                super("CountDownLatchNofication", source, 0L);
            }
        }
    }
}

