/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.FileTransferCallback;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterBrokerInfoReply;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.HeartbeatService;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CommonProtocol
implements Protocol {
    private static boolean DEBUG = false;
    protected static final Logger logger = Globals.getLogger();
    protected MessageBusCallback cb = null;
    protected Cluster c = null;
    protected BrokerAddress selfAddress = null;
    protected Protocol realProtocol = null;
    protected boolean protocolInitComplete = false;
    protected long startTime = 0L;
    private Integer configServerVersion = null;
    private Object protocolInitWaitObject = new Object();

    public CommonProtocol(MessageBusCallback cb, Cluster c, BrokerAddress myaddress) {
        this.cb = cb;
        this.c = c;
        this.selfAddress = myaddress;
        this.startTime = System.currentTimeMillis();
        this.initProtocol();
    }

    @Override
    public void syncChangeRecordOnJoin(BrokerAddress broker, ChangeRecordInfo cri) throws BrokerException {
        if (!this.getProtocolInitComplete()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4241"), 503);
        }
        this.realProtocol.syncChangeRecordOnJoin(broker, cri);
    }

    @Override
    public ChangeRecordInfo getLastStoredChangeRecord() {
        if (!this.getProtocolInitComplete()) {
            throw new RuntimeException(Globals.getBrokerResources().getKString("B4241"));
        }
        return this.realProtocol.getLastStoredChangeRecord();
    }

    public RaptorProtocol getRealProtocol() {
        return (RaptorProtocol)this.realProtocol;
    }

    @Override
    public int getHighestSupportedVersion() {
        return ProtocolGlobals.getCurrentVersion();
    }

    @Override
    public int getClusterVersion() throws BrokerException {
        if (!this.getProtocolInitComplete()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4241"), 503);
        }
        try {
            if (this.c.getConfigServer() != null && this.configServerVersion != null) {
                return this.configServerVersion;
            }
        }
        catch (Exception e) {
            logger.logStack(16, "B3100", (Object)"getConfigServer()", (Throwable)e);
        }
        return this.realProtocol.getClusterVersion();
    }

    private void initProtocol() {
        if (DEBUG) {
            logger.log(4, "Using RAPTOR cluster protocol.");
        }
        try {
            this.c.useGPackets(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.realProtocol = new RaptorProtocol(this.cb, this.c, this.selfAddress, this.getBrokerInfo());
        }
        catch (Exception e) {
            logger.logStack(16, "B3100", (Object)"Initializing the cluster protcol", (Throwable)e);
        }
    }

    private void startProtocol() {
        try {
            this.realProtocol.startClusterIO();
        }
        catch (Exception e) {
            logger.logStack(16, "B3100", (Object)"start the cluster protcol", (Throwable)e);
        }
    }

    @Override
    public BrokerInfo getBrokerInfo() {
        BrokerInfo selfInfo = new BrokerInfo();
        selfInfo.setBrokerAddr(this.selfAddress);
        selfInfo.setStartTime(this.startTime);
        selfInfo.setStoreDirtyFlag(false);
        selfInfo.setClusterProtocolVersion(ProtocolGlobals.getCurrentVersion());
        if (Globals.getHAEnabled()) {
            selfInfo.setHeartbeatHostAddress(((HeartbeatService)Globals.getHeartbeatService()).getHeartbeatHostAddress());
            selfInfo.setHeartbeatPort(((HeartbeatService)Globals.getHeartbeatService()).getHeartbeatPort());
            selfInfo.setHeartbeatInterval(((HeartbeatService)Globals.getHeartbeatService()).getHeartbeatInterval());
        }
        return selfInfo;
    }

    @Override
    public ClusterBrokerInfoReply getBrokerInfoReply(BrokerInfo remote) throws Exception {
        if (this.c.getConfigServer() != null) {
            ClusterBrokerInfoReply cbi = ClusterBrokerInfoReply.newInstance(this.getBrokerInfo(), 0);
            return cbi;
        }
        if (!this.getProtocolInitComplete()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4241"), 503);
        }
        return this.realProtocol.getBrokerInfoReply(remote);
    }

    @Override
    public int addBrokerInfo(BrokerInfo brokerInfo) {
        BrokerAddress configServer;
        try {
            configServer = this.c.getConfigServer();
        }
        catch (Exception e) {
            logger.logStack(16, "B3100", (Object)"getConfigServer()", (Throwable)e);
            return 1;
        }
        if (this.getProtocolInitComplete()) {
            int pv = -1;
            try {
                pv = this.getClusterVersion();
            }
            catch (Exception e) {
                logger.log(16, "B3100", (Object)("Unable to get cluster protocol version for adding remote broker " + String.valueOf(brokerInfo.getBrokerAddr())));
                return 2;
            }
            Integer v = brokerInfo.getClusterProtocolVersion();
            if (v == null || v < pv) {
                logger.log(32, "B3100", (Object)("Cluster protocol version " + v + " of remote broker " + String.valueOf(brokerInfo.getBrokerAddr()) + " is not allowed in the cluster that has cluster protocol version " + pv));
                return 2;
            }
            return this.realProtocol.addBrokerInfo(brokerInfo);
        }
        if (configServer != null && configServer.equals(brokerInfo.getBrokerAddr())) {
            Integer masterv = brokerInfo.getClusterProtocolVersion();
            if (masterv == null || masterv < 500) {
                logger.log(32, Globals.getBrokerResources().getKString("B4410", masterv == null ? "null" : masterv.toString(), brokerInfo.getBrokerAddr()));
                return 2;
            }
            this.startProtocol();
            this.configServerVersion = masterv;
            this.setProtocolInitComplete(true);
            return this.realProtocol.addBrokerInfo(brokerInfo);
        }
        return 1;
    }

    @Override
    public void removeBrokerInfo(BrokerAddress broker, boolean broken) {
        if (this.getProtocolInitComplete()) {
            this.realProtocol.removeBrokerInfo(broker, broken);
        }
    }

    @Override
    public void setMatchProps(Properties matchProps) {
        this.c.setMatchProps(matchProps);
    }

    @Override
    public void startClusterIO() {
        if (DEBUG) {
            logger.log(4, "CommonProtocol.startClusterIO()");
        }
        try {
            BrokerAddress configServer = this.c.getConfigServer();
            if (configServer == null || configServer.equals(this.selfAddress)) {
                this.startProtocol();
                this.setProtocolInitComplete(true);
            }
        }
        catch (Exception configServer) {
            // empty catch block
        }
        try {
            this.c.start();
        }
        catch (Exception e) {
            logger.logStack(32, "B4210", (Object)"cluster", (Object)e.getMessage(), (Throwable)e);
            Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B4210", "cluster", e.getMessage()), BrokerEvent.Type.EXCEPTION);
        }
    }

    @Override
    public void stopClusterIO(boolean requestTakeover, boolean force, BrokerAddress excludedBroker) {
        if (this.realProtocol != null) {
            this.realProtocol.stopClusterIO(requestTakeover, force, excludedBroker);
        }
        this.c.shutdown(force, excludedBroker);
    }

    @Override
    public void receiveUnicast(BrokerAddress sender, GPacket gp) {
        if (DEBUG) {
            logger.log(4, "receiveUnicast GPacket");
        }
        this.realProtocol.receiveUnicast(sender, gp);
    }

    @Override
    public void receiveBroadcast(BrokerAddress sender, GPacket gp) {
        if (DEBUG) {
            logger.log(4, "receiveBroadcast GPacket");
        }
        this.realProtocol.receiveBroadcast(sender, gp);
    }

    @Override
    public void receiveUnicast(BrokerAddress sender, int destId, byte[] pkt) {
        if (DEBUG) {
            logger.log(4, "receiveUnicast");
        }
        this.realProtocol.receiveUnicast(sender, destId, pkt);
    }

    @Override
    public void receiveBroadcast(BrokerAddress sender, int destId, byte[] pkt) {
        if (DEBUG) {
            logger.log(4, "receiveBroadcast");
        }
        this.realProtocol.receiveBroadcast(sender, destId, pkt);
    }

    @Override
    public boolean waitForConfigSync() {
        BrokerAddress configServer = null;
        try {
            configServer = this.c.getConfigServer();
        }
        catch (Exception e) {
            return true;
        }
        if (configServer == null) {
            return false;
        }
        if (configServer.equals(this.selfAddress)) {
            return false;
        }
        if (!this.getProtocolInitComplete()) {
            return true;
        }
        return this.realProtocol.waitForConfigSync();
    }

    @Override
    public void reloadCluster() {
        this.waitForProtocolInit();
        this.realProtocol.reloadCluster();
    }

    @Override
    public void stopMessageFlow() throws IOException {
        this.realProtocol.stopMessageFlow();
    }

    @Override
    public void resumeMessageFlow() throws IOException {
        this.realProtocol.resumeMessageFlow();
    }

    public void sendMessage(PacketReference pkt, Collection targets, boolean sendMsgDeliveredAck) {
        this.realProtocol.sendMessage(pkt, targets, sendMsgDeliveredAck);
    }

    @Override
    public void sendMessageAck(BrokerAddress msgHome, SysMessageID sysid, ConsumerUID cuid, int ackType, Map optionalProps, boolean ackack) throws BrokerException {
        this.realProtocol.sendMessageAck(msgHome, sysid, cuid, ackType, optionalProps, ackack);
    }

    @Override
    public void sendMessageAck2P(BrokerAddress msgHome, SysMessageID[] sysids, ConsumerUID[] cuids, int ackType, Map optionalProps, Long txnID, UID txnStoreSession, boolean ackack, boolean async) throws BrokerException {
        this.realProtocol.sendMessageAck2P(msgHome, sysids, cuids, ackType, optionalProps, txnID, txnStoreSession, ackack, async);
    }

    @Override
    public void sendClusterTransactionInfo(long tid, BrokerAddress to) {
        if (!this.getProtocolInitComplete()) {
            return;
        }
        this.realProtocol.sendClusterTransactionInfo(tid, to);
    }

    @Override
    public void sendTransactionInquiry(TransactionUID tid, BrokerAddress to) {
        if (!this.getProtocolInitComplete()) {
            return;
        }
        this.realProtocol.sendTransactionInquiry(tid, to);
    }

    @Override
    public void sendPreparedTransactionInquiries(List<TransactionUID> tids, BrokerAddress to) {
        if (!this.getProtocolInitComplete()) {
            return;
        }
        this.realProtocol.sendPreparedTransactionInquiries(tids, to);
    }

    @Override
    public int getClusterAckWaitTimeout() {
        if (!this.getProtocolInitComplete()) {
            return ProtocolGlobals.getAckTimeout();
        }
        return this.realProtocol.getClusterAckWaitTimeout();
    }

    @Override
    public BrokerAddress lookupBrokerAddress(String brokerid) {
        if (!this.getProtocolInitComplete()) {
            logger.log(16, Globals.getBrokerResources().getKString("B4241") + ": lookup(" + brokerid + ")");
            return null;
        }
        return this.realProtocol.lookupBrokerAddress(brokerid);
    }

    @Override
    public BrokerAddress lookupBrokerAddress(BrokerMQAddress mqaddr) {
        if (!this.getProtocolInitComplete()) {
            logger.log(16, Globals.getBrokerResources().getKString("B4241") + ": lookup(" + String.valueOf((Object)mqaddr) + ")");
            return null;
        }
        return this.realProtocol.lookupBrokerAddress(mqaddr);
    }

    @Override
    public String lookupStoreSessionOwner(UID session) {
        if (!this.getProtocolInitComplete()) {
            logger.log(16, Globals.getBrokerResources().getKString("B4241") + ": lookup(" + String.valueOf(session) + ")");
            return null;
        }
        return this.realProtocol.lookupStoreSessionOwner(session);
    }

    @Override
    public void clientClosed(ConnectionUID conid, boolean notify) {
        if (!this.getProtocolInitComplete()) {
            return;
        }
        this.realProtocol.clientClosed(conid, notify);
    }

    @Override
    public int lockSharedResource(String resId, Object owner) {
        if (!this.getProtocolInitComplete()) {
            return 0;
        }
        return this.realProtocol.lockSharedResource(resId, owner);
    }

    @Override
    public int lockResource(String resId, long timestamp, Object owner) {
        if (!this.getProtocolInitComplete()) {
            return 0;
        }
        return this.realProtocol.lockResource(resId, timestamp, owner);
    }

    @Override
    public void unlockResource(String resId) {
        if (!this.getProtocolInitComplete()) {
            return;
        }
        this.realProtocol.unlockResource(resId);
    }

    @Override
    public void recordUpdateDestination(Destination d) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.recordUpdateDestination(d);
    }

    @Override
    public void recordRemoveDestination(Destination d) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.recordRemoveDestination(d);
    }

    @Override
    public void sendNewDestination(Destination d) throws BrokerException {
        if (d.isTemporary() && !this.getProtocolInitComplete()) {
            return;
        }
        this.waitForProtocolInit();
        this.realProtocol.sendNewDestination(d);
    }

    @Override
    public void sendRemovedDestination(Destination d) throws BrokerException {
        if (d.isTemporary() && !this.getProtocolInitComplete()) {
            return;
        }
        this.waitForProtocolInit();
        this.realProtocol.sendRemovedDestination(d);
    }

    @Override
    public void sendUpdateDestination(Destination d) throws BrokerException {
        if (d.isTemporary() && !this.getProtocolInitComplete()) {
            return;
        }
        this.waitForProtocolInit();
        this.realProtocol.sendUpdateDestination(d);
    }

    @Override
    public void recordCreateSubscription(Subscription sub) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.recordCreateSubscription(sub);
    }

    @Override
    public void recordUnsubscribe(Subscription sub) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.recordUnsubscribe(sub);
    }

    @Override
    public void sendNewSubscription(Subscription sub, Consumer cons, boolean active) throws BrokerException {
        if (!this.getProtocolInitComplete()) {
            return;
        }
        this.realProtocol.sendNewSubscription(sub, cons, active);
    }

    @Override
    public void sendNewConsumer(Consumer intr, boolean active) throws BrokerException {
        if (!this.getProtocolInitComplete()) {
            return;
        }
        this.realProtocol.sendNewConsumer(intr, active);
    }

    @Override
    public void sendRemovedConsumer(Consumer intr, Map pendingMsgs, boolean cleanup) throws BrokerException {
        if (!this.getProtocolInitComplete()) {
            return;
        }
        this.realProtocol.sendRemovedConsumer(intr, pendingMsgs, cleanup);
    }

    @Override
    public void handleGPacket(MessageBusCallback mbcb, BrokerAddress sender, GPacket pkt) {
        if (!this.getProtocolInitComplete()) {
            logger.logStack(32, "No protocol", (Throwable)new Exception("No protocol"));
            return;
        }
        this.realProtocol.handleGPacket(mbcb, sender, pkt);
    }

    @Override
    public void preTakeover(String brokerID, UID storeSession, String brokerHost, UID brokerSession) throws BrokerException {
        if (!this.getProtocolInitComplete()) {
            logger.logStack(32, "No protocol", (Throwable)new Exception("No protocol"));
            return;
        }
        this.realProtocol.preTakeover(brokerID, storeSession, brokerHost, brokerSession);
    }

    @Override
    public void postTakeover(String brokerID, UID storeSession, boolean aborted, boolean notify) {
        if (!this.getProtocolInitComplete()) {
            logger.logStack(32, "No protocol", (Throwable)new Exception("No protocol"));
            return;
        }
        this.realProtocol.postTakeover(brokerID, storeSession, aborted, notify);
    }

    @Override
    public void changeMasterBroker(BrokerMQAddress newmaster, BrokerMQAddress oldmaster) throws BrokerException {
        if (!this.getProtocolInitComplete()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4241"), 503);
        }
        this.realProtocol.changeMasterBroker(newmaster, oldmaster);
    }

    @Override
    public String sendTakeoverME(String brokerID, String uuid) throws BrokerException {
        if (!this.getProtocolInitComplete()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4241"), 503);
        }
        return this.realProtocol.sendTakeoverME(brokerID, uuid);
    }

    @Override
    public void sendMigrateStoreRequest(String targetBrokerID, Long syncTimeout, String uuid, String myBrokerID) throws BrokerException {
        if (!this.getProtocolInitComplete()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4241"), 503);
        }
        this.realProtocol.sendMigrateStoreRequest(targetBrokerID, syncTimeout, uuid, myBrokerID);
    }

    @Override
    public void transferFiles(String[] fileNames, String targetBrokerID, Long syncTimeout, String uuid, String myBrokerID, String module, FileTransferCallback callback) throws BrokerException {
        if (!this.getProtocolInitComplete()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4241"), 503);
        }
        this.realProtocol.transferFiles(fileNames, targetBrokerID, syncTimeout, uuid, myBrokerID, module, callback);
    }

    @Override
    public String sendTakeoverMEPrepare(String brokerID, byte[] token, Long syncTimeout, String uuid) throws BrokerException {
        if (!this.getProtocolInitComplete()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4241"), 503);
        }
        return this.realProtocol.sendTakeoverMEPrepare(brokerID, token, syncTimeout, uuid);
    }

    @Override
    public void notifyPartitionArrival(UID partitionID, String brokerID) throws BrokerException {
        if (!this.getProtocolInitComplete()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4241"), 503);
        }
        this.realProtocol.notifyPartitionArrival(partitionID, brokerID);
    }

    @Override
    public Hashtable getDebugState() {
        if (!this.getProtocolInitComplete()) {
            Hashtable<String, String> ht = new Hashtable<String, String>();
            ht.put("protocol", "No protocol yet");
            return ht;
        }
        return this.realProtocol.getDebugState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForProtocolInit() {
        Object object = this.protocolInitWaitObject;
        synchronized (object) {
            while (!this.getProtocolInitComplete()) {
                try {
                    logger.log(8, "B1264");
                    this.protocolInitWaitObject.wait(60000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getProtocolInitComplete() {
        Object object = this.protocolInitWaitObject;
        synchronized (object) {
            return this.protocolInitComplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProtocolInitComplete(boolean protocolInitComplete) {
        Object object = this.protocolInitWaitObject;
        synchronized (object) {
            this.protocolInitComplete = protocolInitComplete;
            this.protocolInitWaitObject.notifyAll();
        }
    }
}

