/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.provider.authorization;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.security.services.api.authorization.AzAttributeResolver;
import org.glassfish.security.services.api.authorization.AzEnvironment;
import org.glassfish.security.services.api.authorization.AzResource;
import org.glassfish.security.services.api.authorization.AzSubject;
import org.glassfish.security.services.api.authorization.RoleMappingService;
import org.glassfish.security.services.common.Secure;
import org.glassfish.security.services.config.SecurityProvider;
import org.glassfish.security.services.provider.authorization.RoleMappingProviderConfig;
import org.glassfish.security.services.spi.authorization.RoleMappingProvider;
import org.jvnet.hk2.annotations.Service;

@Service(name="simpleRoleMapping")
@Secure(accessPermissionName="security/service/rolemapper/provider/simple")
@PerLookup
public class SimpleRoleMappingProviderImpl
implements RoleMappingProvider {
    private static final Level DEBUG_LEVEL = Level.FINER;
    private static final Logger _logger = Logger.getLogger("jakarta.enterprise.security.services.provider", "org.glassfish.security.services.LogMessages");
    private static final String ADMIN = "Admin";
    private RoleMappingProviderConfig cfg;
    private boolean deployable;
    private String version;
    private Map<String, ?> options;
    @LogMessageInfo(message="Role Mapping Provider supplied an invalid resource: {0}", level="WARNING")
    private static final String ROLEPROV_BAD_RESOURCE = "SEC-PROV-00150";

    private boolean isDebug() {
        return _logger.isLoggable(DEBUG_LEVEL);
    }

    private boolean isAdminResource(AzResource resource) {
        return "admin".equals(resource.getUri().getScheme());
    }

    private boolean containsAdminGroup(AzSubject subject) {
        for (Principal p : subject.getSubject().getPrincipals()) {
            if (!"asadmin".equals(p.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initialize(SecurityProvider providerConfig) {
        this.cfg = (RoleMappingProviderConfig)providerConfig.getSecurityProviderConfig().get(0);
        this.deployable = this.cfg.getSupportRoleDeploy();
        this.version = this.cfg.getVersion();
        this.options = this.cfg.getProviderOptions();
        if (this.isDebug()) {
            _logger.log(DEBUG_LEVEL, "provider deploy:  " + this.deployable);
            _logger.log(DEBUG_LEVEL, "provider version: " + this.version);
            _logger.log(DEBUG_LEVEL, "provider options: " + String.valueOf(this.options));
        }
    }

    @Override
    public boolean isUserInRole(String appContext, AzSubject subject, AzResource resource, String role, AzEnvironment environment, List<AzAttributeResolver> resolvers) {
        boolean result = false;
        if (this.isDebug()) {
            _logger.log(DEBUG_LEVEL, "isUserInRole() - " + role);
        }
        if (!this.isAdminResource(resource)) {
            String resourceName = resource.getUri() == null ? "null" : resource.getUri().toASCIIString();
            _logger.log(Level.WARNING, ROLEPROV_BAD_RESOURCE, resourceName);
            _logger.log(Level.WARNING, "IllegalArgumentException", new IllegalArgumentException(resourceName));
        }
        if (ADMIN.equals(role)) {
            result = this.containsAdminGroup(subject);
        }
        if (this.isDebug()) {
            _logger.log(DEBUG_LEVEL, "isUserInRole() - returning " + result);
        }
        return result;
    }

    @Override
    public RoleMappingService.RoleDeploymentContext findOrCreateDeploymentContext(String appContext) {
        return null;
    }
}

