/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.ConsumerReader;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.MessageConsumerImpl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import jakarta.jms.JMSException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;

public class SessionReader
extends ConsumerReader {
    private boolean debug = Debug.debug;
    protected SessionImpl session = null;
    protected volatile MessageImpl currentMessage = null;

    public SessionReader(SessionImpl session) {
        super(session.getConnection(), session.getSessionQueue());
        this.session = session;
        if (session.acknowledgeMode == 3 && session.dupsOkAckOnTimeout) {
            if (this.debug) {
                Debug.println("**** setting dupsOkAckTimeout: " + session.dupsOkAckTimeout);
            }
            this.setTimeout(session.dupsOkAckTimeout);
        }
        this.init();
    }

    protected void setCurrentMessage(MessageImpl cm) {
        this.currentMessage = cm;
    }

    @Override
    protected void deliver(ReadOnlyPacket packet) throws IOException, JMSException {
        long interestId = 0L;
        Consumer consumer = null;
        this.currentMessage = this.getJMSMessage(packet);
        interestId = this.currentMessage.getInterestID();
        consumer = this.session.getMessageConsumer(interestId);
        if (consumer == null) {
            consumer = this.session.getBrowserConsumer(interestId);
        }
        if (consumer != null) {
            ((Consumer)consumer).onMessage(this.currentMessage);
        } else if (this.debug) {
            String errorString = AdministeredObject.cr.getKString("C4021");
            Debug.getPrintStream().println(errorString);
            packet.dump(Debug.getPrintStream());
        }
    }

    @Override
    protected void deliver() throws IOException, JMSException {
        if (!this.sessionQueue.getIsClosed()) {
            if (this.session.dupsOkAckOnTimeout) {
                if (this.debug) {
                    Debug.println("*** Calling dups ok commit from timeout thread");
                }
                this.session.syncedDupsOkCommitAcknowledge();
            }
            if (this.sessionQueue.isListenerSetLate()) {
                this.onMessageToLateListeners();
                this.sessionQueue.setListenerLate(false);
            }
        }
    }

    protected void onMessageToLateListeners() throws JMSException {
        MessageConsumerImpl consumer = null;
        Enumeration enum2 = this.session.consumers.elements();
        while (enum2.hasMoreElements()) {
            consumer = (MessageConsumerImpl)enum2.nextElement();
            if (consumer.getSyncReadFlag()) continue;
            consumer.onMessageToListenerFromReceiveQueue();
        }
    }

    protected MessageImpl getJMSMessage(ReadOnlyPacket pkt) throws JMSException {
        MessageImpl msg = this.protocolHandler.getJMSMessage(pkt);
        msg.setSession(this.session);
        return msg;
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ SessionReader dump ------");
        ps.println("Session ID: " + this.session.getSessionId());
        super.dump(ps);
    }
}

