/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.read.only;

import ee.jakarta.tck.data.framework.utilities.TestPropertyUtility;
import java.util.logging.Logger;

public interface Populator<T> {
    public static final Logger log = Logger.getLogger(Populator.class.getCanonicalName());

    public void populationLogic(T var1);

    public boolean isPopulated(T var1);

    default public void populate(T repo) {
        if (this.isPopulated(repo)) {
            return;
        }
        String repoName = repo.getClass().getSimpleName();
        log.info(repoName + " populating");
        this.populationLogic(repo);
        log.info(repoName + " waiting for eventual consistency");
        TestPropertyUtility.waitForEventualConsistency();
        log.info(repoName + " verifying");
        if (!this.isPopulated(repo)) {
            throw new RuntimeException("Repository " + repoName + " was not populated");
        }
        log.info(repoName + " populated");
    }
}

