/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.recorder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edapt.history.recorder.CommandStackListener;
import org.eclipse.emf.edapt.history.recorder.HistoryGenerator;
import org.eclipse.emf.edapt.history.recorder.IResourceLoadListener;
import org.eclipse.emf.edapt.history.util.HistoryUtils;
import org.eclipse.emf.edapt.internal.common.MetamodelExtent;
import org.eclipse.emf.edapt.internal.common.ResourceUtils;
import org.eclipse.emf.edapt.spi.history.History;
import org.eclipse.emf.edapt.spi.history.HistoryFactory;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edit.domain.EditingDomain;

public class EditingDomainListener {
    private Resource historyResource;
    private CommandStackListener commandStackListener;
    private final EditingDomain editingDomain;
    private boolean listening;
    private final Adapter resourceListener = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            Object notifier = notification.getNotifier();
            if (notifier instanceof Resource) {
                Resource resource;
                if (notification.getFeatureID(Resource.class) == 4 && !EditingDomainListener.this.isRecorded(resource = (Resource)notifier)) {
                    EditingDomainListener.this.notifyListeners(resource);
                }
            } else if (notifier instanceof ResourceSet && notification.getFeatureID(ResourceSet.class) == 0) {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }
    };
    private final List<IResourceLoadListener> listeners = new ArrayList<IResourceLoadListener>();

    public EditingDomainListener(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        this.listening = false;
    }

    public void beginListening() {
        if (this.isListening()) {
            throw new IllegalStateException("Listener already activated");
        }
        this.commandStackListener = new CommandStackListener(this.editingDomain.getCommandStack(), this.historyResource);
        this.commandStackListener.beginListening();
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.resourceListener);
        this.listening = true;
    }

    public void endListening() {
        if (!this.isListening()) {
            throw new IllegalStateException("Listener already deactivated");
        }
        this.commandStackListener.endListening();
        this.editingDomain.getResourceSet().eAdapters().remove((Object)this.resourceListener);
        this.listening = false;
    }

    public boolean isListening() {
        return this.listening;
    }

    public void resetRecorder() {
        this.commandStackListener.resetRecorder();
    }

    public boolean loadHistory() {
        block3: {
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            URI uri = HistoryUtils.getHistoryURI((Resource)((Resource)resourceSet.getResources().get(0)));
            this.historyResource = resourceSet.createResource(uri);
            try {
                this.historyResource.load(null);
                EcoreUtil.resolveAll((Resource)this.historyResource);
                if (!this.historyResource.getContents().isEmpty()) break block3;
                return false;
            }
            catch (IOException e) {
                resourceSet.getResources().remove((Object)this.historyResource);
                return false;
            }
        }
        return History.class.isInstance(this.historyResource.getContents().get(0));
    }

    public boolean isRecorded(Resource metamodel) {
        History history = this.getHistory();
        if (history == null) {
            return false;
        }
        List rootPackages = ResourceUtils.getRootElements((Resource)metamodel, EPackage.class);
        EList historyRootPackages = history.getRootPackages();
        for (EPackage rootPackage : rootPackages) {
            if (!historyRootPackages.contains(rootPackage)) continue;
            return true;
        }
        return false;
    }

    public void addHistory(Resource metamodel) {
        List rootPackages = ResourceUtils.getRootElements((Resource)metamodel, EPackage.class);
        this.getExtent().addRootPackages((Collection)rootPackages);
        HistoryUtils.setHistoryURI((Resource)metamodel, (URI)this.historyResource.getURI());
        HistoryGenerator generator = new HistoryGenerator(rootPackages);
        EList changes = generator.generate().getFirstRelease().getChanges();
        this.getHistory().getLastRelease().getChanges().addAll((Collection)changes);
    }

    public void createHistory(List<Resource> metamodelResources) {
        URI historyURI = HistoryUtils.getDefaultHistoryURI((Resource)metamodelResources.get(0));
        this.createHistory(metamodelResources, historyURI);
    }

    public void createHistory(List<Resource> metamodelResources, URI historyURI) {
        this.historyResource = this.editingDomain.getResourceSet().createResource(historyURI);
        ArrayList rootPackages = new ArrayList();
        for (Resource resource : metamodelResources) {
            HistoryUtils.setHistoryURI((Resource)resource, (URI)historyURI);
            rootPackages.addAll(ResourceUtils.getRootElements((Resource)resource, EPackage.class));
        }
        History history = new HistoryGenerator(rootPackages).generate();
        this.historyResource.getContents().add((Object)history);
    }

    public void release() {
        Release currentRelease = this.getHistory().getLastRelease();
        if (!currentRelease.getChanges().isEmpty()) {
            currentRelease.setDate(new Date());
            HistoryFactory factory = HistoryFactory.eINSTANCE;
            Release version = factory.createRelease();
            this.getHistory().getReleases().add((Object)version);
        }
    }

    public History getHistory() {
        if (this.historyResource.getContents().size() < 1) {
            return null;
        }
        History history = (History)this.historyResource.getContents().get(0);
        return history;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public MetamodelExtent getExtent() {
        return this.commandStackListener.getExtent();
    }

    public void addResourceListener(IResourceLoadListener listener) {
        this.listeners.add(listener);
    }

    public void removeResourceListener(IResourceLoadListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(Resource resource) {
        for (IResourceLoadListener listener : this.listeners) {
            listener.resourceLoaded(resource);
        }
    }
}

