/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.viewproxy.resolver;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.vertical.model.VVerticalFactory;
import org.eclipse.emf.ecp.view.spi.vertical.model.VVerticalLayout;
import org.eclipse.emf.ecp.view.spi.viewproxy.model.VViewProxy;

public class ProxyResolverViewService
implements ViewModelService {
    public static final String VIEW_MODEL_ID = "proxyId";
    private ViewModelContext context;

    public void instantiate(ViewModelContext context) {
        this.context = context;
        VView viewModel = (VView)context.getViewModel();
        this.findProxiesAndResolve(viewModel);
    }

    public void dispose() {
        this.context = null;
    }

    public int getPriority() {
        return -10;
    }

    boolean findProxiesAndResolve(VView view) {
        TreeIterator iterator = view.eAllContents();
        while (iterator.hasNext()) {
            EObject current = (EObject)iterator.next();
            if (!VViewProxy.class.isInstance(current)) continue;
            this.resolveProxy((VViewProxy)VViewProxy.class.cast(current));
        }
        return true;
    }

    private void resolveProxy(VViewProxy proxy) {
        VView view = this.resolveView(proxy);
        EStructuralFeature eContainingFeature = proxy.eContainingFeature();
        EObject eContainer = proxy.eContainer();
        EcoreUtil.remove((EObject)eContainer, (EStructuralFeature)eContainingFeature, (Object)proxy);
        if (view == null) {
            return;
        }
        if (!this.findProxiesAndResolve(view)) {
            return;
        }
        VVerticalLayout layout = VVerticalFactory.eINSTANCE.createVerticalLayout();
        layout.getChildren().addAll((Collection)view.getChildren());
        if (eContainingFeature.isMany()) {
            List list = (List)eContainer.eGet(eContainingFeature);
            list.add(layout);
        } else {
            eContainer.eSet(eContainingFeature, (Object)layout);
        }
        layout.getAttachments().addAll((Collection)proxy.getAttachments());
    }

    private VView resolveView(VViewProxy proxy) {
        EObject eObject = this.context.getDomainModel();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String id = proxy.getId() == null ? "" : proxy.getId();
        map.put(VIEW_MODEL_ID, id);
        VView view = ViewProviderHelper.getView((EObject)eObject, map);
        return view;
    }
}

