/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.celleditor.rcp;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class NativeWidgetHelper {
    private static final String WS_CARBON = "carbon";
    private static final String WS_COCOA = "cocoa";
    private static final String CHECKED_DEFAULT = "icons/checked.png";
    private static final String UNCHECKED_DEFAULT = "icons/unchecked.png";
    private static final Lock LOCK = new ReentrantLock(true);
    private static boolean initalized;
    private static final Bundle BUNDLE;
    private static final ServiceTracker<ImageRegistryService, ImageRegistryService> IMAGE_REGISTRY_SERVICE_TRACKER;
    private static ImageData checked;
    private static ImageData unchecked;
    private static Image defaultCheckedImage;
    private static Image defaultUncheckedImage;

    static {
        BUNDLE = FrameworkUtil.getBundle(NativeWidgetHelper.class);
        IMAGE_REGISTRY_SERVICE_TRACKER = new ServiceTracker(BUNDLE.getBundleContext(), ImageRegistryService.class, (ServiceTrackerCustomizer)new ImageRegistryServiceCustomizer());
        IMAGE_REGISTRY_SERVICE_TRACKER.open();
    }

    private NativeWidgetHelper() {
    }

    public static void initCheckBoxImages(Control control) {
        try {
            LOCK.lock();
            if (!initalized) {
                NativeWidgetHelper.createCheckBoxImage(control, true);
                NativeWidgetHelper.createCheckBoxImage(control, false);
                initalized = true;
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    public static Image getCheckBoxImage(Control control, CheckBoxState state) {
        try {
            LOCK.lock();
            switch (state) {
                case checked: {
                    if (checked != null) {
                        Image image = new Image((Device)control.getDisplay(), checked);
                        return image;
                    }
                    Image image = defaultCheckedImage;
                    return image;
                }
                case unchecked: {
                    if (unchecked != null) {
                        Image image = new Image((Device)control.getDisplay(), unchecked);
                        return image;
                    }
                    Image image = defaultUncheckedImage;
                    return image;
                }
            }
        }
        finally {
            LOCK.unlock();
        }
        return null;
    }

    private static void createCheckBoxImage(Control control, boolean type) {
        Point bsize;
        Display display = Display.getDefault();
        Color greenScreen = new Color((Device)display, 3, 223, 7);
        Shell shell = new Shell(control.getShell());
        ImageData imageData = null;
        shell.setBackground(greenScreen);
        if (NativeWidgetHelper.isMac()) {
            Button button2 = new Button((Composite)shell, 32);
            bsize = button2.computeSize(-1, -1);
            bsize.x = Math.max(bsize.x - 1, bsize.y - 1);
            bsize.y = Math.max(bsize.x - 1, bsize.y - 1);
            button2.setSize(bsize);
            button2.setLocation(100, 100);
        }
        Button button = new Button((Composite)shell, 32);
        button.setBackground(greenScreen);
        button.setSelection(type);
        button.setLocation(1, 1);
        bsize = button.computeSize(-1, -1);
        bsize.x = Math.max(bsize.x - 1, bsize.y - 1);
        bsize.y = Math.max(bsize.x - 1, bsize.y - 1);
        button.setSize(bsize);
        shell.setSize(bsize);
        shell.setVisible(false);
        shell.open();
        GC gc = new GC((Drawable)shell);
        Image image = new Image((Device)display, bsize.x, bsize.y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        shell.close();
        imageData = image.getImageData();
        imageData.transparentPixel = imageData.palette.getPixel(greenScreen.getRGB());
        if (type) {
            checked = imageData;
        } else {
            unchecked = imageData;
        }
        image.dispose();
    }

    private static boolean isMac() {
        String ws = SWT.getPlatform();
        return WS_CARBON.equals(ws) || WS_COCOA.equals(ws);
    }

    public static enum CheckBoxState {
        checked,
        unchecked;

    }

    private static final class ImageRegistryServiceCustomizer
    implements ServiceTrackerCustomizer<ImageRegistryService, ImageRegistryService> {
        private ImageRegistryServiceCustomizer() {
        }

        public ImageRegistryService addingService(ServiceReference<ImageRegistryService> reference) {
            ImageRegistryService result = (ImageRegistryService)BUNDLE.getBundleContext().getService(reference);
            this.onUI(() -> this.updateImages(result));
            return result;
        }

        public void modifiedService(ServiceReference<ImageRegistryService> reference, ImageRegistryService service) {
            this.onUI(() -> this.updateImages(service));
        }

        public void removedService(ServiceReference<ImageRegistryService> reference, ImageRegistryService service) {
            this.onUI(() -> this.updateImages(null));
        }

        private void onUI(Runnable action) {
            Display display = Display.getCurrent();
            if (display != null) {
                action.run();
            } else {
                Display.getDefault().syncExec(action);
            }
        }

        private void updateImages(ImageRegistryService imageRegistryService) {
            LOCK.lock();
            try {
                if (imageRegistryService != null) {
                    defaultCheckedImage = imageRegistryService.getImage(BUNDLE, NativeWidgetHelper.CHECKED_DEFAULT);
                    defaultUncheckedImage = imageRegistryService.getImage(BUNDLE, NativeWidgetHelper.UNCHECKED_DEFAULT);
                } else {
                    defaultCheckedImage = null;
                    defaultUncheckedImage = null;
                }
            }
            finally {
                LOCK.unlock();
            }
        }
    }
}

