/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.nebula.grid;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.jface.gridviewer.GridViewerColumn;

public class GridViewerColumnBuilder {
    private Boolean isResizable;
    private Boolean isMoveable;
    private String text;
    private String tooltip;
    private final Map<String, Object> data = new LinkedHashMap<String, Object>();
    private Integer width;
    private Integer style = 0;

    protected GridViewerColumn buildViewerColumn(GridTableViewer tableViewer) {
        return new GridViewerColumn(tableViewer, this.style.intValue());
    }

    public static GridViewerColumnBuilder create() {
        return new GridViewerColumnBuilder();
    }

    public GridViewerColumn build(GridTableViewer tableViewer) {
        GridViewerColumn column = this.buildViewerColumn(tableViewer);
        this.setText(column);
        this.setToolTipText(column);
        this.setResizable(column);
        this.setMoveable(column);
        this.setData(column);
        this.setWidth(column);
        return column;
    }

    public GridViewerColumnBuilder setText(String text) {
        this.text = text;
        return this;
    }

    public GridViewerColumnBuilder setToolTipText(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public GridViewerColumnBuilder setResizable(boolean isResizable) {
        this.isResizable = isResizable;
        return this;
    }

    public GridViewerColumnBuilder setMoveable(boolean isMoveable) {
        this.isMoveable = isMoveable;
        return this;
    }

    public GridViewerColumnBuilder setData(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    public GridViewerColumnBuilder setStyle(int style) {
        this.style = style;
        return this;
    }

    public GridViewerColumnBuilder setWidth(int width) {
        this.width = width;
        return this;
    }

    private void setText(GridViewerColumn column) {
        if (this.text != null) {
            column.getColumn().setText(this.text);
        }
    }

    private void setToolTipText(GridViewerColumn column) {
        if (this.tooltip != null) {
            column.getColumn().setHeaderTooltip(this.tooltip);
        }
    }

    private void setResizable(GridViewerColumn column) {
    }

    private void setMoveable(GridViewerColumn column) {
        if (this.isMoveable != null) {
            column.getColumn().setMoveable(true);
        }
    }

    private void setData(GridViewerColumn column) {
        for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            column.getColumn().setData(entry.getKey(), entry.getValue());
        }
    }

    private void setWidth(GridViewerColumn column) {
        if (this.width != null) {
            column.getColumn().setWidth(this.width.intValue());
        }
    }
}

