/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.core.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.exceptions.ECPProjectWithNameExistsException;
import org.eclipse.emf.ecp.core.util.ECPCheckoutSource;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.emfstore.core.internal.Activator;
import org.eclipse.emf.ecp.spi.core.InternalRepository;
import org.eclipse.emf.emfstore.client.ESRemoteProject;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

public class EMFStoreProjectWrapper
implements ECPCheckoutSource {
    private final InternalRepository repository;
    private final ESRemoteProject remoteProject;

    public EMFStoreProjectWrapper(InternalRepository repository, ESRemoteProject remoteProject) {
        this.repository = repository;
        this.remoteProject = remoteProject;
    }

    public ECPRepository getRepository() {
        return this.repository;
    }

    public ECPProvider getProvider() {
        return this.repository.getProvider();
    }

    public String getDefaultCheckoutName() {
        return this.remoteProject.getProjectName();
    }

    public void checkout(String projectName, ECPProperties projectProperties) throws ECPProjectWithNameExistsException {
        try {
            this.remoteProject.checkout(projectName, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ESException ex) {
            Activator.log(ex);
        }
    }

    public ESRemoteProject getCheckoutData() {
        return this.remoteProject;
    }
}

