/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.contribution;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.internal.contribution.FeatureContributor;
import org.eclipse.sirius.business.internal.contribution.ReferenceResolver;
import org.eclipse.sirius.description.contribution.Contribution;
import org.eclipse.sirius.description.contribution.FeatureContribution;
import org.eclipse.sirius.ext.base.Option;

public class ModelContributor {
    protected Set<EObject> additions;
    protected Function<Iterable<EObject>, Iterable<Contribution>> contributionFinder;
    private final ReferenceResolver resolver;

    public ModelContributor(Function<Iterable<EObject>, Iterable<Contribution>> contributionFinder, ReferenceResolver resolver) {
        this.contributionFinder = (Function)Preconditions.checkNotNull(contributionFinder);
        this.resolver = (ReferenceResolver)Preconditions.checkNotNull((Object)resolver);
    }

    public EObject apply(EObject targetModel, Collection<? extends EObject> contributionSources) {
        Preconditions.checkNotNull((Object)targetModel);
        Preconditions.checkNotNull(contributionSources);
        ArrayList allSources = Lists.newArrayList(contributionSources);
        List<Contribution> allContributions = this.findAllContributions(targetModel, allSources);
        List<ResolvedContribution> resolvedContributions = this.resolve(allContributions, allSources);
        this.additions = Sets.newHashSet();
        for (ResolvedContribution rc : resolvedContributions) {
            for (ResolvedFeatureContribution rfc : rc.getResolvedFeatureContributions()) {
                this.additions.addAll(rfc.apply());
            }
        }
        return targetModel;
    }

    public Set<EObject> getAdditions() {
        return ImmutableSet.copyOf(this.additions);
    }

    protected List<Contribution> findAllContributions(EObject targetModel, Iterable<EObject> sources) {
        return Lists.newArrayList((Iterable)((Iterable)this.contributionFinder.apply(sources)));
    }

    private List<ResolvedContribution> resolve(Collection<Contribution> contributions, List<EObject> roots) {
        ArrayList result = Lists.newArrayList();
        for (Contribution contribution : contributions) {
            HashMap context = Maps.newHashMap();
            context.put("self", contribution);
            context.put("sources", roots);
            Option<EObject> source = this.resolver.resolve(contribution.getSource(), context);
            Option<EObject> target = this.resolver.resolve(contribution.getTarget(), context);
            if (!source.some() || !target.some()) continue;
            result.add(new ResolvedContribution(contribution, (EObject)source.get(), (EObject)target.get()));
        }
        return result;
    }

    private static class ResolvedContribution {
        final Contribution contribution;
        final EObject sourceObject;
        final EObject targetObject;

        ResolvedContribution(Contribution contribution, EObject sourceObject, EObject targetObject) {
            this.contribution = contribution;
            this.sourceObject = sourceObject;
            this.targetObject = targetObject;
        }

        public Collection<ResolvedFeatureContribution> getResolvedFeatureContributions() {
            ArrayList result = Lists.newArrayListWithExpectedSize((int)this.contribution.getFeatureMask().size());
            for (FeatureContribution fc : this.contribution.getFeatureMask()) {
                result.add(new ResolvedFeatureContribution(fc, this.sourceObject, this.targetObject));
            }
            return result;
        }
    }

    private static class ResolvedFeatureContribution {
        final FeatureContribution featureContribution;
        final EObject sourceObject;
        final EObject targetObject;

        ResolvedFeatureContribution(FeatureContribution featureContribution, EObject sourceObject, EObject targetObject) {
            this.featureContribution = featureContribution;
            this.sourceObject = sourceObject;
            this.targetObject = targetObject;
        }

        public Set<EObject> apply() {
            return new FeatureContributor(this.featureContribution).apply(this.targetObject, this.sourceObject);
        }
    }
}

